/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractTuple;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.Leaf;
import com.bigdata.btree.Tuple;
import java.util.NoSuchElementException;

public class LeafTupleIterator<E>
implements ITupleIterator<E> {
    private final Leaf leaf;
    private final AbstractTuple<E> tuple;
    private int index;
    private int lastVisited = -1;
    private final int fromIndex;
    private final int toIndex;
    private final boolean hasDeleteMarkers;
    private final boolean visitDeleted;

    public LeafTupleIterator(Leaf leaf) {
        this(leaf, new Tuple(leaf.btree, 3), null, null);
    }

    public LeafTupleIterator(Leaf leaf, AbstractTuple<E> tuple) {
        this(leaf, tuple, null, null);
    }

    public LeafTupleIterator(Leaf leaf, AbstractTuple<E> tuple, byte[] fromKey, byte[] toKey) {
        int toIndex;
        int fromIndex;
        assert (leaf != null);
        assert (tuple != null);
        this.leaf = leaf;
        this.tuple = tuple;
        this.hasDeleteMarkers = leaf.hasDeleteMarkers();
        boolean bl = this.visitDeleted = (tuple.flags() & 4) != 0;
        if (fromKey != null) {
            fromIndex = leaf.getKeys().search(fromKey);
            if (fromIndex < 0) {
                fromIndex = -fromIndex - 1;
            }
        } else {
            fromIndex = 0;
        }
        this.fromIndex = fromIndex;
        if (toKey != null) {
            toIndex = leaf.getKeys().search(toKey);
            if (toIndex < 0) {
                toIndex = -toIndex - 1;
            }
        } else {
            toIndex = leaf.getKeyCount();
        }
        this.toIndex = toIndex;
        if (this.fromIndex > this.toIndex) {
            throw new IllegalArgumentException("fromKey > toKey");
        }
        this.index = this.fromIndex;
    }

    @Override
    public boolean hasNext() {
        while (this.index >= this.fromIndex && this.index < this.toIndex) {
            if (!this.hasDeleteMarkers || this.visitDeleted || !this.leaf.getDeleteMarker(this.index)) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    @Override
    public ITuple<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastVisited = this.index++;
        this.tuple.copy(this.lastVisited, this.leaf);
        return this.tuple;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

