/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bfs;

import com.bigdata.bfs.FileMetadataSchema;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.filter.TupleUpdater;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.sparse.KeyDecoder;
import com.bigdata.sparse.TPS;
import com.bigdata.sparse.TimestampChooser;
import com.bigdata.sparse.ValueType;

public class FileVersionDeleter
extends TupleUpdater<TPS.TPV> {
    private static final long serialVersionUID = -3084247827028423921L;
    private final long timestamp;
    private transient long choosenTimestamp;
    private transient boolean didInit = false;
    private transient KeyBuilder keyBuilder;

    public FileVersionDeleter(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    protected boolean isValid(ITuple<TPS.TPV> tuple) {
        KeyDecoder keyDecoder = new KeyDecoder(tuple.getKey());
        String name = keyDecoder.getColumnName();
        return name.equals(FileMetadataSchema.VERSION);
    }

    @Override
    protected void update(IIndex ndx, ITuple<TPS.TPV> tuple) {
        byte[] key = tuple.getKey();
        if (!this.didInit) {
            this.choosenTimestamp = TimestampChooser.chooseTimestamp(ndx, this.timestamp);
            this.keyBuilder = new KeyBuilder(key.length);
            this.didInit = true;
        }
        this.keyBuilder.reset().append(key, 0, key.length - 8);
        this.keyBuilder.append(this.choosenTimestamp);
        ndx.insert(key, ValueType.encode(null));
    }
}

