/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.debugging;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.debugging.OWLDebugger;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class AbstractOWLDebugger
implements OWLDebugger {
    protected final OWLOntologyManager man;
    protected final OWLDataFactory df;
    private OWLOntology ontology;

    protected AbstractOWLDebugger(OWLOntologyManager owlOntologyManager, OWLOntology ontology) {
        this.man = (OWLOntologyManager)OWLAPIPreconditions.checkNotNull((Object)owlOntologyManager, (String)"owlOntologyManager cannot be null");
        this.ontology = (OWLOntology)OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null");
        this.df = this.man.getOWLDataFactory();
        this.mergeImportsClosure();
    }

    private void mergeImportsClosure() {
        OWLOntology o = this.ontology;
        try {
            this.ontology = this.man.createOntology(IRI.getNextDocumentIRI((String)"http://debugger.semanticweb.org/ontolog"), o.importsClosure(), true);
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    protected abstract OWLClassExpression getCurrentClass() throws OWLException;

    @Override
    public OWLOntology getOWLOntology() {
        return this.ontology;
    }

    @Override
    public Set<Set<OWLAxiom>> getAllSOSForInconsistentClass(OWLClassExpression cls) throws OWLException {
        Set<OWLAxiom> firstMups = this.getSOSForInconsistentClass(cls);
        if (firstMups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Set<OWLAxiom>> allMups = new HashSet<Set<OWLAxiom>>();
        allMups.add(firstMups);
        HashSet<Set<OWLAxiom>> satPaths = new HashSet<Set<OWLAxiom>>();
        HashSet<OWLAxiom> currentPathContents = new HashSet<OWLAxiom>();
        this.constructHittingSetTree(firstMups, allMups, satPaths, currentPathContents);
        return allMups;
    }

    public void constructHittingSetTree(Set<OWLAxiom> mups, Set<Set<OWLAxiom>> allMups, Set<Set<OWLAxiom>> satPaths, Set<OWLAxiom> currentPathContents) throws OWLException {
        for (OWLAxiom axiom : mups) {
            this.man.applyChange((OWLOntologyChange)new RemoveAxiom(this.ontology, axiom));
            currentPathContents.add(axiom);
            boolean earlyTermination = false;
            for (Set<OWLAxiom> satPath : satPaths) {
                if (!satPath.containsAll(currentPathContents)) continue;
                earlyTermination = true;
                break;
            }
            this.handleLateTermination(allMups, satPaths, currentPathContents, earlyTermination);
            currentPathContents.remove(axiom);
            this.man.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, axiom));
        }
    }

    protected void handleLateTermination(Set<Set<OWLAxiom>> allMups, Set<Set<OWLAxiom>> satPaths, Set<OWLAxiom> currentPathContents, boolean earlyTermination) throws OWLException {
        if (!earlyTermination) {
            Set<OWLAxiom> newMUPS = this.getSOSForInconsistentClass(this.getCurrentClass());
            if (!newMUPS.isEmpty()) {
                if (!allMups.contains(newMUPS)) {
                    allMups.add(newMUPS);
                    this.constructHittingSetTree(newMUPS, allMups, satPaths, currentPathContents);
                }
            } else {
                satPaths.add(new HashSet<OWLAxiom>(currentPathContents));
            }
        }
    }
}

