/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.text.csv;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.QueryResultWriterBase;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;

public class SPARQLResultsCSVWriter
extends QueryResultWriterBase
implements TupleQueryResultWriter {
    private Writer writer;
    private List<String> bindingNames;

    public SPARQLResultsCSVWriter(OutputStream out) {
        OutputStreamWriter w = new OutputStreamWriter(out, Charset.forName("UTF-8"));
        this.writer = new BufferedWriter(w, 1024);
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.bindingNames = bindingNames;
        try {
            for (int i = 0; i < bindingNames.size(); ++i) {
                this.writer.write(bindingNames.get(i));
                if (i >= bindingNames.size() - 1) continue;
                this.writer.write(",");
            }
            this.writer.write("\r\n");
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        try {
            for (int i = 0; i < this.bindingNames.size(); ++i) {
                String name = this.bindingNames.get(i);
                Value value = bindingSet.getValue(name);
                if (value != null) {
                    this.writeValue(value);
                }
                if (i >= this.bindingNames.size() - 1) continue;
                this.writer.write(",");
            }
            this.writer.write("\r\n");
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public final TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.CSV;
    }

    public final TupleQueryResultFormat getQueryResultFormat() {
        return this.getTupleQueryResultFormat();
    }

    protected void writeValue(Value val) throws IOException {
        if (val instanceof Resource) {
            this.writeResource((Resource)val);
        } else {
            this.writeLiteral((Literal)val);
        }
    }

    protected void writeResource(Resource res) throws IOException {
        if (res instanceof URI) {
            this.writeURI((URI)res);
        } else {
            this.writeBNode((BNode)res);
        }
    }

    protected void writeURI(URI uri) throws IOException {
        String uriString = uri.toString();
        this.writer.write(uriString);
    }

    protected void writeBNode(BNode bNode) throws IOException {
        this.writer.write("_:");
        this.writer.write(bNode.getID());
    }

    private void writeLiteral(Literal literal) throws IOException {
        String label = literal.getLabel();
        URI datatype = literal.getDatatype();
        String language = literal.getLanguage();
        boolean quoted = false;
        if (datatype != null && (XMLDatatypeUtil.isIntegerDatatype((URI)datatype) || XMLDatatypeUtil.isDecimalDatatype((URI)datatype) || XMLSchema.DOUBLE.equals((Object)datatype))) {
            try {
                String normalized = XMLDatatypeUtil.normalize((String)label, (URI)datatype);
                this.writer.write(normalized);
                return;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (label.contains(",") || label.contains("\r") || label.contains("\n") || label.contains("\"")) {
            quoted = true;
            label = label.replaceAll("\"", "\"\"");
        }
        if (quoted) {
            this.writer.write("\"");
        }
        this.writer.write(label);
        if (quoted) {
            this.writer.write("\"");
        }
    }

    public void startDocument() throws QueryResultHandlerException {
    }

    public void handleStylesheet(String stylesheetUrl) throws QueryResultHandlerException {
    }

    public void startHeader() throws QueryResultHandlerException {
    }

    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
    }

    public void endHeader() throws QueryResultHandlerException {
    }

    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle boolean results");
    }

    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
    }
}

