/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.statements;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.jdbc.connections.JenaConnection;
import org.apache.jena.jdbc.statements.JenaStatement;
import org.apache.jena.jdbc.statements.metadata.JenaParameterMetadata;
import org.apache.jena.jdbc.utils.JdbcNodeUtils;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.util.NodeFactoryExtra;

public abstract class JenaPreparedStatement
extends JenaStatement
implements PreparedStatement {
    private ParameterizedSparqlString sparqlStr = new ParameterizedSparqlString();
    private ParameterMetaData paramMetadata;

    public JenaPreparedStatement(String sparql, JenaConnection connection, int type, int fetchDir, int fetchSize, int holdability, boolean autoCommit, int transactionLevel) throws SQLException {
        super(connection, type, fetchDir, fetchSize, holdability, autoCommit, transactionLevel);
        this.sparqlStr.setCommandText(sparql);
        this.paramMetadata = new JenaParameterMetadata(this.sparqlStr);
    }

    @Override
    public void addBatch() {
        this.addBatch(this.sparqlStr.toString());
    }

    @Override
    public void clearParameters() {
        this.sparqlStr.clearParams();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.sparqlStr.toString());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.sparqlStr.toString());
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.sparqlStr.toString());
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return this.paramMetadata;
    }

    protected final void setParameter(int parameterIndex, Node n) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.paramMetadata.getParameterCount()) {
            throw new SQLException("Parameter Index is out of bounds");
        }
        this.sparqlStr.setParam(parameterIndex - 1, n);
    }

    @Override
    public void setArray(int parameterIndex, Array value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value, int arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)value.toPlainString(), (RDFDatatype)XSDDatatype.XSDdecimal));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, int arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Boolean.toString(value), (RDFDatatype)XSDDatatype.XSDboolean));
    }

    @Override
    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Byte.toString(value), (RDFDatatype)XSDDatatype.XSDbyte));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value, int arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDate(int parameterIndex, Date value) throws SQLException {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(value.getTime());
        this.setParameter(parameterIndex, NodeFactoryExtra.dateTimeToNode((Calendar)c));
    }

    @Override
    public void setDate(int parameterIndex, Date value, Calendar arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.setParameter(parameterIndex, NodeFactoryExtra.doubleToNode((double)value));
    }

    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.setParameter(parameterIndex, NodeFactoryExtra.floatToNode((float)value));
    }

    @Override
    public void setInt(int parameterIndex, int value) throws SQLException {
        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((int)value));
    }

    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((long)value));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)value));
    }

    @Override
    public void setNull(int parameterIndex, int value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Parameters for SPARQL statements are not nullable");
    }

    @Override
    public void setNull(int parameterIndex, int value, String arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Parameters for SPARQL statements are not nullable");
    }

    @Override
    public void setObject(int parameterIndex, Object value) throws SQLException {
        if (value == null) {
            throw new SQLException("Setting a null value is not permitted");
        }
        if (value instanceof Node) {
            this.setParameter(parameterIndex, (Node)value);
        } else if (value instanceof RDFNode) {
            this.setParameter(parameterIndex, ((RDFNode)value).asNode());
        } else if (value instanceof String) {
            this.setParameter(parameterIndex, NodeFactory.createLiteral((String)((String)value)));
        } else if (value instanceof Boolean) {
            this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Boolean.toString((Boolean)value), (RDFDatatype)XSDDatatype.XSDboolean));
        } else if (value instanceof Long) {
            this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((long)((Long)value)));
        } else if (value instanceof Integer) {
            this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((int)((Integer)value)));
        } else if (value instanceof Short) {
            this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Short.toString((Short)value), (RDFDatatype)XSDDatatype.XSDshort));
        } else if (value instanceof Byte) {
            this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Byte.toString((Byte)value), (RDFDatatype)XSDDatatype.XSDbyte));
        } else if (value instanceof BigDecimal) {
            this.setParameter(parameterIndex, NodeFactory.createLiteral((String)((BigDecimal)value).toPlainString(), (RDFDatatype)XSDDatatype.XSDdecimal));
        } else if (value instanceof Float) {
            this.setParameter(parameterIndex, NodeFactoryExtra.floatToNode((float)((Float)value).floatValue()));
        } else if (value instanceof Double) {
            this.setParameter(parameterIndex, NodeFactoryExtra.doubleToNode((double)((Double)value)));
        } else if (value instanceof Date) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(((Date)value).getTime());
            this.setParameter(parameterIndex, NodeFactoryExtra.dateTimeToNode((Calendar)c));
        } else if (value instanceof Time) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(((Time)value).getTime());
            this.setParameter(parameterIndex, NodeFactoryExtra.timeToNode((Calendar)c));
        } else if (value instanceof Calendar) {
            this.setParameter(parameterIndex, NodeFactoryExtra.dateTimeToNode((Calendar)((Calendar)value)));
        } else if (value instanceof URL) {
            this.setParameter(parameterIndex, NodeFactory.createURI((String)value.toString()));
        } else if (value instanceof URI) {
            this.setParameter(parameterIndex, NodeFactory.createURI((String)value.toString()));
        } else if (value instanceof IRI) {
            this.setParameter(parameterIndex, NodeFactory.createURI((String)value.toString()));
        } else {
            throw new SQLException("setObject() received a value that could not be converted to a RDF node for use in a SPARQL query");
        }
    }

    @Override
    public void setObject(int parameterIndex, Object value, int targetSqlType) throws SQLException {
        if (value == null) {
            throw new SQLException("Setting a null value is not permitted");
        }
        try {
            switch (targetSqlType) {
                case -16: 
                case -15: 
                case -8: 
                case -7: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 0: 
                case 2: 
                case 7: 
                case 70: 
                case 1111: 
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: 
                case 2005: 
                case 2006: 
                case 2009: 
                case 2011: {
                    throw new SQLException("The provided SQL Target Type cannot be translated into an appropriate RDF term type");
                }
                case -5: {
                    if (value instanceof Long) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((long)((Long)value)));
                        break;
                    }
                    if (value instanceof Integer) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((long)((Integer)value).intValue()));
                        break;
                    }
                    if (value instanceof Short) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((long)((Short)value).shortValue()));
                        break;
                    }
                    if (value instanceof Byte) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((long)((Byte)value).byteValue()));
                        break;
                    }
                    if (value instanceof Node) {
                        long l = JdbcNodeUtils.toLong((Node)value);
                        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((long)l));
                        break;
                    }
                    if (value instanceof String) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((long)Long.parseLong((String)value)));
                        break;
                    }
                    throw new SQLException("The given value is not marshallable to the desired target type");
                }
                case 16: {
                    if (value instanceof Boolean) {
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Boolean.toString((Boolean)value), (RDFDatatype)XSDDatatype.XSDboolean));
                        break;
                    }
                    if (value instanceof Node) {
                        boolean b = JdbcNodeUtils.toBoolean((Node)value);
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Boolean.toString(b), (RDFDatatype)XSDDatatype.XSDboolean));
                        break;
                    }
                    if (value instanceof String) {
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Boolean.toString(Boolean.parseBoolean((String)value)), (RDFDatatype)XSDDatatype.XSDboolean));
                        break;
                    }
                    throw new SQLException("The given value is not marshallable to the desired target type");
                }
                case 91: {
                    if (value instanceof Date) {
                        Calendar c = Calendar.getInstance();
                        c.setTimeInMillis(((Date)value).getTime());
                        this.setParameter(parameterIndex, NodeFactoryExtra.dateTimeToNode((Calendar)c));
                        break;
                    }
                    if (value instanceof Node) {
                        Calendar c = Calendar.getInstance();
                        c.setTimeInMillis(JdbcNodeUtils.toDate((Node)value).getTime());
                        this.setParameter(parameterIndex, NodeFactoryExtra.dateTimeToNode((Calendar)c));
                        break;
                    }
                    if (value instanceof Time) {
                        Calendar c = Calendar.getInstance();
                        c.setTimeInMillis(((Time)value).getTime());
                        this.setParameter(parameterIndex, NodeFactoryExtra.timeToNode((Calendar)c));
                        break;
                    }
                    if (value instanceof Calendar) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.dateTimeToNode((Calendar)((Calendar)value)));
                        break;
                    }
                    throw new SQLException("The given value is not marshallable to the desired target type");
                }
                case 3: {
                    if (value instanceof BigDecimal) {
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)((BigDecimal)value).toPlainString(), (RDFDatatype)XSDDatatype.XSDdecimal));
                        break;
                    }
                    if (value instanceof Node) {
                        BigDecimal d = JdbcNodeUtils.toDecimal((Node)value);
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)d.toPlainString(), (RDFDatatype)XSDDatatype.XSDdecimal));
                        break;
                    }
                    throw new SQLException("The given value is not marshallable to the desired target type");
                }
                case 8: {
                    if (value instanceof Double) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.doubleToNode((double)((Double)value)));
                        break;
                    }
                    if (value instanceof Float) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.doubleToNode((double)((Float)value).floatValue()));
                        break;
                    }
                    if (value instanceof Node) {
                        Double d = JdbcNodeUtils.toDouble((Node)value);
                        this.setParameter(parameterIndex, NodeFactoryExtra.doubleToNode((double)d));
                        break;
                    }
                    throw new SQLException("The given value is not marshallable to the desired target type");
                }
                case 6: {
                    if (value instanceof Float) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.floatToNode((float)((Float)value).floatValue()));
                        break;
                    }
                    if (value instanceof Node) {
                        Float f = Float.valueOf(JdbcNodeUtils.toFloat((Node)value));
                        this.setParameter(parameterIndex, NodeFactoryExtra.floatToNode((float)f.floatValue()));
                        break;
                    }
                    throw new SQLException("The given value is not marshallable to the desired target type");
                }
                case 4: {
                    if (value instanceof Integer) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((int)((Integer)value)));
                        break;
                    }
                    if (value instanceof Short) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((int)((Short)value).shortValue()));
                        break;
                    }
                    if (value instanceof Byte) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((int)((Byte)value).byteValue()));
                        break;
                    }
                    if (value instanceof Node) {
                        Integer i = JdbcNodeUtils.toInt((Node)value);
                        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((int)i));
                        break;
                    }
                    throw new SQLException("The given value is not marshallable to the desired target type");
                }
                case 2000: {
                    if (value instanceof Node) {
                        this.setParameter(parameterIndex, (Node)value);
                        break;
                    }
                    if (value instanceof RDFNode) {
                        this.setParameter(parameterIndex, ((RDFNode)value).asNode());
                        break;
                    }
                    if (value instanceof String) {
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)((String)value)));
                        break;
                    }
                    if (value instanceof URL) {
                        this.setParameter(parameterIndex, NodeFactory.createURI((String)((URL)value).toString()));
                        break;
                    }
                    if (value instanceof URI) {
                        this.setParameter(parameterIndex, NodeFactory.createURI((String)((URI)value).toString()));
                        break;
                    }
                    if (value instanceof IRI) {
                        this.setParameter(parameterIndex, NodeFactory.createURI((String)((IRI)value).toString()));
                        break;
                    }
                    if (value instanceof BigDecimal) {
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)((BigDecimal)value).toPlainString(), (RDFDatatype)XSDDatatype.XSDdecimal));
                        break;
                    }
                    if (value instanceof Boolean) {
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Boolean.toString((Boolean)value), (RDFDatatype)XSDDatatype.XSDboolean));
                        break;
                    }
                    if (value instanceof Byte) {
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Byte.toString((Byte)value), (RDFDatatype)XSDDatatype.XSDbyte));
                        break;
                    }
                    if (value instanceof Double) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.doubleToNode((double)((Double)value)));
                        break;
                    }
                    if (value instanceof Float) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.floatToNode((float)((Float)value).floatValue()));
                        break;
                    }
                    if (value instanceof Short) {
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Short.toString((Short)value), (RDFDatatype)XSDDatatype.XSDshort));
                        break;
                    }
                    if (value instanceof Integer) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((int)((Integer)value)));
                        break;
                    }
                    if (value instanceof Long) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.intToNode((long)((Long)value)));
                        break;
                    }
                    if (value instanceof Date) {
                        Calendar c = Calendar.getInstance();
                        c.setTimeInMillis(((Date)value).getTime());
                        this.setParameter(parameterIndex, NodeFactoryExtra.dateTimeToNode((Calendar)c));
                        break;
                    }
                    if (value instanceof Time) {
                        Calendar c = Calendar.getInstance();
                        c.setTimeInMillis(((Time)value).getTime());
                        this.setParameter(parameterIndex, NodeFactoryExtra.timeToNode((Calendar)c));
                        break;
                    }
                    if (value instanceof Calendar) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.dateTimeToNode((Calendar)((Calendar)value)));
                        break;
                    }
                    this.setParameter(parameterIndex, NodeFactory.createLiteral((String)value.toString()));
                    break;
                }
                case -9: 
                case 1: 
                case 12: {
                    this.setParameter(parameterIndex, NodeFactory.createLiteral((String)value.toString()));
                    break;
                }
                case 5: {
                    if (value instanceof Short) {
                        Short s = (Short)value;
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Short.toString(s), (RDFDatatype)XSDDatatype.XSDshort));
                        break;
                    }
                    if (value instanceof Byte) {
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Short.toString(((Byte)value).byteValue()), (RDFDatatype)XSDDatatype.XSDshort));
                        break;
                    }
                    if (value instanceof Node) {
                        Short s = JdbcNodeUtils.toShort((Node)value);
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Short.toString(s), (RDFDatatype)XSDDatatype.XSDshort));
                        break;
                    }
                    if (value instanceof String) {
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Short.toString(Short.parseShort((String)value)), (RDFDatatype)XSDDatatype.XSDshort));
                        break;
                    }
                    throw new SQLException("The given value is not marshallable to the desired type");
                }
                case 92: {
                    if (value instanceof Time) {
                        Calendar c = Calendar.getInstance();
                        c.setTimeInMillis(((Time)value).getTime());
                        this.setParameter(parameterIndex, NodeFactoryExtra.timeToNode((Calendar)c));
                        break;
                    }
                    if (value instanceof Node) {
                        Calendar c = Calendar.getInstance();
                        c.setTimeInMillis(JdbcNodeUtils.toDate((Node)value).getTime());
                        this.setParameter(parameterIndex, NodeFactoryExtra.timeToNode((Calendar)c));
                        break;
                    }
                    if (value instanceof Date) {
                        Calendar c = Calendar.getInstance();
                        c.setTimeInMillis(((Date)value).getTime());
                        this.setParameter(parameterIndex, NodeFactoryExtra.timeToNode((Calendar)c));
                        break;
                    }
                    if (value instanceof Calendar) {
                        this.setParameter(parameterIndex, NodeFactoryExtra.timeToNode((Calendar)((Calendar)value)));
                        break;
                    }
                    throw new SQLException("The given value is not marshallable to the desired type");
                }
                case -6: {
                    if (value instanceof Byte) {
                        Byte b = (Byte)value;
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Byte.toString(b), (RDFDatatype)XSDDatatype.XSDbyte));
                        break;
                    }
                    if (value instanceof Node) {
                        Byte b = JdbcNodeUtils.toByte((Node)value);
                        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Byte.toString(b), (RDFDatatype)XSDDatatype.XSDbyte));
                        break;
                    }
                    throw new SQLException("The given value is not marshallable to the desired type");
                }
                default: {
                    throw new SQLException("Cannot translate an unknown SQL Target Type into an appropriate RDF term type");
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SQLException("Unexpected error trying to marshal a value to the desired target type", e);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object value, int arg2, int arg3) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int parameterIndex, Ref value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)Short.toString(value), (RDFDatatype)XSDDatatype.XSDshort));
    }

    @Override
    public void setString(int parameterIndex, String value) throws SQLException {
        this.setParameter(parameterIndex, NodeFactory.createLiteral((String)value));
    }

    @Override
    public void setTime(int parameterIndex, Time value) throws SQLException {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.setTimeInMillis(value.getTime());
        this.setParameter(parameterIndex, NodeFactoryExtra.timeToNode((Calendar)c));
    }

    @Override
    public void setTime(int parameterIndex, Time value, Calendar arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value, Calendar arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setURL(int parameterIndex, URL value) throws SQLException {
        this.setParameter(parameterIndex, NodeFactory.createURI((String)value.toString()));
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream value, int arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public ParameterizedSparqlString getParameterizedString() {
        return this.sparqlStr.copy();
    }
}

