/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.statements;

import java.sql.SQLException;
import org.apache.jena.jdbc.connections.DatasetConnection;
import org.apache.jena.jdbc.statements.JenaStatement;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.update.GraphStoreFactory;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetStatement
extends JenaStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetStatement.class);
    private DatasetConnection dsConn;

    public DatasetStatement(DatasetConnection connection) throws SQLException {
        this(connection, 1003, 1000, 0, 2, true, 0);
    }

    public DatasetStatement(DatasetConnection connection, int type, int fetchDir, int fetchSize, int holdability, boolean autoCommit, int transactionLevel) throws SQLException {
        super(connection, type, fetchDir, fetchSize, holdability, autoCommit, transactionLevel);
        this.dsConn = connection;
    }

    @Override
    protected QueryExecution createQueryExecution(Query q) {
        return QueryExecutionFactory.create((Query)q, (Dataset)this.dsConn.getJenaDataset());
    }

    @Override
    protected UpdateProcessor createUpdateProcessor(UpdateRequest u) {
        return UpdateExecutionFactory.create((UpdateRequest)u, (DatasetGraph)GraphStoreFactory.create((Dataset)this.dsConn.getJenaDataset()));
    }

    @Override
    protected void beginTransaction(ReadWrite type) throws SQLException {
        try {
            this.dsConn.begin(type);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error starting a transaction", (Throwable)e);
            throw new SQLException("Unexpected error starting a transaction", e);
        }
    }

    @Override
    protected void commitTransaction() throws SQLException {
        try {
            this.dsConn.commit();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error committing a transaction", (Throwable)e);
            throw new SQLException("Unexpected error committing a transaction", e);
        }
    }

    @Override
    protected void rollbackTransaction() throws SQLException {
        try {
            this.dsConn.rollback();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error rolling back a transaction", (Throwable)e);
            throw new SQLException("Unexpected error rolling back a transaction", e);
        }
    }

    @Override
    protected boolean hasActiveTransaction() {
        return this.dsConn.getJenaDataset().isInTransaction();
    }
}

