# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_telegram',
 'django_telegram.bot',
 'django_telegram.bot.decorators',
 'django_telegram.bot.errors',
 'django_telegram.bot.management',
 'django_telegram.bot.renderers']

package_data = \
{'': ['*']}

install_requires = \
['django==2.2.19', 'python-telegram-bot>=13.3,<14.0']

setup_kwargs = {
    'name': 'telegram-django',
    'version': '1.0.3',
    'description': 'Django Telegram Bot',
    'long_description': "# Django Telegram Bot\n\n![pyversions](https://img.shields.io/pypi/pyversions/telegram-django.svg) [![PyPi Status](https://img.shields.io/pypi/v/telegram-django.svg)](https://pypi.org/project/telegram-django/) [![Build Django Telegram Bot](https://github.com/cloudblue/telegram-django/actions/workflows/build.yml/badge.svg)](https://github.com/cloudblue/telegram-django/actions/workflows/build.yml) [![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=telegram-django&metric=alert_status)](https://sonarcloud.io/dashboard?id=telegram-django) [![Coverage](https://sonarcloud.io/api/project_badges/measure?project=telegram-django&metric=coverage)](https://sonarcloud.io/dashboard?id=telegram-django) [![Maintainability Rating](https://sonarcloud.io/api/project_badges/measure?project=telegram-django&metric=sqale_rating)](https://sonarcloud.io/dashboard?id=telegram-django)\n\n## Introduction\n\n`Django Telegram Bot` is the base class which helps to build custom commands for the django models. It allows getting historical data from django models, as well as develop custom pre-defined filters and execute custom django management commands (i.e. those which are executed through  `python manage.py $command`)\n\n## Install\n\n`Django Telegram Bot` requires python 3.8 or later and has the following dependencies:\n\n* python-telegram-bot >=13.3\n* django>=2.2.19\n\n`Django Telegram Bot` can be installed from [pypi.org](https://pypi.org/project/telegram-django/) using pip:\n\n```\n$ pip install telegram-django\n```\n\n## Running The Bot\n### Define your command class extending the base\n\nFor example:\n\n``` \n\nfrom myapp.models import MyAppModel\n\nfrom telegram_bot.telegram_conversation import TelegramConversation\n\n\nclass MyAppConversation(TelegramConversation):\n    def __init__(self, logger, model_datetime_property, suffix):\n        super().__init__(logger, model_datetime_property, suffix)\n        self.model = MyAppModel\n\n    @property\n    def custom_commands(self):\n        return [\n            'custom_command1',\n        ]\n        \n    @property\n    def saved_filters(self):\n        return [\n            'count',\n        ]\n\n    def get_count(self, update):\n        amount = self._get_initial_queryset().count()\n        self._reply(update, amount)\n        self._default_query_context()\n\n\n```\n\nThe method ```custom_commands``` must return a list of defined django commands which can be executed by this conversation handler. These commands are standard django commands which are normally executed via ```python manage.py $command```.\nThe method ```saved_filters``` must return a list of defined custom filters. The filter's body must be implemented in the same class using the convention ```get_$filter_name```, like in the example above: for ```count``` filter the ```get_count``` method is implemented.\n\nAdd the following sections to your ```settings.py```:\n\nDefine application in ```INSTALLED_APPS```\n```\n    INSTALLED_APPS = [\n        ...\n        'django_telegram.bot',\n        ...\n    ]\n```\nAdd section ```TELEGRAM_BOT``` for bot configuration\n```\nTELEGRAM_BOT = {\n    'CONVERSATIONS': [\n        'myapp.package1.package2.MyAppConversation',\n    ],\n    'TOKEN': '',\n    'COMMANDS_SUFFIX': None,\n    'HISTORY_LOOKUP_MODEL_PROPERTY': ''\n}\n```\nAdd section ```django_telegram_bot``` to logger configuration\n```\nLOGGING = {\n...\n    'loggers': {\n...\n        'django_telegram_bot': {\n            'handlers': ['console'],\n            'level': 'INFO',\n        },\n...\n    },\n...\n}\n```\n\nSettings description:\n\n| Variable      | Description  |\n| ------------- |:-------------|\n|`TOKEN`|Telegram Token for the bot. Please refer to https://core.telegram.org/bots on how to create a bot.|\n|`CONVERSATIONS`|List of FQDNs for classes which implement and provide conversation instances|\n|`HISTORY_LOOKUP_MODEL_PROPERTY`|Property of the django model of DateTime type which is used to do history lookups|\n|`COMMANDS_SUFFIX`|In case of having multiple instances of the bot (with the same commands) we want to add some suffix to the commands, so that only specific bot is getting the command, so command becomes `myappconversation_${SUFFIX}`. If there is no need to have multiple instances of the same bot in the chat -- just leave this as ```None```. |\n\n### Running The Bot\n\n`python manage.py start_bot`\n\n## Testing\n\n* Create virtualenv\n* Install project dependencies\n```commandline\npython -m pip install --upgrade pip\npip install poetry\npoetry update\n```\n* Run tests\n```commandline\npoetry run pytest\n```\n\n\n## License\n\n``Django Telegram Bot`` is released under the [Apache License Version 2.0](https://www.apache.org/licenses/LICENSE-2.0).",
    'author': 'CloudBlue LLC',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://connect.cloudblue.com',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
