"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const kong_core = require("kong-core");
// import * as kong_core from '../../kong-core/';
const index_1 = require("./resources/helm-charts/kong/index");
/**
 * @summary The KongEks class.
 */
class KongEks extends constructs_1.Construct {
    //   public readonly rdsCluster: rds.DatabaseInstance;
    //   public readonly eksCluster: eks.Cluster;
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        //TODO : Modularize this further
        const kong_namespace = 'kong-dp';
        const data_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'DPSecretsKey');
        // const data_plane_secretskey = new kms.Key(this, 'DataPlaneSecretsKey');
        // const artifactoryBucket = new s3.Bucket(this, 'ArtifactoryBucket');
        const data_plane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'DP', {
            ...props.dataPlaneClusterProps,
            secretsEncryptionKey: data_plane_secretskey,
            defaultCapacity: 0,
        });
        const dp_nodegroup = data_plane.addNodegroupCapacity('DpASG', props.dataPlaneNodeProps);
        dp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: data_plane,
            nodegroup: dp_nodegroup,
            namespace: 'kube-system',
        });
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: data_plane,
        //   nodegroup: dp_nodegroup,
        // });
        // TODO : Make a new construct class for all helm charts
        new kong_core.MetricsServer(this, 'MetricsServer', {
            cluster: data_plane,
        });
        // new ElastiCacheStack(this, 'KongCache', {
        //   numberofnodegroups: 3,
        //   vpc: data_plane.vpc,
        // });
        const aws_cert_manager_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'AwsCertManagerStack');
        const cert_manager = new kong_core.AwsCertManager(aws_cert_manager_nested_stack, 'AwsCertManager', {
            cluster: data_plane,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            privateCaArn: props.privateCaArn,
        });
        // const cert_manager = new kong_core.CertManager(this, 'KongDpCertManager', {
        //   cluster: data_plane,
        //   nodegroup: dp_nodegroup,
        //   namespace: kong_namespace,
        //   privateCaArn: props.privateCaArn,
        //   cacertname: kong_core.Tls.KONG_DP_CERTNAME,
        //   clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
        //   // commonname: 'www.dummy.com',
        //   hostedZoneName: 'kong-dp.internal',
        //   dnsNames: [
        //     'kong-dp.internal',
        //     'admin.kong-cp.internal',
        //     'cluster.kong-cp.internal',
        //     'telemetry.kong-cp.internal',
        //     'manager.kong-cp.internal',
        //   ],
        // });
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryStack');
        new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            cluster: data_plane,
            namespace: kong_core.Namespace.TELEMETRY,
            cacertname: kong_core.Tls.ADOT_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            dnsNames: [
                'kong-dp.internal',
                'admin.kong-cp.internal',
                'cluster.kong-cp.internal',
                'telemetry.kong-cp.internal',
                'manager.kong-cp.internal',
            ],
            hostedZoneName: 'kong-dp.internal',
        });
        telemetry_nested_stack.node.addDependency(cert_manager);
        const kong_data_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongDpStack');
        const kong_data_plane = new index_1.KongDataPlane(kong_data_plane_nested_stack, 'KongDPHelmInstall', {
            cluster: data_plane,
            namespace: kong_namespace,
            cluster_dns: props.clusterDns,
            telemetry_dns: props.telemetryDns,
            nodegroup: dp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            cacertname: kong_core.Tls.ADOT_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            dnsNames: [
                'kong-dp.internal',
                'admin.kong-cp.internal',
                'cluster.kong-cp.internal',
                'telemetry.kong-cp.internal',
                'manager.kong-cp.internal',
            ],
            hostedZoneName: 'kong-dp.internal',
        });
        kong_data_plane.node.addDependency(cert_manager);
    }
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-data-plane.KongEks", version: "2.0.3" };
//# sourceMappingURL=data:application/json;base64,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