# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ButtonResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ButtonResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'text': 'str',
            'payload': 'str',
            'message_type': 'str'
        }

        self.attribute_map = {
            'type': 'type',
            'text': 'text',
            'payload': 'payload',
            'message_type': 'messageType'
        }

        self._type = None
        self._text = None
        self._payload = None
        self._message_type = None

    @property
    def type(self):
        """
        Gets the type of this ButtonResponse.
        Button response type that captures Button and QuickReply type responses

        :return: The type of this ButtonResponse.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ButtonResponse.
        Button response type that captures Button and QuickReply type responses

        :param type: The type of this ButtonResponse.
        :type: str
        """
        allowed_values = ["Button", "QuickReply"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def text(self):
        """
        Gets the text of this ButtonResponse.
        Text to show inside the Button reply. This is also used as the response text after clicking on the Button.

        :return: The text of this ButtonResponse.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this ButtonResponse.
        Text to show inside the Button reply. This is also used as the response text after clicking on the Button.

        :param text: The text of this ButtonResponse.
        :type: str
        """
        
        self._text = text

    @property
    def payload(self):
        """
        Gets the payload of this ButtonResponse.
        Content of the textback payload after clicking a button

        :return: The payload of this ButtonResponse.
        :rtype: str
        """
        return self._payload

    @payload.setter
    def payload(self, payload):
        """
        Sets the payload of this ButtonResponse.
        Content of the textback payload after clicking a button

        :param payload: The payload of this ButtonResponse.
        :type: str
        """
        
        self._payload = payload

    @property
    def message_type(self):
        """
        Gets the message_type of this ButtonResponse.
        Button response message type that captures QuickReply , Cards and Carousel .This is used  as label for Card selection

        :return: The message_type of this ButtonResponse.
        :rtype: str
        """
        return self._message_type

    @message_type.setter
    def message_type(self, message_type):
        """
        Sets the message_type of this ButtonResponse.
        Button response message type that captures QuickReply , Cards and Carousel .This is used  as label for Card selection

        :param message_type: The message_type of this ButtonResponse.
        :type: str
        """
        allowed_values = ["QuickReply", "Card", "Carousel"]
        if message_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for message_type -> " + message_type)
            self._message_type = "outdated_sdk_version"
        else:
            self._message_type = message_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

