from setuptools import setup, find_packages
from pathlib import Path

# Force UTF-8 reading of README (fixes Windows UnicodeDecodeError)
this_directory = Path(__file__).parent
long_description = (this_directory / "README.md").read_text(encoding="utf-8")

setup(
    name="yates_rng",
    version="0.1.6",
    author="Shiv Shankar N",
    author_email="shivshankar11a@gmail.com",
    description="Random search, shuffle, and pick using a custom RanBit RNG and fisher-yates algorithm",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/Shivxr/yates_rng",
    packages=find_packages(),
    python_requires=">=3.7",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
)
