📦 yates_rng

Yates RNG is a lightweight Python package that provides:

A custom ultra-fast XOR-shift inspired random generator (RanBit)

Randomized array search (domino_search)

Random shuffle (domino_shuffle)

Random element picking (domino_pick)

All randomness is powered by the RanBit engine, which uses a time-based seed to produce a new pseudo-random sequence on each run.

Inspired by the X-Men character Domino, this package focuses on probability manipulation, fast randomness, and lightweight random utilities.

🚀 Features

🔥 RanBit — fast custom random number generator

🔄 domino_search — random search with neighbor optimization

🔀 domino_shuffle — random array shuffling

🎯 domino_pick — fast random element selector

⏱️ Time-seeded RNG: every run produces unique randomness

🧩 No external dependencies

⚡ Very lightweight and fast — optimized for small/medium arrays

🎮 Great for games, probabilistic algorithms, randomized utilities

📥 Installation

Once published to PyPI:

pip install domino_rng

📘 Usage
💠 Import the functions
from yates_rng import domino_search, domino_shuffle, domino_pick

🔍 Example — Random Search
from yates_rng import domino_search

arr = [2, 5, 6, 7, 2, 10]
result = domino_search(arr, 10)

print("Found at search iteration:", result)


domino_search returns the iteration number at which the target is found.

🔀 Example — Shuffle an Array
from yates_rng import domino_shuffle

arr = [5, 1, 4, 8, 2, 11, 0, -1, 2]
shuffled = domino_shuffle(arr)

print(shuffled)


Each run produces a different random shuffle.

🎯 Example — Random Pick
from yates_rng import domino_pick

print(domino_pick([1, 2, 3, 4, 5]))


Returns a random element from the list.

🧠 Algorithm Details
RanBit — Custom Random Generator

Domino RNG uses a custom XOR-shift algorithm:

x ^= x << 13
x ^= x >> 17
x ^= x << 5


This produces a fast 32-bit pseudo-random sequence.
A time-based seed (time.time() * 1000) ensures every program run is unique.

domino_search — Random Search with Neighbor Check

This search algorithm:

Randomly selects an index r

Also checks the neighbor r-1

If either matches the target, search ends

Otherwise, the two checked elements are swapped away from the search range

Search becomes faster and avoids repeated checks

It produces a probabilistic search sequence that reduces redundant operations.

domino_shuffle — Randomized Fisher-Yates Variant

Randomly picks an index using RanBit

Swaps it with the current end of the array

Moves the boundary to avoid reusing elements

Very fast and lightweight

📦 Project Structure
yates_rng/
│
├── yates_rng/
│   ├── __init__.py
│   ├── yates.py
│  
│
├── setup.py
├── README.md
└── LICENSE

🛠️ Implementation Philosophy

Keep RNG internal and invisible to user

Expose simple API functions only

Maintain a clean, minimal interface

Provide deterministic logic without external dependencies

Make randomness fast, small, and efficient

🧪 Performance Notes

Faster than Python's built-in random for small array operations

Ideal for:

random searching

small Monte-Carlo steps

shuffling lists

producing quick random choices

game logic where lightweight RNG is needed

Not a cryptographic RNG

⚠️ Disclaimer

This RNG is not suitable for:

Cryptographic security

Scientific simulations requiring high-quality random distribution

It is intended for lightweight, high-speed probabilistic operations.

👨‍💻 Author

Shiv Shankar N
Developer of the Domino RNG package.

⭐ Contribution

Pull requests and suggestions are welcome.
Feel free to open issues for discussions or improvements.

📄 License

MIT License
Free to use, modify, and distribute.