"""
Django settings for frame_server project.

Generated by 'django-admin startproject' using Django 3.2.13.

For more information on this file, see
https://docs.djangoproject.com/en/3.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.2/ref/settings/
"""
import os
from pathlib import Path
import configparser
config = configparser.ConfigParser()

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent
RESOURCE_ROOT = os.path.join(BASE_DIR, 'data')

ENVIRONMENT = os.environ.get('SERVER_CFG', 'dist')

config.read(os.path.join(BASE_DIR, 'config_%s' % ENVIRONMENT))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/3.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'django-insecure-bkx*!i8fr%!=f391n8w0%ht43=3(n!%n$7f96bk5uyzc_k7yu*'

# SECURITY WARNING: don't run with debug turned on in production!
if ENVIRONMENT in ['dev', 'dist']:
    DEBUG = True
else:
    DEBUG = False

# 自定义白名单访问域名，格式：.xxx.com.cn,127.0.0.1
CUSTOM_WHITELIST_HOSTS = os.environ.get('WHITELIST_HOSTS') or config['base'].get('whitelist_hosts')
if CUSTOM_WHITELIST_HOSTS and CUSTOM_WHITELIST_HOSTS != '*':
    CK_CUSTOM_WHITELIST_HOSTS = CUSTOM_WHITELIST_HOSTS.split(',')
    ALLOWED_HOSTS = [cwh for cwh in CK_CUSTOM_WHITELIST_HOSTS if cwh]
else:
    ALLOWED_HOSTS = ['*']

AUTH_USER_MODEL = 'app.Members'

# Application definition

INSTALLED_APPS = [
    'simpleui',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',

    # 第三方依赖库
    'rest_framework',
    'rest_framework.authtoken',
    'django_filters',
    'corsheaders',
    'django_cas_ng',
    'django_celery_beat',
    'django_celery_results',
    'drf_yasg',
    'app',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    # 自定义全局请求中间件
    'utils.comm.middleware.GlobalRequestMiddleware.GlobalRequestMiddleware',
]

ROOT_URLCONF = 'frame_server.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'frame_server.wsgi.application'


# Database
# https://docs.djangoproject.com/en/3.2/ref/settings/#databases
DB_ENGINE = os.environ.get('DB_ENGINE') or config['db']['engine']

if DB_ENGINE and DB_ENGINE.lower() == 'mysql':
    DB_NAME = os.environ.get('DB_NAME') or config['db']['name']
    DB_HOST = os.environ.get('DB_HOST') or config['db']['host']
    DB_PORT = os.environ.get('DB_PORT') or config['db']['port']
    DB_USER = os.environ.get('DB_USER') or config['db']['user']
    DB_PASSWORD = os.environ.get('DB_PASSWORD') or config['db']['password']

    DATABASES = {
        'default': {
            'ENGINE': 'django.db.backends.{}'.format(DB_ENGINE.lower()),
            'NAME': DB_NAME,
            'HOST': DB_HOST,
            'PORT': DB_PORT,
            'USER': DB_USER,
            'PASSWORD': DB_PASSWORD
        }
    }
else:
    SQLITE_DATA = os.environ.get('SQLITE_DATA') or BASE_DIR
    if not os.path.exists(SQLITE_DATA):
        os.makedirs(SQLITE_DATA)
    DATABASES = {
        'default': {
            'ENGINE': 'django.db.backends.sqlite3',
            'NAME': SQLITE_DATA / 'db.sqlite3',
        }
    }


# Password validation
# https://docs.djangoproject.com/en/3.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/3.2/topics/i18n/

LANGUAGE_CODE = 'zh-Hans'

TIME_ZONE = 'Asia/Shanghai'

USE_I18N = True

USE_L10N = True

USE_TZ = False


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/3.2/howto/static-files/

STATIC_URL = '/static/'

STATIC_ROOT = os.path.join(BASE_DIR, "data", "static")
if not os.path.exists(STATIC_ROOT):
    os.makedirs(STATIC_ROOT)

# Default primary key field type
# https://docs.djangoproject.com/en/3.2/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'

# 配置跨域
CORS_ALLOW_CREDENTIALS = True
CORS_ORIGIN_ALLOW_ALL = True
CORS_ORIGIN_WHITELIST = []
CK_CORS_ORIGIN_WHITELIST = os.environ.get('CORS_ORIGIN_WHITELIST') or config['base'].get('cors_origin_whitelist')
if CK_CORS_ORIGIN_WHITELIST:
    CORS_ORIGIN_ALLOW_ALL = False
    for origin_white in CK_CORS_ORIGIN_WHITELIST.split(','):
        if 'https://' in origin_white or 'http://' in origin_white:
            CORS_ORIGIN_WHITELIST.append(origin_white)
        else:
            CORS_ORIGIN_WHITELIST.append('http://{}'.format(origin_white))
            CORS_ORIGIN_WHITELIST.append('https://{}'.format(origin_white))

CORS_ALLOW_METHODS = (
    'DELETE',
    'GET',
    'OPTIONS',
    'PATCH',
    'POST',
    'PUT',
    'VIEW',
)

CORS_ALLOW_HEADERS = (
    'XMLHttpRequest',
    'X_FILENAME',
    'accept',
    'accept-encoding',
    'authorization',
    'content-type',
    'dnt',
    'origin',
    'user-agent',
    'x-csrftoken',
    'x-requested-with',
    'Pragma',
)

# Logging setting
LOG_LEVEL = os.environ.get('LOG_LEVEL') or config['base']['log_level']
if LOG_LEVEL not in ['DEBUG', 'INFO']:
    LOG_LEVEL = 'DEBUG'

# 新增模块注册日志
loggers_app = [
    "utils.frame",
]
from .log import CustomLogConfig
LOGGING = CustomLogConfig().set_logging(LOG_LEVEL, loggers_app)


# 配置异步
from kombu import Queue
REDIS_HOST = os.environ.get('RD_HOST') or config['redis']['rd_host']
REDIS_PASSWORD = os.environ.get('RD_PASSWORD') or config['redis']['rd_password']
REDIS_PORT = os.environ.get('RD_PORT') or config['redis']['rd_port']
REDIS_BASE_DB = os.environ.get('RD_BASE_DB') or config['redis']['base_db']

# Redis 连接池 DB
REDIS_CONSTANCE_DB = os.environ.get('RD_CONSTANCE_DB') or config['redis']['constance_db']

# backer 存储生产者消息 DB
REDIS_BROKER_DB = os.environ.get('RD_BROKER_DB') or config['redis']['broker_db']

# celery 缓存 DB
REDIS_CELERY_CACHE_DB = os.environ.get('RD_CELERY_CACHE_DB') or config['redis']['celery_cache_db']
# celery 结果存储 DB
REDIS_CELERY_RESULT_DB = os.environ.get('RD_CELERY_RESULT_DB') or config['redis']['celery_result_db']

# redis 连接池
CONSTANCE_REDIS_CONNECTION = f"redis://:{REDIS_PASSWORD}@{REDIS_HOST}:{REDIS_PORT}/{REDIS_CONSTANCE_DB}"

# backer 存储生产者消息
BROKER_URL = f"redis://:{REDIS_PASSWORD}@{REDIS_HOST}:{REDIS_PORT}/{REDIS_BROKER_DB}"

# celery 定时任务中间件
CELERYBEAT_SCHEDULER = "django_celery_beat.schedulers.DatabaseScheduler"

# celery 处理结果保存
CELERY_RESULT_BACKEND = f'redis://:{REDIS_PASSWORD}@{REDIS_HOST}:{REDIS_PORT}/{REDIS_CELERY_RESULT_DB}'

# celery 缓存
CELERY_CACHE_BACKEND = f'redis://:{REDIS_PASSWORD}@{REDIS_HOST}:{REDIS_PORT}/{REDIS_CELERY_CACHE_DB}'


# 队列配置
CELERY_QUEUES = (
    # celery 默认队列
    Queue('celery', routing_key='celery'),
    # demo
    Queue('demo', routing_key='demo'),
)
# 路由
CELERY_ROUTES = {
    '*.demo_queue*': {'queue': 'demo'},
}

CELERY_ACCEPT_CONTENT = ['application/json']
CELERY_TASK_SERIALIZER = 'json'
CELERY_RESULT_SERIALIZER = 'json'
# celery时区设置，使用settings中TIME_ZONE同样的时区
CELERY_TIMEZONE = TIME_ZONE
# celery 禁用 UTC 和 TZ
CELERY_ENABLE_UTC = False
DJANGO_CELERY_BEAT_TZ_AWARE = False


# 后端认证
AUTHENTICATION_BACKENDS = [
    'django_cas_ng.backends.CASBackend',
    'django.contrib.auth.backends.ModelBackend',
]

# rest framework 配置
REST_FRAMEWORK = {
    # 配置分页，使用按偏移量分页
    'DEFAULT_PAGINATION_CLASS': 'utils.frame.pagination.CustomBasePagination',
    'PAGE_SIZE': 10,
    'EXCEPTION_HANDLER': 'utils.frame.exception_handler.CustomBaseExceptionHandler',

    # 限流，AnonRateThrottle是指匿名用户（未登录用户），UserRateThrottle是指登录用户。
    # 匿名用户的判断依据是通过IP地址，登录用户的判断依据是Token。
    'DEFAULT_THROTTLE_CLASSES': (
        'utils.frame.throttle.CustomAnonRateThrottle',
    ),

    # 限流规则， ('s', 'sec', 'm', 'min', 'h', 'hour', 'd', 'day')
    'DEFAULT_THROTTLE_RATES': {
        'webhook_demo_info': '3/m',
    },

    # API接口权限验证，配置只有注册用户才可通过验证, AllowAny不做权限限制.
    'DEFAULT_PERMISSION_CLASSES': (
        'rest_framework.permissions.IsAuthenticated',
    ),

    # 配置单点系统
    'DEFAULT_MIDDLEWARE_CLASSES': (
        'django_cas_ng.middleware.CASMiddleware',
    ),

    # 配置认证
    'DEFAULT_AUTHENTICATION_CLASSES': (
        'rest_framework.authentication.TokenAuthentication',
        'rest_framework.authentication.BasicAuthentication',
        'rest_framework.authentication.SessionAuthentication',
        # 'django_cas_ng.backends.CASBackend',
        'django.contrib.auth.backends.ModelBackend',
    ),
}


# CAS 的地址
# CAS_SERVER_URL = 'http://cas.xxx.com.cn'
CAS_SERVER_URL = os.environ.get('CAS_SERVER_URL') or config['cas']['cas_server_url']

# CAS 版本
CAS_VERSION = '3'


# 存入所有 CAS 服务端返回的 User 数据。
CAS_APPLY_ATTRIBUTES_TO_USER = True
# 自定义返回值匹配用户表
# {'ln':'last_name'}，cas服务器返回的ln属性将重命名为last_name
CAS_RENAME_ATTRIBUTES = {
    'name': 'name',
    'unitname': 'unit_name',
    'deptname': 'dept_name',
    'employeeCode': 'employee_code',
    'employeeName': 'employee_name',
    'oaid': 'oaid',
    'postname': 'post_name',
    'telephone': 'telephone'
}

# CAS 自定义额外参数，用于在请求服务端返回指定json格式
CAS_EXTRA_LOGIN_PARAMS = {'format': 'json'}
CAS_RENEW = True

# CAS 自动创建用户
CAS_AUTO_CREATE_USERS = True


# Django 默认的数据存储根目录， model的 upload_to 字段用到
MEDIA_ROOT = RESOURCE_ROOT
MEDIA_URL = '/media/'


SWAGGER_SETTINGS = {
    # 基础样式
    'SECURITY_DEFINITIONS': {
        "basic": {
            'type': 'basic'
        }
    },
    # 如果需要登录才能够查看接口文档, 登录的链接使用restframework自带的.
    'LOGIN_URL': '/admin/login',
    'LOGOUT_URL': '/admin/logout',
    # 'DOC_EXPANSION': None,
    # 'SHOW_REQUEST_HEADERS':True,
    # 'USE_SESSION_AUTH': True,
    # 'DOC_EXPANSION': 'list',
    # 接口文档中方法列表以首字母升序排列
    'APIS_SORTER': 'alpha',
    # 如果支持json提交, 则接口文档中包含json输入框
    'JSON_EDITOR': True,
    # 方法列表字母排序
    'OPERATIONS_SORTER': 'alpha',
    'VALIDATOR_URL': None,
    # 'DEFAULT_PAGINATOR_INSPECTORS': [
    #     'utils.frame.pagination.DrfYasgDjangoRestResponsePagination',
    #     'drf_yasg.inspectors.CoreAPICompatInspector',
    # ]
}
