# Generated by Django 2.2.2 on 2020-11-15 12:01

import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.utils.timezone
import utils.custom_fields.list_field


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='FakeModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'db_table': 'app_common_fake',
            },
        ),
        migrations.CreateModel(
            name='UserDepartmentsModel',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False, unique=True, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=64, null=True, verbose_name='部门名称')),
                ('parentid', models.IntegerField(blank=True, null=True, verbose_name='上级部门ID')),
                ('order', models.IntegerField(blank=True, null=True, verbose_name='排序ID')),
                ('desc', models.TextField(blank=True, null=True, verbose_name='描述')),
                ('comments', models.TextField(blank=True, null=True, verbose_name='备注')),
                ('ctime', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('mtime', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
            ],
            options={
                'verbose_name_plural': '部门信息',
                'db_table': 'app_user_department',
            },
        ),
        migrations.CreateModel(
            name='Members',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('name', models.CharField(blank=True, help_text='中文用户名称', max_length=32, null=True, verbose_name='姓名')),
                ('unit_name', models.CharField(blank=True, max_length=64, null=True, verbose_name='公司名称')),
                ('dept_name', models.CharField(blank=True, max_length=64, null=True, verbose_name='部门名称')),
                ('department', utils.custom_fields.list_field.ListField(blank=True, default=[], help_text='填写的是部门ID列表，格式是JSON字符串，例如：[1,2]', null=True, verbose_name='部门列表')),
                ('employee_code', models.CharField(blank=True, max_length=32, null=True, verbose_name='员工编号')),
                ('employee_name', models.CharField(blank=True, max_length=32, null=True, verbose_name='员工姓名')),
                ('oaid', models.CharField(blank=True, help_text='公司OAID，唯一标识', max_length=32, null=True, verbose_name='OAID')),
                ('post_name', models.CharField(blank=True, max_length=64, null=True, verbose_name='职位')),
                ('telephone', models.CharField(blank=True, help_text='11位数字', max_length=11, null=True, verbose_name='手机')),
                ('access_key', models.CharField(blank=True, help_text='秘钥 AK', max_length=64, null=True, verbose_name='access_key')),
                ('secret_key', models.CharField(blank=True, help_text='秘钥 SK', max_length=64, null=True, verbose_name='secret_key')),
                ('ctime', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('mtime', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name_plural': '用户信息',
                'db_table': 'app_user_members',
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
    ]
