"""
Type annotations for iot-managed-integrations service literal definitions.

[Documentation](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iot_managed_integrations/literals/)

Copyright 2025 Vlad Emelianov

Usage::

    ```python
    from mypy_boto3_iot_managed_integrations.literals import AbortCriteriaActionType

    data: AbortCriteriaActionType = "CANCEL"
    ```
"""

import sys

if sys.version_info >= (3, 12):
    from typing import Literal
else:
    from typing_extensions import Literal


__all__ = (
    "AbortCriteriaActionType",
    "AbortCriteriaFailureTypeType",
    "AuthMaterialTypeType",
    "ConfigurationStateType",
    "DeliveryDestinationTypeType",
    "DeviceDiscoveryStatusType",
    "DisconnectReasonValueType",
    "DiscoveryAuthMaterialTypeType",
    "DiscoveryTypeType",
    "EncryptionTypeType",
    "EventTypeType",
    "HubNetworkModeType",
    "ListCredentialLockersPaginatorName",
    "ListDestinationsPaginatorName",
    "ListEventLogConfigurationsPaginatorName",
    "ListManagedThingSchemasPaginatorName",
    "ListManagedThingsPaginatorName",
    "ListNotificationConfigurationsPaginatorName",
    "ListOtaTaskConfigurationsPaginatorName",
    "ListOtaTaskExecutionsPaginatorName",
    "ListOtaTasksPaginatorName",
    "ListProvisioningProfilesPaginatorName",
    "ListSchemaVersionsPaginatorName",
    "LogLevelType",
    "ManagedintegrationsforIoTDeviceManagementServiceName",
    "OtaMechanismType",
    "OtaProtocolType",
    "OtaStatusType",
    "OtaTaskExecutionStatusType",
    "OtaTypeType",
    "PaginatorName",
    "ProvisioningStatusType",
    "ProvisioningTypeType",
    "ResourceServiceName",
    "RetryCriteriaFailureTypeType",
    "RoleType",
    "SchedulingConfigEndBehaviorType",
    "SchemaVersionFormatType",
    "SchemaVersionTypeType",
    "SchemaVersionVisibilityType",
    "ServiceName",
)


AbortCriteriaActionType = Literal["CANCEL"]
AbortCriteriaFailureTypeType = Literal["ALL", "FAILED", "REJECTED", "TIMED_OUT"]
AuthMaterialTypeType = Literal["WIFI_SETUP_QR_BAR_CODE", "ZIGBEE_QR_BAR_CODE", "ZWAVE_QR_BAR_CODE"]
ConfigurationStateType = Literal["ENABLED", "UPDATE_FAILED", "UPDATE_IN_PROGRESS"]
DeliveryDestinationTypeType = Literal["KINESIS"]
DeviceDiscoveryStatusType = Literal["FAILED", "RUNNING", "SUCCEEDED", "TIMED_OUT"]
DisconnectReasonValueType = Literal[
    "AUTH_ERROR",
    "CLIENT_ERROR",
    "CLIENT_INITIATED_DISCONNECT",
    "CONNECTION_LOST",
    "CUSTOMAUTH_TTL_EXPIRATION",
    "DUPLICATE_CLIENTID",
    "FORBIDDEN_ACCESS",
    "MQTT_KEEP_ALIVE_TIMEOUT",
    "NONE",
    "SERVER_ERROR",
    "SERVER_INITIATED_DISCONNECT",
    "THROTTLED",
    "UNKNOWN",
    "WEBSOCKET_TTL_EXPIRATION",
]
DiscoveryAuthMaterialTypeType = Literal["ZWAVE_INSTALL_CODE"]
DiscoveryTypeType = Literal["CLOUD", "ZIGBEE", "ZWAVE"]
EncryptionTypeType = Literal["CUSTOMER_KEY_ENCRYPTION", "MANAGED_INTEGRATIONS_DEFAULT_ENCRYPTION"]
EventTypeType = Literal[
    "CONNECTOR_ASSOCIATION",
    "CONNECTOR_ERROR_REPORT",
    "DEVICE_COMMAND",
    "DEVICE_COMMAND_REQUEST",
    "DEVICE_EVENT",
    "DEVICE_LIFE_CYCLE",
    "DEVICE_OTA",
    "DEVICE_STATE",
]
HubNetworkModeType = Literal["NETWORK_WIDE_EXCLUSION", "STANDARD"]
ListCredentialLockersPaginatorName = Literal["list_credential_lockers"]
ListDestinationsPaginatorName = Literal["list_destinations"]
ListEventLogConfigurationsPaginatorName = Literal["list_event_log_configurations"]
ListManagedThingSchemasPaginatorName = Literal["list_managed_thing_schemas"]
ListManagedThingsPaginatorName = Literal["list_managed_things"]
ListNotificationConfigurationsPaginatorName = Literal["list_notification_configurations"]
ListOtaTaskConfigurationsPaginatorName = Literal["list_ota_task_configurations"]
ListOtaTaskExecutionsPaginatorName = Literal["list_ota_task_executions"]
ListOtaTasksPaginatorName = Literal["list_ota_tasks"]
ListProvisioningProfilesPaginatorName = Literal["list_provisioning_profiles"]
ListSchemaVersionsPaginatorName = Literal["list_schema_versions"]
LogLevelType = Literal["DEBUG", "ERROR", "INFO", "WARN"]
OtaMechanismType = Literal["PUSH"]
OtaProtocolType = Literal["HTTP"]
OtaStatusType = Literal["CANCELED", "COMPLETED", "DELETION_IN_PROGRESS", "IN_PROGRESS", "SCHEDULED"]
OtaTaskExecutionStatusType = Literal[
    "CANCELED", "FAILED", "IN_PROGRESS", "QUEUED", "REJECTED", "REMOVED", "SUCCEEDED", "TIMED_OUT"
]
OtaTypeType = Literal["CONTINUOUS", "ONE_TIME"]
ProvisioningStatusType = Literal[
    "ACTIVATED",
    "DELETED",
    "DELETE_IN_PROGRESS",
    "DELETION_FAILED",
    "DISCOVERED",
    "ISOLATED",
    "PRE_ASSOCIATED",
    "UNASSOCIATED",
]
ProvisioningTypeType = Literal["FLEET_PROVISIONING", "JITR"]
RetryCriteriaFailureTypeType = Literal["ALL", "FAILED", "TIMED_OUT"]
RoleType = Literal["CONTROLLER", "DEVICE"]
SchedulingConfigEndBehaviorType = Literal["CANCEL", "FORCE_CANCEL", "STOP_ROLLOUT"]
SchemaVersionFormatType = Literal["AWS", "CONNECTOR", "ZCL"]
SchemaVersionTypeType = Literal["capability", "definition"]
SchemaVersionVisibilityType = Literal["PRIVATE", "PUBLIC"]
ManagedintegrationsforIoTDeviceManagementServiceName = Literal["iot-managed-integrations"]
ServiceName = Literal[
    "accessanalyzer",
    "account",
    "acm",
    "acm-pca",
    "amp",
    "amplify",
    "amplifybackend",
    "amplifyuibuilder",
    "apigateway",
    "apigatewaymanagementapi",
    "apigatewayv2",
    "appconfig",
    "appconfigdata",
    "appfabric",
    "appflow",
    "appintegrations",
    "application-autoscaling",
    "application-insights",
    "application-signals",
    "applicationcostprofiler",
    "appmesh",
    "apprunner",
    "appstream",
    "appsync",
    "apptest",
    "arc-zonal-shift",
    "artifact",
    "athena",
    "auditmanager",
    "autoscaling",
    "autoscaling-plans",
    "b2bi",
    "backup",
    "backup-gateway",
    "backupsearch",
    "batch",
    "bcm-data-exports",
    "bcm-pricing-calculator",
    "bedrock",
    "bedrock-agent",
    "bedrock-agent-runtime",
    "bedrock-data-automation",
    "bedrock-data-automation-runtime",
    "bedrock-runtime",
    "billing",
    "billingconductor",
    "braket",
    "budgets",
    "ce",
    "chatbot",
    "chime",
    "chime-sdk-identity",
    "chime-sdk-media-pipelines",
    "chime-sdk-meetings",
    "chime-sdk-messaging",
    "chime-sdk-voice",
    "cleanrooms",
    "cleanroomsml",
    "cloud9",
    "cloudcontrol",
    "clouddirectory",
    "cloudformation",
    "cloudfront",
    "cloudfront-keyvaluestore",
    "cloudhsm",
    "cloudhsmv2",
    "cloudsearch",
    "cloudsearchdomain",
    "cloudtrail",
    "cloudtrail-data",
    "cloudwatch",
    "codeartifact",
    "codebuild",
    "codecatalyst",
    "codecommit",
    "codeconnections",
    "codedeploy",
    "codeguru-reviewer",
    "codeguru-security",
    "codeguruprofiler",
    "codepipeline",
    "codestar-connections",
    "codestar-notifications",
    "cognito-identity",
    "cognito-idp",
    "cognito-sync",
    "comprehend",
    "comprehendmedical",
    "compute-optimizer",
    "config",
    "connect",
    "connect-contact-lens",
    "connectcampaigns",
    "connectcampaignsv2",
    "connectcases",
    "connectparticipant",
    "controlcatalog",
    "controltower",
    "cost-optimization-hub",
    "cur",
    "customer-profiles",
    "databrew",
    "dataexchange",
    "datapipeline",
    "datasync",
    "datazone",
    "dax",
    "deadline",
    "detective",
    "devicefarm",
    "devops-guru",
    "directconnect",
    "discovery",
    "dlm",
    "dms",
    "docdb",
    "docdb-elastic",
    "drs",
    "ds",
    "ds-data",
    "dsql",
    "dynamodb",
    "dynamodbstreams",
    "ebs",
    "ec2",
    "ec2-instance-connect",
    "ecr",
    "ecr-public",
    "ecs",
    "efs",
    "eks",
    "eks-auth",
    "elasticache",
    "elasticbeanstalk",
    "elastictranscoder",
    "elb",
    "elbv2",
    "emr",
    "emr-containers",
    "emr-serverless",
    "entityresolution",
    "es",
    "events",
    "evidently",
    "finspace",
    "finspace-data",
    "firehose",
    "fis",
    "fms",
    "forecast",
    "forecastquery",
    "frauddetector",
    "freetier",
    "fsx",
    "gamelift",
    "geo-maps",
    "geo-places",
    "geo-routes",
    "glacier",
    "globalaccelerator",
    "glue",
    "grafana",
    "greengrass",
    "greengrassv2",
    "groundstation",
    "guardduty",
    "health",
    "healthlake",
    "iam",
    "identitystore",
    "imagebuilder",
    "importexport",
    "inspector",
    "inspector-scan",
    "inspector2",
    "internetmonitor",
    "invoicing",
    "iot",
    "iot-data",
    "iot-jobs-data",
    "iot-managed-integrations",
    "iotanalytics",
    "iotdeviceadvisor",
    "iotevents",
    "iotevents-data",
    "iotfleethub",
    "iotfleetwise",
    "iotsecuretunneling",
    "iotsitewise",
    "iotthingsgraph",
    "iottwinmaker",
    "iotwireless",
    "ivs",
    "ivs-realtime",
    "ivschat",
    "kafka",
    "kafkaconnect",
    "kendra",
    "kendra-ranking",
    "keyspaces",
    "kinesis",
    "kinesis-video-archived-media",
    "kinesis-video-media",
    "kinesis-video-signaling",
    "kinesis-video-webrtc-storage",
    "kinesisanalytics",
    "kinesisanalyticsv2",
    "kinesisvideo",
    "kms",
    "lakeformation",
    "lambda",
    "launch-wizard",
    "lex-models",
    "lex-runtime",
    "lexv2-models",
    "lexv2-runtime",
    "license-manager",
    "license-manager-linux-subscriptions",
    "license-manager-user-subscriptions",
    "lightsail",
    "location",
    "logs",
    "lookoutequipment",
    "lookoutmetrics",
    "lookoutvision",
    "m2",
    "machinelearning",
    "macie2",
    "mailmanager",
    "managedblockchain",
    "managedblockchain-query",
    "marketplace-agreement",
    "marketplace-catalog",
    "marketplace-deployment",
    "marketplace-entitlement",
    "marketplace-reporting",
    "marketplacecommerceanalytics",
    "mediaconnect",
    "mediaconvert",
    "medialive",
    "mediapackage",
    "mediapackage-vod",
    "mediapackagev2",
    "mediastore",
    "mediastore-data",
    "mediatailor",
    "medical-imaging",
    "memorydb",
    "meteringmarketplace",
    "mgh",
    "mgn",
    "migration-hub-refactor-spaces",
    "migrationhub-config",
    "migrationhuborchestrator",
    "migrationhubstrategy",
    "mq",
    "mturk",
    "mwaa",
    "neptune",
    "neptune-graph",
    "neptunedata",
    "network-firewall",
    "networkflowmonitor",
    "networkmanager",
    "networkmonitor",
    "notifications",
    "notificationscontacts",
    "oam",
    "observabilityadmin",
    "omics",
    "opensearch",
    "opensearchserverless",
    "opsworks",
    "opsworkscm",
    "organizations",
    "osis",
    "outposts",
    "panorama",
    "partnercentral-selling",
    "payment-cryptography",
    "payment-cryptography-data",
    "pca-connector-ad",
    "pca-connector-scep",
    "pcs",
    "personalize",
    "personalize-events",
    "personalize-runtime",
    "pi",
    "pinpoint",
    "pinpoint-email",
    "pinpoint-sms-voice",
    "pinpoint-sms-voice-v2",
    "pipes",
    "polly",
    "pricing",
    "privatenetworks",
    "proton",
    "qapps",
    "qbusiness",
    "qconnect",
    "qldb",
    "qldb-session",
    "quicksight",
    "ram",
    "rbin",
    "rds",
    "rds-data",
    "redshift",
    "redshift-data",
    "redshift-serverless",
    "rekognition",
    "repostspace",
    "resiliencehub",
    "resource-explorer-2",
    "resource-groups",
    "resourcegroupstaggingapi",
    "robomaker",
    "rolesanywhere",
    "route53",
    "route53-recovery-cluster",
    "route53-recovery-control-config",
    "route53-recovery-readiness",
    "route53domains",
    "route53profiles",
    "route53resolver",
    "rum",
    "s3",
    "s3control",
    "s3outposts",
    "s3tables",
    "sagemaker",
    "sagemaker-a2i-runtime",
    "sagemaker-edge",
    "sagemaker-featurestore-runtime",
    "sagemaker-geospatial",
    "sagemaker-metrics",
    "sagemaker-runtime",
    "savingsplans",
    "scheduler",
    "schemas",
    "sdb",
    "secretsmanager",
    "security-ir",
    "securityhub",
    "securitylake",
    "serverlessrepo",
    "service-quotas",
    "servicecatalog",
    "servicecatalog-appregistry",
    "servicediscovery",
    "ses",
    "sesv2",
    "shield",
    "signer",
    "simspaceweaver",
    "sms",
    "sms-voice",
    "snow-device-management",
    "snowball",
    "sns",
    "socialmessaging",
    "sqs",
    "ssm",
    "ssm-contacts",
    "ssm-incidents",
    "ssm-quicksetup",
    "ssm-sap",
    "sso",
    "sso-admin",
    "sso-oidc",
    "stepfunctions",
    "storagegateway",
    "sts",
    "supplychain",
    "support",
    "support-app",
    "swf",
    "synthetics",
    "taxsettings",
    "textract",
    "timestream-influxdb",
    "timestream-query",
    "timestream-write",
    "tnb",
    "transcribe",
    "transfer",
    "translate",
    "trustedadvisor",
    "verifiedpermissions",
    "voice-id",
    "vpc-lattice",
    "waf",
    "waf-regional",
    "wafv2",
    "wellarchitected",
    "wisdom",
    "workdocs",
    "workmail",
    "workmailmessageflow",
    "workspaces",
    "workspaces-thin-client",
    "workspaces-web",
    "xray",
]
ResourceServiceName = Literal[
    "cloudformation",
    "cloudwatch",
    "dynamodb",
    "ec2",
    "glacier",
    "iam",
    "opsworks",
    "s3",
    "sns",
    "sqs",
]
PaginatorName = Literal[
    "list_credential_lockers",
    "list_destinations",
    "list_event_log_configurations",
    "list_managed_thing_schemas",
    "list_managed_things",
    "list_notification_configurations",
    "list_ota_task_configurations",
    "list_ota_task_executions",
    "list_ota_tasks",
    "list_provisioning_profiles",
    "list_schema_versions",
]
