# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pytimedinput']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'pytimedinput',
    'version': '2.0.1',
    'description': 'Query a user for input with a timeout.',
    'long_description': 'pytimedinput\n============\n\nDescription\n-----------\n\nA tiny, simplistic little alternative to the standard Python input()-function allowing you to specify an optional timeout for the function.\n\npytimedinput should work on both Windows and Linux, though no exceedingly extensive testing has been done and there might be bugs.\n\nInstall\n-------\n\n.. code:: bash\n\n    $ pip3 install pytimedinput\n\nUsage\n-----\n\ntimedInput()\n............\n\n*timedInput()* works similar to Python\'s default *input()* - function, asking user for a string of text, but *timedInput()* allows you to define an amount of time the user has to enter any text or how many consecutive seconds to wait for input, if the user goes idle.\n\n.. code:: python\n\n    def timedInput(prompt="", timeout=5, resetOnInput=True, maxLength=0, allowCharacters="", endCharacters="\\x1b\\n\\r")\n\nThe function *timedInput()* from *pytimedinput* accepts the following parameters:\n\n - **prompt**, *str*: a string to show the user as a prompt when waiting for input.\n     *Defaults to an empty string.*\n - **timeout**, *int*: how many seconds to wait before timing out.\n     *Defaults to 5 seconds, use -1 to disable.*\n - **resetOnInput**, *bool*: Reset the timeout-timer any time user presses a key.\n     *Defaults to True.*\n - **maxLength**, *int*: the maximum length of the string user is allowed to enter.\n     *Defaults to 0, ie. unlimited.*\n - **allowCharacters**, *str*: Which characters the user is allowed to enter.\n     *Defaults to "", ie. any character.*\n - **endCharacters**, *str*: On which characters to stop accepting input.\n     *Defaults to "\\\\x1b\\\\n\\\\r", ie. ESC, newline and carriage-return. Cannot be empty.*\n\nThe function returns a tuple of:\n\n - *str*: a string containing whatever the user typed, regardless of whether the function timed out or not.\n - *bool*: whether the function timed out or not.\n\n**Example:**\n\n.. code:: python\n\n    from pytimedinput import timedInput\n    userText, timedOut = timedInput("Please, do enter something: ")\n    if(timedOut):\n        print("Timed out when waiting for input.")\n        print(f"User-input so far: \'{userText}\'")\n    else:\n        print(f"User-input: \'{userText}\'")\n\ntimedKey()\n..........\n*timedKey()* waits for the user to press one of a set of predefined keys, with a timeout, while ignoring any keys not on the list.\n\n.. code:: python\n\n    def timedKey(prompt="", timeout=5, resetOnInput=True, allowCharacters="")\n\nThe function *timedKey()* from *pytimedinput* accepts the following parameters:\n\n - **prompt**, *str*: a string to show the user as a prompt when waiting for input.\n     *Defaults to an empty string.*\n - **timeout**, *int*: how many seconds to wait before timing out.\n     *Defaults to 5 seconds, use -1 to disable.*\n - **resetOnInput**, *bool*: Reset the timeout-timer any time user presses a key.\n     *Defaults to True.*\n - **allowCharacters**, *str*: Which characters the user is allowed to enter.\n     *Defaults to "", ie. any character.*\n\nThe function returns a tuple of:\n\n - *str*: a string containing the key the user pressed or an empty string.\n - *bool*: whether the function timed out or not.\n\n**Example:**\n\n.. code:: python\n\n    from pytimedinput import timedKey\n    userText, timedOut = timedKey("Please, press \'y\' to accept or \'n\' to decline: ", allowCharacters="yn")\n    if(timedOut):\n        print("Timed out when waiting for input. Pester the user later.")\n    else:\n        if(userText == "y"):\n            print("User consented to selling their first-born child!")\n        else:\n            print("User unfortunately declined to sell their first-born child!")\n\n**Tip: use timedKey() for the infamous "Press any key to continue."-prompt!**\n\n.. code:: python\n\n    from pytimedinput import timedKey\n    timedKey("Press any key to continue.", timeout=-1)\n\ntimedInteger() and timedFloat()\n...............................\n*timedInteger()* and *timedFloat* work like *timedInput()*, except they only allow the user to enter numbers, and comma or period in case of *timedFloat*. Can be used to enter a negative number.\n\n.. code:: python\n\n    def timedInteger(prompt="", timeout=5, resetOnInput=True, allowNegative=True)\n\nThe function *timedInteger()* and *timedFloat()* from *pytimedinput* accept the following parameters:\n\n - **prompt**, *str*: a string to show the user as a prompt when waiting for input.\n     *Defaults to an empty string.*\n - **timeout**, *int*: how many seconds to wait before timing out.\n     *Defaults to 5 seconds, use -1 to disable.*\n - **resetOnInput**, *bool*: Reset the timeout-timer any time user presses a key.\n     *Defaults to True.*\n - **allowNegative**, *bool*: Whether to allow the user to enter a negative value or not.\n\nThe function returns a tuple of:\n\n - *int/float* or *None*: an integer or float, depending on which function was called or None, if no number was entered.\n - *bool*: whether the function timed out or not.\n\n**Example:**\n\n.. code:: python\n\n    from pytimedinput import *\n    userNumber, timedOut = timedFloat("Enter a floating-point value: ")\n    if(not timedOut):\n        if(userNumber == None):\n            print("We wanted a number, but got none.")\n        else:\n            print(f"We should do some fancy maths with {userNumber}!")\n\n\nExceptions\n----------\n\nAll the functions require an interactive shell to function and will raise a Runtimerror-exception otherwise, which will need to be caught in any script that will be used both interactively and non-interactively.\n\nLicense\n-------\n\nMIT',
    'author': 'WereCatf',
    'author_email': 'werecatf@runbox.com',
    'maintainer': 'WereCatf',
    'maintainer_email': 'werecatf@runbox.com',
    'url': 'https://github.com/werecatf/pytimedinput/',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
