import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import * as iot from '@aws-cdk/aws-iot';
import { CommonActionProps } from './common-action-props';
/**
 * Configuration properties of an action for CloudWatch alarm.
 */
export interface CloudWatchSetAlarmStateActionProps extends CommonActionProps {
    /**
     * The reason for the alarm change.
     *
     * @default None
     */
    readonly reason?: string;
    /**
     * The value of the alarm state to set.
     */
    readonly alarmStateToSet: cloudwatch.AlarmState;
}
/**
 * The action to change the state of an Amazon CloudWatch alarm.
 */
export declare class CloudWatchSetAlarmStateAction implements iot.IAction {
    private readonly alarm;
    private readonly props;
    constructor(alarm: cloudwatch.IAlarm, props: CloudWatchSetAlarmStateActionProps);
    bind(topicRule: iot.ITopicRule): iot.ActionConfig;
}
