from Acquisition import aq_parent
from collections.abc import Iterable
from collective.taxonomy.interfaces import ITaxonomy
from plone import api
from plone.dexterity.interfaces import IDexterityContent
from plone.indexer.interfaces import IIndexer
from Products.CMFPlone.interfaces import IPloneSiteRoot
from Products.ZCatalog.interfaces import IZCatalog
from zope.component import adapter
from zope.interface import implementer

import logging
import six


logger = logging.getLogger("collective.taxonomy")


class TaxonomyIndexerWrapper(object):
    def __init__(self, field_name, utility_name, context, catalog):
        self.context = context
        self.catalog = catalog
        self.field_name = field_name
        self.utility_name = utility_name

    def __call__(self):
        # Dirty hack to ensure that it is not an item in a
        # folder

        if self.field_name not in self.context.__dict__:
            return []

        sm = self.context.portal_url.getSiteManager()
        utility = sm.queryUtility(ITaxonomy, name=self.utility_name)

        if not utility:
            logging.info("Utility has disappeared..!")
            return []

        if not utility.data:
            # skip empty taxonomy
            return []

        found = []
        stored_element = getattr(self.context, self.field_name)
        if not isinstance(stored_element, Iterable) or isinstance(
            stored_element, six.string_types
        ):
            stored_element = [stored_element]

        for (language, data) in utility.data.items():
            for (identifier, path) in utility.inverted_data[language].items():
                if identifier in stored_element:
                    found.append(
                        (
                            identifier,
                            language,
                            path,
                        )
                    )

        lang = get_language(self.context)
        if lang not in utility.inverted_data:
            lang = utility.default_language

        result = []
        for (key, value) in utility.inverted_data[lang].items():
            for (found_identifier, found_language, found_path) in found:
                if found_path.startswith(value) and key not in result:
                    result.append(key)

        return result


@adapter(IDexterityContent, IZCatalog)
@implementer(IIndexer)
class TaxonomyIndexer(object):
    __name__ = "TaxonomyIndexer"

    def __init__(self, field_name, utility_name):
        self.field_name = field_name
        self.utility_name = utility_name

    def __call__(self, context, catalog):
        return TaxonomyIndexerWrapper(
            self.field_name, self.utility_name, context, catalog
        )


def get_language(obj):
    lang = getattr(obj, "language", None)
    if lang:
        return lang
    elif not IPloneSiteRoot.providedBy(obj):
        lang = get_language(aq_parent(obj))
    else:
        lang = api.portal.get_default_language()
    return lang
