# dialogflowpy-webhook
[![Documentation Status](https://readthedocs.org/projects/dialogflowpy-webhook/badge/?version=latest)](https://dialogflowpy-webhook.readthedocs.io/en/latest/?badge=latest)

A Python module for parsing and creating Requests and Responses of Dialogflow Fulfillment Library. The [Dialogflow Fulfillment Library](https://cloud.google.com/dialogflow/docs/fulfillment-overview) allows you to connect natural language understanding and processing to your own system. Using Fulfillment, you can surface commands and information from your services to your users through a natural conversational interface.

This dialogflowpy-webhook module is intended to help build Python Dialogflow Fulfillment for multiple  [integrations](https://cloud.google.com/dialogflow/docs/integrations/)  including Google Assistant, Facebook and Telegram. It is expected to work for Slack and Line as well. 

## Supported Features
### All Platforms
- Text Response
- Card
- Suggestion Chips/Quick Replies
- Image
### Google Assistant
- Text Response
- Card
- Suggestion Chips (Quick Replies)
- Carousel
- Table
- Media Responses
- Permission Requests

## Installation
The module can be installed from PyPi by running:

    pip3 install dialogflowpy-webhook
    
The module can also be installed directly from Github by running

    pip3 install git+https://github.com/vishalbala-nps/dialogflowpy-webhook.git

## Helpful Links
- [Documentation](https://dialogflowpy-webhook.readthedocs.io/en/latest/index.html)
- [Getting Started](https://dialogflowpy-webhook.readthedocs.io/en/latest/getting_started.html)
- [Module Reference](https://dialogflowpy-webhook.readthedocs.io/en/latest/module_reference.html)
- [Sample Code](https://github.com/vishalbala-nps/dialogflowpy-webhook/tree/master/examples)

## Reporting Bugs
In case of any problems or suggestions with this module, feel free to open a [Github Issue](https://github.com/vishalbala-nps/dialogflowpy-webhook/issues)