# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gimpformats']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=8.3.2,<9',
 'binaryiotools>=2020.2.2,<2022',
 'blendmodes>=2021.1,<2023',
 'brackettree>=0.2.5,<2',
 'numpy>=1.20.3,<2']

setup_kwargs = {
    'name': 'gimpformats',
    'version': '2021.1.1',
    'description': 'Pure python implementation of the gimp file format(s)',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/GimpFormats.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/GimpFormats.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/GimpFormats.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/GimpFormats.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/GimpFormats.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/GimpFormats.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/gimpformats.svg?style=for-the-badge)](https://pypistats.org/packages/gimpformats)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Fgimpformats)](https://pepy.tech/project/gimpformats)\n[![PyPI Version](https://img.shields.io/pypi/v/gimpformats.svg?style=for-the-badge)](https://pypi.org/project/gimpformats)\n\n<!-- omit in TOC -->\n# GimpFormats\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nForked from https://github.com/TheHeadlessSourceMan/gimpFormats\n\nA pure python implementation of the GIMP XCF image format. Use this to interact\nwith GIMP image formats\n\nIssues and contributions very much wanted/ needed :smile:\n\nPreviously under `gimpformats_unofficial` now under `gimpformats`\n\n- [Getting started](#getting-started)\n- [Next tasks (see below)](#next-tasks-see-below)\n- [Currently supports](#currently-supports)\n- [In progress but results in crashes and tests failing](#in-progress-but-results-in-crashes-and-tests-failing)\n- [Not implemented](#not-implemented)\n- [Documentation](#documentation)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Download](#download)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n- [How to run](#how-to-run)\n\t- [With VSCode](#with-vscode)\n\t- [From the Terminal](#from-the-terminal)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\n## Getting started\n\nRead an image\n```python\nfrom gimpformats.gimpXcfDocument import GimpDocument\nproject = GimpDocument("image.xcf")\n```\n\nIterate the image and report the contents of each group followed by the first\nlevel children of the image\n```python\n"""List data on groups followed by the direct children of a gimp xcf document\n"""\nlayers = project.layers\nindex = 0\nprint("## Group info...")\nwhile index < len(layers):\n\tlayerOrGroup = layers[index]\n\tif layerOrGroup.isGroup:\n\t\tindex += 1\n\t\twhile layers[index].itemPath is not None:\n\t\t\tprint("Group \\"" + layerOrGroup.name + "\\" contains Layer \\"" + layers[index].name + "\\"")\n\t\t\tlayers.pop(index)\n\telse:\n\t\tindex += 1\n\nprint("## Document direct children...")\nfor layerOrGroup in layers:\n\tprint("\\"" + layerOrGroup.name + "\\" is a " + ("Group" if layerOrGroup.isGroup else "Layer"))\n\n```\n\nExample output:\n\n```none\n## Group info...\nGroup "Layer Group" contains Layer "Layer"\nGroup "Layer Group" contains Layer "Layer2"\n## Document direct children...\n"bg #1" is a Layer\n"bg" is a Layer\n"bg #2" is a Layer\n"Transformation" is a Layer\n"Layer Group" is a Group\n"Background" is a Layer\n```\n\n## Next tasks (see below)\n- Saving\n\n## Currently supports\n- Loading xcf files (up to current GIMP version 2.10)\n- Getting image hierarchy and info\n- Getting image for each layer (PIL image)\n- .gbr brushes\n- .vbr brushes\n- .gpl palette files\n- .pat pattern files\n- .gtp tool presets\n- Generate a flattened image\n- Add new layers\n\n## In progress but results in crashes and tests failing\n- Saving\n- .ggr gradients - reads/saves fine, but I need to come up with a way to get the\nactual colours\n- .gih brush sets - BUG: seems to have more image data per brush than what\'s\nexpected\n- .gpb brush - should work, but I need some test files\n\n## Not implemented\n- Exported paths in .svg format. - Reading should be easy enough, but I need to\nensure I don\'t get a full-blown svg in the mix\n- Standard "parasites"\n\n## Documentation\nSee the [Docs](/DOCS/) for more information.\n\n## Install With PIP\n```python\npip install gimpformats\n```\n\nHead to https://pypi.org/project/gimpformats/ for more info\n\n## Language information\n### Built for\nThis program has been written for Python 3 and has been tested with\nPython version 3.9.0 <https://www.python.org/downloads/release/python-380/>.\n\n## Install Python on Windows\n### Chocolatey\n```powershell\nchoco install python\n```\n### Download\nTo install Python, go to <https://www.python.org/> and download the latest\nversion.\n\n## Install Python on Linux\n### Apt\n```bash\nsudo apt install python3.9\n```\n\n## How to run\n### With VSCode\n1. Open the .py file in vscode\n2. Ensure a python 3.9 interpreter is selected (Ctrl+Shift+P > Python:Select\nInterpreter > Python 3.9)\n3. Run by pressing Ctrl+F5 (if you are prompted to install any modules, accept)\n### From the Terminal\n```bash\n./[file].py\n```\n\n## Download Project\n### Clone\n#### Using The Command Line\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n```bash\n$ git clone https://github.com/FHPythonUtils/GimpFormats\n```\n\nMore information can be found at\n<https://help.github.com/en/articles/cloning-a-repository>\n\n#### Using GitHub Desktop\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\n<https://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop>\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n### Licence\nLGPLv3 License\n(See the [LICENSE](/LICENSE.txt) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/GimpFormats',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
