<a id="mypy-boto3-codebuild"></a>

# mypy-boto3-codebuild

[![PyPI - mypy-boto3-codebuild](https://img.shields.io/pypi/v/mypy-boto3-codebuild.svg?color=blue)](https://pypi.org/project/mypy-boto3-codebuild)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codebuild.svg?color=blue)](https://pypi.org/project/mypy-boto3-codebuild)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-codebuild?color=blue)](https://pypistats.org/packages/mypy-boto3-codebuild)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.CodeBuild 1.18.53](https://boto3.amazonaws.com/v1/documentation/api/1.18.53/reference/services/codebuild.html#CodeBuild)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.5.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-codebuild docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codebuild/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-codebuild](#mypy-boto3-codebuild)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `CodeBuild` service.

```bash
python -m pip install boto3-stubs[codebuild]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[codebuild]` in your environment:
  `python -m pip install 'boto3-stubs[codebuild]'`

Both type checking and auto-complete should work for `CodeBuild` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[codebuild]` in your environment:
  `python -m pip install 'boto3-stubs[codebuild]'`

Both type checking and auto-complete should work for `CodeBuild` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[codebuild]` in your environment:
  `python -m pip install 'boto3-stubs[codebuild]'`
- Run `mypy` as usual

Type checking should work for `CodeBuild` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[codebuild]` in your environment:
  `python -m pip install 'boto3-stubs[codebuild]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CodeBuild` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`CodeBuildClient` provides annotations for `boto3.client("codebuild")`.

```python
import boto3

from mypy_boto3_codebuild import CodeBuildClient

client: CodeBuildClient = boto3.client("codebuild")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodeBuildClient = session.client("codebuild")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_codebuild.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_codebuild import CodeBuildClient
from mypy_boto3_codebuild.paginator import (
    DescribeCodeCoveragesPaginator,
    DescribeTestCasesPaginator,
    ListBuildBatchesPaginator,
    ListBuildBatchesForProjectPaginator,
    ListBuildsPaginator,
    ListBuildsForProjectPaginator,
    ListProjectsPaginator,
    ListReportGroupsPaginator,
    ListReportsPaginator,
    ListReportsForReportGroupPaginator,
    ListSharedProjectsPaginator,
    ListSharedReportGroupsPaginator,
)

client: CodeBuildClient = boto3.client("codebuild")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_code_coverages_paginator: DescribeCodeCoveragesPaginator = client.get_paginator("describe_code_coverages")
describe_test_cases_paginator: DescribeTestCasesPaginator = client.get_paginator("describe_test_cases")
list_build_batches_paginator: ListBuildBatchesPaginator = client.get_paginator("list_build_batches")
list_build_batches_for_project_paginator: ListBuildBatchesForProjectPaginator = client.get_paginator("list_build_batches_for_project")
list_builds_paginator: ListBuildsPaginator = client.get_paginator("list_builds")
list_builds_for_project_paginator: ListBuildsForProjectPaginator = client.get_paginator("list_builds_for_project")
list_projects_paginator: ListProjectsPaginator = client.get_paginator("list_projects")
list_report_groups_paginator: ListReportGroupsPaginator = client.get_paginator("list_report_groups")
list_reports_paginator: ListReportsPaginator = client.get_paginator("list_reports")
list_reports_for_report_group_paginator: ListReportsForReportGroupPaginator = client.get_paginator("list_reports_for_report_group")
list_shared_projects_paginator: ListSharedProjectsPaginator = client.get_paginator("list_shared_projects")
list_shared_report_groups_paginator: ListSharedReportGroupsPaginator = client.get_paginator("list_shared_report_groups")
```

<a id="literals"></a>

### Literals

`mypy_boto3_codebuild.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_codebuild.literals import (
    ArtifactNamespaceType,
    ArtifactPackagingType,
    ArtifactsTypeType,
    AuthTypeType,
    BucketOwnerAccessType,
    BuildBatchPhaseTypeType,
    BuildPhaseTypeType,
    CacheModeType,
    CacheTypeType,
    ComputeTypeType,
    CredentialProviderTypeType,
    DescribeCodeCoveragesPaginatorName,
    DescribeTestCasesPaginatorName,
    EnvironmentTypeType,
    EnvironmentVariableTypeType,
    FileSystemTypeType,
    ImagePullCredentialsTypeType,
    LanguageTypeType,
    ListBuildBatchesForProjectPaginatorName,
    ListBuildBatchesPaginatorName,
    ListBuildsForProjectPaginatorName,
    ListBuildsPaginatorName,
    ListProjectsPaginatorName,
    ListReportGroupsPaginatorName,
    ListReportsForReportGroupPaginatorName,
    ListReportsPaginatorName,
    ListSharedProjectsPaginatorName,
    ListSharedReportGroupsPaginatorName,
    LogsConfigStatusTypeType,
    PlatformTypeType,
    ProjectSortByTypeType,
    ProjectVisibilityTypeType,
    ReportCodeCoverageSortByTypeType,
    ReportExportConfigTypeType,
    ReportGroupSortByTypeType,
    ReportGroupStatusTypeType,
    ReportGroupTrendFieldTypeType,
    ReportPackagingTypeType,
    ReportStatusTypeType,
    ReportTypeType,
    RetryBuildBatchTypeType,
    ServerTypeType,
    SharedResourceSortByTypeType,
    SortOrderTypeType,
    SourceAuthTypeType,
    SourceTypeType,
    StatusTypeType,
    WebhookBuildTypeType,
    WebhookFilterTypeType,
    ServiceName,
    PaginatorName,
)

def check_value(value: ArtifactNamespaceType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_codebuild.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_codebuild.type_defs import (
    BatchDeleteBuildsInputRequestTypeDef,
    BatchDeleteBuildsOutputTypeDef,
    BatchGetBuildBatchesInputRequestTypeDef,
    BatchGetBuildBatchesOutputTypeDef,
    BatchGetBuildsInputRequestTypeDef,
    BatchGetBuildsOutputTypeDef,
    BatchGetProjectsInputRequestTypeDef,
    BatchGetProjectsOutputTypeDef,
    BatchGetReportGroupsInputRequestTypeDef,
    BatchGetReportGroupsOutputTypeDef,
    BatchGetReportsInputRequestTypeDef,
    BatchGetReportsOutputTypeDef,
    BatchRestrictionsTypeDef,
    BuildArtifactsTypeDef,
    BuildBatchFilterTypeDef,
    BuildBatchPhaseTypeDef,
    BuildBatchTypeDef,
    BuildGroupTypeDef,
    BuildNotDeletedTypeDef,
    BuildPhaseTypeDef,
    BuildStatusConfigTypeDef,
    BuildSummaryTypeDef,
    BuildTypeDef,
    CloudWatchLogsConfigTypeDef,
    CodeCoverageReportSummaryTypeDef,
    CodeCoverageTypeDef,
    CreateProjectInputRequestTypeDef,
    CreateProjectOutputTypeDef,
    CreateReportGroupInputRequestTypeDef,
    CreateReportGroupOutputTypeDef,
    CreateWebhookInputRequestTypeDef,
    CreateWebhookOutputTypeDef,
    DebugSessionTypeDef,
    DeleteBuildBatchInputRequestTypeDef,
    DeleteBuildBatchOutputTypeDef,
    DeleteProjectInputRequestTypeDef,
    DeleteReportGroupInputRequestTypeDef,
    DeleteReportInputRequestTypeDef,
    DeleteResourcePolicyInputRequestTypeDef,
    DeleteSourceCredentialsInputRequestTypeDef,
    DeleteSourceCredentialsOutputTypeDef,
    DeleteWebhookInputRequestTypeDef,
    DescribeCodeCoveragesInputRequestTypeDef,
    DescribeCodeCoveragesOutputTypeDef,
    DescribeTestCasesInputRequestTypeDef,
    DescribeTestCasesOutputTypeDef,
    EnvironmentImageTypeDef,
    EnvironmentLanguageTypeDef,
    EnvironmentPlatformTypeDef,
    EnvironmentVariableTypeDef,
    ExportedEnvironmentVariableTypeDef,
    GetReportGroupTrendInputRequestTypeDef,
    GetReportGroupTrendOutputTypeDef,
    GetResourcePolicyInputRequestTypeDef,
    GetResourcePolicyOutputTypeDef,
    GitSubmodulesConfigTypeDef,
    ImportSourceCredentialsInputRequestTypeDef,
    ImportSourceCredentialsOutputTypeDef,
    InvalidateProjectCacheInputRequestTypeDef,
    ListBuildBatchesForProjectInputRequestTypeDef,
    ListBuildBatchesForProjectOutputTypeDef,
    ListBuildBatchesInputRequestTypeDef,
    ListBuildBatchesOutputTypeDef,
    ListBuildsForProjectInputRequestTypeDef,
    ListBuildsForProjectOutputTypeDef,
    ListBuildsInputRequestTypeDef,
    ListBuildsOutputTypeDef,
    ListCuratedEnvironmentImagesOutputTypeDef,
    ListProjectsInputRequestTypeDef,
    ListProjectsOutputTypeDef,
    ListReportGroupsInputRequestTypeDef,
    ListReportGroupsOutputTypeDef,
    ListReportsForReportGroupInputRequestTypeDef,
    ListReportsForReportGroupOutputTypeDef,
    ListReportsInputRequestTypeDef,
    ListReportsOutputTypeDef,
    ListSharedProjectsInputRequestTypeDef,
    ListSharedProjectsOutputTypeDef,
    ListSharedReportGroupsInputRequestTypeDef,
    ListSharedReportGroupsOutputTypeDef,
    ListSourceCredentialsOutputTypeDef,
    LogsConfigTypeDef,
    LogsLocationTypeDef,
    NetworkInterfaceTypeDef,
    PaginatorConfigTypeDef,
    PhaseContextTypeDef,
    ProjectArtifactsTypeDef,
    ProjectBadgeTypeDef,
    ProjectBuildBatchConfigTypeDef,
    ProjectCacheTypeDef,
    ProjectEnvironmentTypeDef,
    ProjectFileSystemLocationTypeDef,
    ProjectSourceTypeDef,
    ProjectSourceVersionTypeDef,
    ProjectTypeDef,
    PutResourcePolicyInputRequestTypeDef,
    PutResourcePolicyOutputTypeDef,
    RegistryCredentialTypeDef,
    ReportExportConfigTypeDef,
    ReportFilterTypeDef,
    ReportGroupTrendStatsTypeDef,
    ReportGroupTypeDef,
    ReportTypeDef,
    ReportWithRawDataTypeDef,
    ResolvedArtifactTypeDef,
    ResponseMetadataTypeDef,
    RetryBuildBatchInputRequestTypeDef,
    RetryBuildBatchOutputTypeDef,
    RetryBuildInputRequestTypeDef,
    RetryBuildOutputTypeDef,
    S3LogsConfigTypeDef,
    S3ReportExportConfigTypeDef,
    SourceAuthTypeDef,
    SourceCredentialsInfoTypeDef,
    StartBuildBatchInputRequestTypeDef,
    StartBuildBatchOutputTypeDef,
    StartBuildInputRequestTypeDef,
    StartBuildOutputTypeDef,
    StopBuildBatchInputRequestTypeDef,
    StopBuildBatchOutputTypeDef,
    StopBuildInputRequestTypeDef,
    StopBuildOutputTypeDef,
    TagTypeDef,
    TestCaseFilterTypeDef,
    TestCaseTypeDef,
    TestReportSummaryTypeDef,
    UpdateProjectInputRequestTypeDef,
    UpdateProjectOutputTypeDef,
    UpdateProjectVisibilityInputRequestTypeDef,
    UpdateProjectVisibilityOutputTypeDef,
    UpdateReportGroupInputRequestTypeDef,
    UpdateReportGroupOutputTypeDef,
    UpdateWebhookInputRequestTypeDef,
    UpdateWebhookOutputTypeDef,
    VpcConfigTypeDef,
    WebhookFilterTypeDef,
    WebhookTypeDef,
)

def get_structure() -> BatchDeleteBuildsInputRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-codebuild` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-codebuild docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codebuild/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
