/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.sparksdk.protobuf;

import aialgorithms.proto2.RecordProto2;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ProtobufConverter$ {
    public static ProtobufConverter$ MODULE$;
    private final String ValuesIdentifierString;
    private final Integer magicNumber;
    private final byte[] magicNumberBytes;

    static {
        new ProtobufConverter$();
    }

    public String ValuesIdentifierString() {
        return this.ValuesIdentifierString;
    }

    public RecordProto2.Record rowToProtobuf(Row row, String featuresFieldName, Option<String> labelFieldName) {
        boolean hasLabelColumn;
        Predef$.MODULE$.require(row.schema() != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Row schema is null for row ").append(row).toString());
        RecordProto2.Record.Builder protobufBuilder = RecordProto2.Record.newBuilder();
        Object object = labelFieldName.nonEmpty() ? ((hasLabelColumn = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row.schema().fieldNames())).contains(labelFieldName.get())) ? this.setLabel(protobufBuilder, BoxesRunTime.unboxToDouble((Object)row.getAs((String)labelFieldName.get()))) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        boolean hasFeaturesColumn = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row.schema().fieldNames())).contains((Object)featuresFieldName);
        if (hasFeaturesColumn) {
            RecordProto2.Record.Builder builder;
            int idx = row.fieldIndex(featuresFieldName);
            Object object2 = row.get(idx);
            if (object2 instanceof Vector) {
                Vector vector = (Vector)object2;
                builder = this.setFeatures(protobufBuilder, vector);
            } else if (object2 instanceof Matrix) {
                Matrix matrix = (Matrix)object2;
                builder = this.setFeatures(protobufBuilder, matrix);
            } else {
                throw new MatchError(object2);
            }
            RecordProto2.Record.Builder target = builder;
        } else if (!hasFeaturesColumn) {
            throw new IllegalArgumentException(new StringBuilder(81).append("Need a features column with a ").append("Vector of doubles named ").append(featuresFieldName).append(" to convert row to protobuf").toString());
        }
        return protobufBuilder.build();
    }

    public Option<String> rowToProtobuf$default$3() {
        return Option$.MODULE$.empty();
    }

    public Iterator<RecordProto2.Record> recordIOByteArrayToProtobufs(byte[] byteArray) {
        MutableList recordList = new MutableList();
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        boolean index = false;
        while (buffer.hasRemaining()) {
            this.validateMagicNumber(Predef$.MODULE$.int2Integer(buffer.getInt()));
            byte[] recordBytes = new byte[buffer.getInt()];
            buffer.get(recordBytes, 0, recordBytes.length);
            RecordProto2.Record protobufRecord = this.byteArrayToProtobuf(recordBytes);
            recordList.$plus$eq((Object)protobufRecord);
            buffer.position(buffer.position() + this.paddingCount(buffer.position()));
        }
        return recordList.iterator();
    }

    private Integer magicNumber() {
        return this.magicNumber;
    }

    private byte[] magicNumberBytes() {
        return this.magicNumberBytes;
    }

    private byte[] intToLittleEndianByteArray(Integer n) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(Predef$.MODULE$.Integer2int(n)).array();
    }

    public byte[] byteArrayToRecordIOEncodedByteArray(byte[] byteArray) {
        byte[] recordLengthBytes = this.intToLittleEndianByteArray(Predef$.MODULE$.int2Integer(byteArray.length));
        ObjectRef recordIOBytes = ObjectRef.create((Object)((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.magicNumberBytes())).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(recordLengthBytes)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(byteArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))));
        int paddingNeeded = this.paddingCount(((byte[])recordIOBytes.elem).length);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), paddingNeeded).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            recordIOBytes$1.elem = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])recordIOBytes$1.elem)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        });
        return (byte[])recordIOBytes.elem;
    }

    public int paddingCount(int byteCount) {
        int mod = byteCount % 4;
        if (mod == 0) {
            return 0;
        }
        return 4 - mod;
    }

    public void validateMagicNumber(Integer recordDelimiter) {
        Integer n = recordDelimiter;
        Integer n2 = this.magicNumber();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            throw new RuntimeException("Incorrectly encoded byte array. Record delimiter did not match RecordIO magic number.");
        }
    }

    public RecordProto2.Record byteArrayToProtobuf(byte[] byteArray) {
        return RecordProto2.Record.parseFrom(byteArray);
    }

    private RecordProto2.Record.Builder setLabel(RecordProto2.Record.Builder protobufBuilder, double label) {
        RecordProto2.Float32Tensor labelTensor = RecordProto2.Value.newBuilder().getFloat32TensorBuilder().addValues((float)label).build();
        RecordProto2.Value labelValue = RecordProto2.Value.newBuilder().setFloat32Tensor(labelTensor).build();
        RecordProto2.MapEntry mapEntry = RecordProto2.MapEntry.newBuilder().setKey(this.ValuesIdentifierString()).setValue(labelValue).build();
        return protobufBuilder.addLabel(mapEntry);
    }

    private RecordProto2.Record.Builder setFeatures(RecordProto2.Record.Builder protobufBuilder, Vector vector) {
        RecordProto2.Float32Tensor float32Tensor;
        RecordProto2.Float32Tensor.Builder featuresTensorBuilder = RecordProto2.Value.newBuilder().getFloat32TensorBuilder();
        Vector vector2 = vector;
        if (vector2 instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector2;
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(denseVector.values())).foreach((Function1 & Serializable & scala.Serializable)value -> featuresTensorBuilder.addValues((float)BoxesRunTime.unboxToDouble((Object)value)));
            float32Tensor = featuresTensorBuilder.build();
        } else if (vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector2;
            featuresTensorBuilder.addShape(sparseVector.size());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sparseVector.indices().length).foreach((Function1 & Serializable & scala.Serializable)i -> ProtobufConverter$.$anonfun$setFeatures$2(featuresTensorBuilder, sparseVector, BoxesRunTime.unboxToInt((Object)i)));
            float32Tensor = featuresTensorBuilder.build();
        } else {
            throw new MatchError((Object)vector2);
        }
        RecordProto2.Float32Tensor featuresTensor = float32Tensor;
        RecordProto2.Value featuresValue = RecordProto2.Value.newBuilder().setFloat32Tensor(featuresTensor).build();
        RecordProto2.MapEntry mapEntry = RecordProto2.MapEntry.newBuilder().setKey(this.ValuesIdentifierString()).setValue(featuresValue).build();
        return protobufBuilder.addFeatures(mapEntry);
    }

    private RecordProto2.Record.Builder setFeatures(RecordProto2.Record.Builder protobufBuilder, Matrix matrix) {
        RecordProto2.Float32Tensor float32Tensor;
        RecordProto2.Float32Tensor.Builder featuresTensorBuilder = RecordProto2.Value.newBuilder().getFloat32TensorBuilder();
        featuresTensorBuilder.addShape(matrix.numRows());
        featuresTensorBuilder.addShape(matrix.numCols());
        Matrix matrix2 = matrix;
        if (matrix2 instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)matrix2;
            if (!denseMatrix.isTransposed()) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), denseMatrix.numRows() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)row -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), denseMatrix.numCols() - 1).foreach((Function1 & Serializable & scala.Serializable)col -> featuresTensorBuilder.addValues((float)denseMatrix.apply(row, BoxesRunTime.unboxToInt((Object)col)))));
            } else {
                new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(denseMatrix.values())).foreach((Function1 & Serializable & scala.Serializable)value -> featuresTensorBuilder.addValues((float)BoxesRunTime.unboxToDouble((Object)value)));
            }
            float32Tensor = featuresTensorBuilder.build();
        } else if (matrix2 instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix2;
            IntRef rowIdx = IntRef.create((int)0);
            IntRef colIdx = IntRef.create((int)0);
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sparseMatrix.colPtrs())).slice(1, new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sparseMatrix.colPtrs())).size()))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)colStart -> {
                while (rowIdx$1.elem < colStart) {
                    RecordProto2.Float32Tensor.Builder builder = sparseMatrix.isTransposed() ? featuresTensorBuilder.addKeys(colIdx$1.elem * sparseMatrix.numCols() + sparseMatrix.rowIndices()[rowIdx$1.elem]) : featuresTensorBuilder.addKeys(sparseMatrix.rowIndices()[rowIdx$1.elem] * sparseMatrix.numCols() + colIdx$1.elem);
                    ++rowIdx$1.elem;
                }
                ++colIdx$1.elem;
            });
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sparseMatrix.values())).foreach((Function1 & Serializable & scala.Serializable)value -> featuresTensorBuilder.addValues((float)BoxesRunTime.unboxToDouble((Object)value)));
            float32Tensor = featuresTensorBuilder.build();
        } else {
            throw new MatchError((Object)matrix2);
        }
        RecordProto2.Float32Tensor featuresTensor = float32Tensor;
        RecordProto2.Value featuresValue = RecordProto2.Value.newBuilder().setFloat32Tensor(featuresTensor).build();
        RecordProto2.MapEntry mapEntry = RecordProto2.MapEntry.newBuilder().setKey(this.ValuesIdentifierString()).setValue(featuresValue).build();
        return protobufBuilder.addFeatures(mapEntry);
    }

    public static final /* synthetic */ RecordProto2.Float32Tensor.Builder $anonfun$setFeatures$2(RecordProto2.Float32Tensor.Builder featuresTensorBuilder$1, SparseVector x3$1, int i) {
        featuresTensorBuilder$1.addKeys(x3$1.indices()[i]);
        return featuresTensorBuilder$1.addValues((float)x3$1.values()[i]);
    }

    private ProtobufConverter$() {
        MODULE$ = this;
        this.ValuesIdentifierString = "values";
        this.magicNumber = Predef$.MODULE$.int2Integer(-824761590);
        this.magicNumberBytes = this.intToLittleEndianByteArray(this.magicNumber());
    }
}

