/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.sparksdk;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.services.sagemaker.AmazonSageMaker;
import com.amazonaws.services.sagemaker.model.AmazonSageMakerException;
import com.amazonaws.services.sagemaker.model.DeleteEndpointConfigRequest;
import com.amazonaws.services.sagemaker.model.DeleteEndpointRequest;
import com.amazonaws.services.sagemaker.model.DeleteModelRequest;
import com.amazonaws.services.sagemaker.model.DescribeEndpointConfigRequest;
import com.amazonaws.services.sagemaker.model.DescribeEndpointRequest;
import com.amazonaws.services.sagemaker.model.DescribeModelRequest;
import com.amazonaws.services.sagemaker.sparksdk.CreatedResources;
import com.amazonaws.services.sagemaker.sparksdk.exceptions.SageMakerResourceCleanupException;
import com.amazonaws.services.sagemaker.sparksdk.internal.InternalUtils$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001q3A\u0001C\u0005\u0001)!AA\u0002\u0001B\u0001B\u0003%1\u0004C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u0003/\u0001\u0011\u0005q\u0006C\u0003>\u0001\u0011\u0005a\bC\u0003A\u0001\u0011\u0005\u0011\tC\u0003D\u0001\u0011%AI\u0001\rTC\u001e,W*Y6feJ+7o\\;sG\u0016\u001cE.Z1okBT!AC\u0006\u0002\u0011M\u0004\u0018M]6tI.T!\u0001D\u0007\u0002\u0013M\fw-Z7bW\u0016\u0014(B\u0001\b\u0010\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001\t\u0012\u0003%\tW.\u0019>p]\u0006<8OC\u0001\u0013\u0003\r\u0019w.\\\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039ui\u0011aC\u0005\u0003=-\u0011q\"Q7bu>t7+Y4f\u001b\u0006\\WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u001a\u0003C\u0001\u0012\u0001\u001b\u0005I\u0001\"\u0002\u0007\u0003\u0001\u0004Y\u0012a\u00043fY\u0016$XMU3t_V\u00148-Z:\u0015\u0005\u0019J\u0003C\u0001\f(\u0013\tAsC\u0001\u0003V]&$\b\"\u0002\u0016\u0004\u0001\u0004Y\u0013!\u0003:fg>,(oY3t!\t\u0011C&\u0003\u0002.\u0013\t\u00012I]3bi\u0016$'+Z:pkJ\u001cWm]\u0001\u000fI\u0016dW\r^3F]\u0012\u0004x.\u001b8u)\t1\u0003\u0007C\u00032\t\u0001\u0007!'\u0001\u0003oC6,\u0007CA\u001a;\u001d\t!\u0004\b\u0005\u00026/5\taG\u0003\u00028'\u00051AH]8pizJ!!O\f\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003s]\tA\u0003Z3mKR,WI\u001c3q_&tGoQ8oM&<GC\u0001\u0014@\u0011\u0015\tT\u00011\u00013\u0003-!W\r\\3uK6{G-\u001a7\u0015\u0005\u0019\u0012\u0005\"B\u0019\u0007\u0001\u0004\u0011\u0014a\u0003;ss\u0012+7o\u0019:jE\u0016,\"!\u0012(\u0015\u0005\u0019;\u0006cA$K\u00196\t\u0001J\u0003\u0002J/\u0005!Q\u000f^5m\u0013\tY\u0005JA\u0002Uef\u0004\"!\u0014(\r\u0001\u0011)qj\u0002b\u0001!\n\tA+\u0005\u0002R)B\u0011aCU\u0005\u0003'^\u0011qAT8uQ&tw\r\u0005\u0002\u0017+&\u0011ak\u0006\u0002\u0004\u0003:L\bB\u0002-\b\t\u0003\u0007\u0011,\u0001\u0007eKN\u001c'/\u001b2f\u0007\u0006dG\u000eE\u0002\u001752K!aW\f\u0003\u0011q\u0012\u0017P\\1nKz\u0002")
public class SageMakerResourceCleanup {
    private final AmazonSageMaker sagemaker;

    public void deleteResources(CreatedResources resources) {
        try {
            resources.endpointName().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                this.deleteEndpoint(x$1);
                return BoxedUnit.UNIT;
            });
            resources.endpointConfigName().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                this.deleteEndpointConfig(x$2);
                return BoxedUnit.UNIT;
            });
            resources.modelName().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                this.deleteModel(x$3);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            throw new SageMakerResourceCleanupException("Resource cleanup failed. Cleanup can be retried if appropriate by calling deleteResources again.", t, resources);
        }
    }

    public void deleteEndpoint(String name) {
        DescribeEndpointRequest describeEndpointRequest = new DescribeEndpointRequest().withEndpointName(name);
        InternalUtils$.MODULE$.applyUserAgent((AmazonWebServiceRequest)describeEndpointRequest);
        this.tryDescribe((Function0 & Serializable & scala.Serializable)() -> $this.sagemaker.describeEndpoint(describeEndpointRequest)).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            DeleteEndpointRequest deleteRequest = new DeleteEndpointRequest().withEndpointName(name);
            InternalUtils$.MODULE$.applyUserAgent((AmazonWebServiceRequest)deleteRequest);
            return $this.sagemaker.deleteEndpoint(deleteRequest);
        });
    }

    public void deleteEndpointConfig(String name) {
        DescribeEndpointConfigRequest describeEndpointConfigRequest = new DescribeEndpointConfigRequest().withEndpointConfigName(name);
        InternalUtils$.MODULE$.applyUserAgent((AmazonWebServiceRequest)describeEndpointConfigRequest);
        this.tryDescribe((Function0 & Serializable & scala.Serializable)() -> $this.sagemaker.describeEndpointConfig(describeEndpointConfigRequest)).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            DeleteEndpointConfigRequest deleteRequest = new DeleteEndpointConfigRequest().withEndpointConfigName(name);
            InternalUtils$.MODULE$.applyUserAgent((AmazonWebServiceRequest)deleteRequest);
            return $this.sagemaker.deleteEndpointConfig(deleteRequest);
        });
    }

    public void deleteModel(String name) {
        DescribeModelRequest describeModelRequest = new DescribeModelRequest().withModelName(name);
        InternalUtils$.MODULE$.applyUserAgent((AmazonWebServiceRequest)describeModelRequest);
        this.tryDescribe((Function0 & Serializable & scala.Serializable)() -> $this.sagemaker.describeModel(describeModelRequest)).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            DeleteModelRequest deleteRequest = new DeleteModelRequest().withModelName(name);
            InternalUtils$.MODULE$.applyUserAgent((AmazonWebServiceRequest)deleteRequest);
            return $this.sagemaker.deleteModel(deleteRequest);
        });
    }

    private <T> Try<T> tryDescribe(Function0<T> describeCall) {
        Try try_ = Try$.MODULE$.apply(describeCall);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object v = success.value();
            return new Success(v);
        }
        if (try_ instanceof Failure) {
            AmazonSageMakerException amazonSageMakerException;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            Throwable throwable = e;
            if (throwable instanceof AmazonSageMakerException && !RetryUtils.isRetryableServiceException((AmazonServiceException)(amazonSageMakerException = (AmazonSageMakerException)throwable))) {
                return new Failure((Throwable)amazonSageMakerException);
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                throw throwable2;
            }
            throw new MatchError((Object)throwable);
        }
        throw new MatchError((Object)try_);
    }

    public SageMakerResourceCleanup(AmazonSageMaker sagemaker) {
        this.sagemaker = sagemaker;
    }
}

