# Generated by Django 3.1.2 on 2021-01-05 18:07

# Django
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("eveuniverse", "0004_effect_longer_name"),
        ("memberaudit", "0003_stats_n_skillset_autocomplete"),
    ]

    operations = [
        migrations.CreateModel(
            name="ActivityFilter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        help_text="The filter description that is shown to end users.",
                        max_length=500,
                    ),
                ),
                (
                    "inactivity_threshold",
                    models.PositiveIntegerField(
                        help_text="Maximum allowable inactivity, in <strong>days</strong>."
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="AgeFilter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        help_text="The filter description that is shown to end users.",
                        max_length=500,
                    ),
                ),
                (
                    "age_threshold",
                    models.PositiveIntegerField(
                        help_text="Minimum allowable age, in <strong>days</strong>."
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ComplianceFilter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        help_text="The filter description that is shown to end users.",
                        max_length=500,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SkillPointFilter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        help_text="The filter description that is shown to end users.",
                        max_length=500,
                    ),
                ),
                (
                    "skill_point_threshold",
                    models.PositiveBigIntegerField(
                        help_text="Minimum allowable skillpoints."
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SkillSetFilter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        help_text="The filter description that is shown to end users.",
                        max_length=500,
                    ),
                ),
                (
                    "skill_sets",
                    models.ManyToManyField(
                        help_text="Users must possess all of the skills in <strong>one</strong> of the selected skillsets.",
                        to="memberaudit.SkillSet",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="AssetFilter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        help_text="The filter description that is shown to end users.",
                        max_length=500,
                    ),
                ),
                (
                    "assets",
                    models.ManyToManyField(
                        help_text="User must possess <strong>one</strong> of the selected assets.",
                        to="eveuniverse.EveType",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
