import asyncio
from concurrent.futures import ThreadPoolExecutor

from taskiq import AsyncBroker
from taskiq.cli.worker.run import shutdown_broker
from taskiq.receiver import Receiver


async def run_worker(broker: AsyncBroker, worker_count=2, shutdown_timeout=90):
    shutdown_event = asyncio.Event()
    try:
        tasks = []
        with ThreadPoolExecutor(max_workers=worker_count) as pool:
            for _ in range(worker_count):
                receiver = Receiver(
                    broker=broker,
                    executor=pool,
                    validate_params=True,
                    max_async_tasks=1,
                    max_prefetch=0,
                )
                broker.is_worker_process = True
                tasks.append(receiver.listen(shutdown_event))

            await asyncio.gather(*tasks)
    finally:
        await shutdown_broker(broker, shutdown_timeout)
