"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebsiteAliasRecord = void 0;
const crypto = require("crypto");
const aws_route53_1 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
class WebsiteAliasRecord extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { domainName, recordNames, target } = props;
        const zone = aws_route53_1.HostedZone.fromLookup(this, 'Zone', {
            domainName,
        });
        recordNames.forEach((recordName) => {
            const hash = crypto.createHash('md5').update(recordName).digest('hex').substr(0, 6);
            new aws_route53_1.ARecord(this, `WebsiteAliasRecord${hash}`, {
                zone,
                recordName: `${recordName}.`,
                target: aws_route53_1.RecordTarget.fromAlias(target),
            });
            if (!props.disableIPv6) {
                new aws_route53_1.AaaaRecord(this, `WebsiteIPv6AliasRecord${hash}`, {
                    zone,
                    recordName: `${recordName}.`,
                    target: aws_route53_1.RecordTarget.fromAlias(target),
                });
            }
        });
    }
}
exports.WebsiteAliasRecord = WebsiteAliasRecord;
//# sourceMappingURL=data:application/json;base64,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