"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const kong_core = require("kong-core");
// import * as kong_core from '../../kong-core/';
const index_1 = require("./resources/helm-charts/kong/index");
/**
 * @summary The KongEks class.
 */
class KongEks extends constructs_1.Construct {
    //   public readonly rdsCluster: rds.DatabaseInstance;
    //   public readonly eksCluster: eks.Cluster;
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        //TODO : Modularize this further
        // const kong_namespace = 'kong-dp';
        const data_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'DPSecretsKey');
        // const data_plane_secretskey = new kms.Key(this, 'DataPlaneSecretsKey');
        // const artifactoryBucket = new s3.Bucket(this, 'ArtifactoryBucket');
        const data_plane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'DP', {
            ...props.dataPlaneClusterProps,
            secretsEncryptionKey: data_plane_secretskey,
            defaultCapacity: 0,
        });
        const dp_nodegroup = data_plane.addNodegroupCapacity('DpASG', props.dataPlaneNodeProps);
        dp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: data_plane,
        //   nodegroup: dp_nodegroup,
        // });
        // TODO : Make a new construct class for all helm charts
        // new ElastiCacheStack(this, 'KongCache', {
        //   numberofnodegroups: 3,
        //   vpc: data_plane.vpc,
        // });
        const kong_pre_requisites_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPreReqsStack');
        new kong_core.AwsCertManager(kong_pre_requisites_nested_stack, 'AwsCertManager', {
            cluster: data_plane,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            privateCaArn: props.privateCaArn,
        });
        new kong_core.SecretsManager(kong_pre_requisites_nested_stack, 'SecretsCsi', {
            cluster: data_plane,
        });
        //TODO : Error: kong-dp/KongEksDp/KongPreReqsStack/AutoScalar/KarpenterNodeRole should be defined in the scope of the kong-dp stack to prevent circular dependencies
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: data_plane,
            nodegroup: dp_nodegroup,
            namespace: 'kube-system',
        });
        new kong_core.MetricsServer(kong_pre_requisites_nested_stack, 'MetricsServer', {
            cluster: data_plane,
        });
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryStack');
        new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            createPrometheusWorkspace: props.kongTelemetryOptions.createPrometheusWorkspace,
            prometheusEndpoint: props.kongTelemetryOptions.prometheusEndpoint,
            cluster: data_plane,
            namespace: kong_core.Namespace.TELEMETRY,
            cacertname: kong_core.Tls.ADOT_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            dnsNames: [
                'kong-dp.internal',
                'admin.kong-cp.internal',
                'cluster.kong-cp.internal',
                'telemetry.kong-cp.internal',
                'manager.kong-cp.internal',
            ],
            hostedZoneName: 'kong-dp.internal',
        });
        telemetry_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
        const kong_data_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongDpStack');
        new index_1.KongDataPlane(kong_data_plane_nested_stack, 'KongDPHelmInstall', {
            cluster: data_plane,
            namespace: kong_core.Namespace.KONG_DATA_PLANE,
            cluster_dns: props.clusterDns,
            telemetry_dns: props.telemetryDns,
            // nodegroup: dp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            cacertname: kong_core.Tls.KONG_DP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            dnsNames: [
                'kong-dp.internal',
                'admin.kong-cp.internal',
                'cluster.kong-cp.internal',
                'telemetry.kong-cp.internal',
                'manager.kong-cp.internal',
            ],
            hostedZoneName: 'kong-dp.internal',
        });
        kong_data_plane_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
    }
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-data-plane.KongEks", version: "2.0.5" };
//# sourceMappingURL=data:application/json;base64,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