# Splitres

## Описание
[Splitres.py](https://gitwork.ru/barabass/splitres/-/blob/new/src/splitres.py) - программа обработки данных 
в формате вывода команды messtat -s.(подробнее о [messtat](https://gitwork.ru/ekiselev/messtat/-/blob/master/README.md)), предназначенная  для вычисления минимального, максимального и среднего энергопотребления, 
количества израсходованной энергии для каждого вычислительного устройства.

Результатом выполнения программы будет являться файл, содержащий:    
        :small_red_triangle_down: название исследуемого файла    
        :small_red_triangle_down: минимальное значение энергопотребления;    
        :small_red_triangle_down: максимальное значение энергопотребления;    
        :small_red_triangle_down: среднее значение энергопотребления;    
        :small_red_triangle_down: сумма значений энергопотребления;    

Название файла будет формироваться по принципу `messtat_$HOSTNAME.messtat.splitres`, 
где `$HOSTNAME` - имя вычислительного узла, для которого производилось измерение.

## Указания по запуску программы

На вход программе подаётся либо путь до файла с расширением `.messtat` , либо же дирректория, в которой содержатся необходимые файлы.

Для запуска через консоль необходимо ввести следующую команду:

```bash
python3 src/splitres.py <file_path> <result_path>
```

 `file_path` - путь до файла, либо до необходимой дирректории.

`result_path` - путь до каталога, куда будут помещены результирующие файлы. По умолчанию в текущей директории будет создана папка "Result", куда будут помещены все результирующие файлы.

Для получения справки о работе программы введите `-h` или `--help`

```bash
python3.7 src/splitres.py -h(или --help)
```



## Тестирование

Покрытие тестами реализовано следующим образом:

1. Проверяем работоспособность, если на вход подана директория;
2. Проверяем работоспособность, если на вход подан файл;
3. Проверяем, что файл не создаётся и возвращается пустой список при указании пути до несуществующей директории/файла.

Для запуска тестов необходимо ввести следующую команду:

```bash
python3 -m py.test --cov=src --cov-report term-missing  tests/tests.py
```

## Работа с пакетом

Пакет загружен на [PyPi](https://pypi.org/). Будучи разработчиком, если Вы пожелаете внести  изменения в проект, то после обновления кода Вам необходимо в файле setup.py изменить версию пакета, а затем прописать в командной строке следующую команду:

```bash
python3 setup.py sdist
```

После её выполнения в Вашем проекте будет создана папка с конфигурационными данными пакета, а так же будет создана папка dist, в которой будет лежать упакованный проект, которым Вы сможете делиться с другими пользователями.

Перед выгрузкой пакета необходимо дополнительно установить утилиту twine (подробнее о [twine](https://pypi.org/project/twine/)):

```bash
sudo apt update
sudo apt install twine
```

Для непосредственной выгрузки проекта на [PyPi](https://pypi.org/) необходимо прописать следующую команду:

```bash
twine upload dist/*
```

После проведённых действий пользователь сможет установить актуальную версию проекта, прописав в командной строке следующую команду:

```bash
pip3 install splitres
```

Если у Вас уже установлена некоторая версия пакета splitres, и Вы желаете обновиться до актуальной версии проекта, то необходимо прописать в командной строке:

```bash
pip3 install splitres --upgrade
```

После этого действия будет установлена актуальная версия пакета.