/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.utils.MathUtils;
import java.util.HashMap;
import java.util.Map;

public class BinaryEncoder
implements CategoricalEncoder {
    private final String columnName;
    private final int targetIndex;
    private final Map<String, Integer> domainMap;
    private final int binaryCategorySizes;

    BinaryEncoder(String columnName, int targetIndex, String[] domainValues) {
        this.columnName = columnName;
        this.targetIndex = targetIndex;
        this.binaryCategorySizes = 1 + MathUtils.log2(domainValues.length - 1 + 1);
        this.domainMap = new HashMap<String, Integer>(domainValues.length);
        for (int j2 = 0; j2 < domainValues.length; ++j2) {
            this.domainMap.put(domainValues[j2], j2);
        }
    }

    @Override
    public boolean encodeCatValue(String levelName, double[] rawData) {
        Integer levelIndex = this.domainMap.get(levelName);
        if (levelIndex == null) {
            return false;
        }
        this.makeBinary(levelIndex, rawData);
        return true;
    }

    @Override
    public void encodeNA(double[] rawData) {
        this.makeBinary(-1, rawData);
    }

    private void makeBinary(int index, double[] rawData) {
        long val = index + 1;
        for (int i2 = 0; i2 < this.binaryCategorySizes; ++i2) {
            rawData[this.targetIndex + i2] = val & 1L;
            val >>>= 1;
        }
    }

    public String toString() {
        return "BinaryEncoder{columnName='" + this.columnName + '\'' + ", targetIndex=" + this.targetIndex + ", domainMap=" + this.domainMap + '}';
    }
}

