/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.psvm;

import hex.genmodel.algos.psvm.KernelParameters;
import hex.genmodel.algos.psvm.SupportVectorScorer;
import hex.genmodel.utils.ByteBufferWrapper;

class GaussianScorer
implements SupportVectorScorer {
    private final double _gamma;
    private final byte[] _svs;

    GaussianScorer(KernelParameters parms, byte[] svs) {
        this(parms._gamma, svs);
    }

    GaussianScorer(double gamma, byte[] svs) {
        this._gamma = gamma;
        this._svs = svs;
    }

    @Override
    public double score0(double[] row) {
        double result = 0.0;
        ByteBufferWrapper bb = new ByteBufferWrapper(this._svs);
        while (bb.hasRemaining()) {
            double alpha = bb.get8d();
            double norm = 0.0;
            int cats = bb.get4();
            for (int i2 = 0; i2 < cats; ++i2) {
                norm += (int)row[i2] == bb.get4() ? 0.0 : 2.0;
            }
            int nums = bb.get4();
            for (int i3 = 0; i3 < nums; ++i3) {
                double v2 = row[i3 + cats] - bb.get8d();
                norm += v2 * v2;
            }
            result += alpha * Math.exp(-this._gamma * norm);
        }
        return result;
    }
}

