/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.utils.MojoDateTime;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MojoColumn
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MojoColumn.class);

    @Deprecated
    public abstract String debug();

    public abstract Type getType();

    public abstract Object getData();

    public abstract String[] getDataAsStrings();

    public abstract int size();

    abstract void resize(int var1);

    abstract void fillFromParsedListData(List var1);

    public static enum Kind {
        Feature,
        Output,
        Interim;

    }

    public static enum Type {
        Bool((Class)Byte.TYPE, (Object)-128, false, false, new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Float.class, Long.class, Double.class}){

            @Override
            protected Object castFromJavaType(Object value) {
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? (byte)1 : 0;
                }
                byte b2 = ((Number)value).byteValue();
                if (b2 == 1) {
                    return true;
                }
                if (b2 == 0) {
                    return false;
                }
                throw new IllegalArgumentException("Only 1 or 0 is allowed when storing data into Boolean column from numeric types.");
            }

            @Override
            protected Object parseImpl(String val) {
                return Type.parseBoolean(val) ? (byte)1 : 0;
            }

            @Override
            public boolean isNA(Object val) {
                return val instanceof Byte && ((Byte)val).byteValue() == ((Byte)this.ona).byteValue();
            }
        }
        ,
        Int32((Class)Integer.TYPE, (Object)Integer.MIN_VALUE, true, false, new Class[]{Byte.class, Short.class, Integer.class}){

            @Override
            protected Object castFromJavaType(Object value) {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return value;
            }

            @Override
            protected Integer parseImpl(String val) {
                try {
                    return Integer.valueOf(val);
                }
                catch (NumberFormatException nfe) {
                    try {
                        int result = (int)Type.parseDoubleOrBoolean(val);
                        log.warn("Int32: value '{}' parsed as {}", (Object)val, (Object)result);
                        return result;
                    }
                    catch (NumberFormatException tmp) {
                        throw nfe;
                    }
                }
            }

            @Override
            public boolean isNA(Object val) {
                return val instanceof Integer && ((Integer)val).intValue() == ((Integer)this.ona).intValue();
            }
        }
        ,
        Int64((Class)Long.TYPE, (Object)Long.MIN_VALUE, true, false, new Class[]{Byte.class, Short.class, Integer.class, Long.class}){

            @Override
            protected Long parseImpl(String val) {
                try {
                    return Long.valueOf(val);
                }
                catch (NumberFormatException nfe) {
                    try {
                        long result = (long)Type.parseDoubleOrBoolean(val);
                        log.warn("Int64: value '{}' parsed as {}", (Object)val, (Object)result);
                        return result;
                    }
                    catch (NumberFormatException tmp) {
                        throw nfe;
                    }
                }
            }

            @Override
            public boolean isNA(Object val) {
                return val instanceof Long && ((Long)val).longValue() == ((Long)this.ona).longValue();
            }
        }
        ,
        Float32((Class)Float.TYPE, (Object)Float.valueOf(Float.NaN), true, true, new Class[]{Byte.class, Short.class, Integer.class, Float.class, Double.class}){

            @Override
            protected Float parseImpl(String val) {
                try {
                    return Float.valueOf(val);
                }
                catch (NumberFormatException nfe) {
                    try {
                        return Float.valueOf((float)Type.parseDoubleOrBoolean(val));
                    }
                    catch (NumberFormatException tmp) {
                        throw nfe;
                    }
                }
            }

            @Override
            protected Object castFromJavaType(Object value) {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                return value;
            }

            @Override
            public boolean isNA(Object val) {
                return val instanceof Float && Float.isNaN(((Float)val).floatValue());
            }
        }
        ,
        Float64((Class)Double.TYPE, (Object)Double.NaN, true, true, new Class[]{Byte.class, Short.class, Integer.class, Float.class, Long.class, Double.class}){

            @Override
            protected Double parseImpl(String val) {
                return Type.parseDoubleOrBoolean(val);
            }

            @Override
            protected Object castFromJavaType(Object value) {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                return value;
            }

            @Override
            public boolean isNA(Object val) {
                return val instanceof Double && Double.isNaN((Double)val);
            }
        }
        ,
        Str((Class)String.class, (Object)null, false, false, new Class[]{String.class, Character.class}){

            @Override
            protected Object castFromJavaType(Object value) {
                return value != null ? value.toString() : null;
            }

            @Override
            public Object parse(String val) {
                if (val != null && val.length() > 1) {
                    int eidx = val.length() - 1;
                    if (val.charAt(0) == '\"' && val.charAt(eidx) == '\"') {
                        val = val.substring(1, eidx);
                    }
                }
                return val;
            }

            @Override
            protected Object parseImpl(String val) {
                throw new UnsupportedOperationException("This method should not be called!");
            }

            @Override
            public boolean isNA(Object val) {
                return val == this.ona;
            }
        }
        ,
        Time64((Class)MojoDateTime.class, (Object)null, false, false, new Class[]{Timestamp.class, Date.class}){

            @Override
            protected Object castFromJavaType(Object value) {
                return value != null ? MojoDateTime.parse(value.toString()) : null;
            }

            @Override
            protected Object parseImpl(String val) {
                return MojoDateTime.parse(val);
            }

            @Override
            public boolean isNA(Object val) {
                return val == this.ona;
            }
        };

        private static final Map<String, Boolean> MOJO2_BOOL_STRINGS;
        public final Object NULL;
        public final Class<?> javaclass;
        public final Object ona;
        public final boolean isnumeric;
        public final boolean isfloat;
        final HashSet<Class> assignableFromJavaTypes;

        private Type(Class<?> javaclass, Object ona, boolean isnumeric, boolean isfloat, Class[] assignableFromJavaTypes) {
            this.javaclass = javaclass;
            this.ona = ona;
            this.NULL = this.parse(null);
            this.isnumeric = isnumeric;
            this.isfloat = isfloat;
            this.assignableFromJavaTypes = new HashSet<Class>(Arrays.asList(assignableFromJavaTypes));
        }

        private static boolean parseBoolean(String val) {
            Boolean result = MOJO2_BOOL_STRINGS.get(val.trim());
            if (result == null) {
                throw new NumberFormatException(String.format("For input string: '%s'", val));
            }
            return result;
        }

        private static double parseDoubleOrBoolean(String s2) {
            try {
                return Double.parseDouble(s2);
            }
            catch (NumberFormatException e2) {
                try {
                    double result = Type.parseBoolean(s2) ? 1.0 : 0.0;
                    log.warn("Bool value '{}' parsed as '{}' (double)", (Object)s2, (Object)result);
                    return result;
                }
                catch (NumberFormatException ignored) {
                    throw e2;
                }
            }
        }

        public Object parse(String val) {
            if (val == null || val.isEmpty()) {
                return this.ona;
            }
            return this.parseImpl(val);
        }

        public boolean isAssignableFrom(Class<?> javaClazz) {
            return this.assignableFromJavaTypes.contains(javaClazz);
        }

        private void failIfNotAssignableFrom(Class<?> javaClazz) {
            if (!this.isAssignableFrom(javaClazz)) {
                throw new ClassCastException(String.format("Mojo column of type %s can be assigned Java values only from the following types: %s , Java class on the input was: %s", this.name(), this.assignableFromJavaTypes.toString(), javaClazz.getSimpleName()));
            }
        }

        protected Object castFromJavaType(Object value) {
            return value;
        }

        protected Object fromJavaClass(Object value) {
            if (value != null) {
                this.failIfNotAssignableFrom(value.getClass());
                return this.castFromJavaType(value);
            }
            return null;
        }

        protected abstract Object parseImpl(String var1);

        public abstract boolean isNA(Object var1);

        static {
            MOJO2_BOOL_STRINGS = new LinkedHashMap<String, Boolean>();
            MOJO2_BOOL_STRINGS.put("true", Boolean.TRUE);
            MOJO2_BOOL_STRINGS.put("True", Boolean.TRUE);
            MOJO2_BOOL_STRINGS.put("TRUE", Boolean.TRUE);
            MOJO2_BOOL_STRINGS.put("1", Boolean.TRUE);
            MOJO2_BOOL_STRINGS.put("1.0", Boolean.TRUE);
            MOJO2_BOOL_STRINGS.put("false", Boolean.FALSE);
            MOJO2_BOOL_STRINGS.put("False", Boolean.FALSE);
            MOJO2_BOOL_STRINGS.put("FALSE", Boolean.FALSE);
            MOJO2_BOOL_STRINGS.put("0", Boolean.FALSE);
            MOJO2_BOOL_STRINGS.put("0.0", Boolean.FALSE);
        }
    }
}

