import { Asset } from 'aws-cdk-lib/aws-s3-assets';
import { Construct } from 'constructs';
import { IDocument } from '..';
export interface SchemaAssetProps {
    dir?: string;
}
export declare class SchemaAsset extends Asset {
    /**
     * Resolve a tokenized value in the context of the current stack.
     *
     * This is required for the S3 uploaded definition to work.
     */
    static resolveSchemaTokens(scope: Construct, document: IDocument): any;
    /** Resolve the target directory for the schema asset. */
    private static resolveDir;
    /** The target directory must exists. */
    private static ensureDir;
    /** Resolve filename for the generated file. */
    private static resolveFileName;
    /** Resolve the full path for the generated file. */
    private static resolveFilePath;
    /** S3 Asset requires the data to be available on filesystem, so let's write it there. */
    private static write;
    /**
     * Value of `IDocument` resolved for CloudFormation.
     * Essentially with CDK Tokens resolved into CloudFormation References.
     */
    readonly cloudFormationDocument: any;
    /**
     * Construct a new Schema Definition Asset that will be uploaded into S3
     * and then referenced in CloudFormation template.
     */
    constructor(scope: Construct, id: string, document: IDocument, props?: SchemaAssetProps);
}
