import { Construct } from 'constructs';
import { Integration, ValidatorConfig } from './base';
export interface CorsIntegrationProps extends ValidatorConfig {
    readonly headers: string;
    readonly origins: string;
    readonly methods: string;
}
/**
 * Defines `OPTIONS` integration used in Cross-Origin Resource Sharing (CORS).
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-cors.html
 * @see https://medium.com/@srikanth650/use-api-gateway-with-mock-integration-to-allow-cors-from-multiple-origins-bdcb431d07d3
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/request-response-data-mappings.html#mapping-response-parameters
 */
export declare class CorsIntegration extends Integration {
    /** Build Apache Velocity (`.vtl`) template for CORS response. */
    private static buildTemplate;
    /**
     * Defines `OPTIONS` integration used in Cross-Origin Resource Sharing (CORS).
     *
     * @example
     * '/bar': {
     *   'OPTIONS': new openapix.CorsIntegration(this, {
     *     headers: 'Content-Type,X-Amz-Date,Authorization',
     *     origins: '*',
     *     methods: 'OPTIONS,GET',
     *   }),
     * },
     */
    constructor(_: Construct, props: CorsIntegrationProps);
}
