import { IntegrationProps } from 'aws-cdk-lib/aws-apigateway';
import { XAmazonApigatewayIntegration } from '../x-amazon-apigateway';
/** Interface implemented by all integrations. */
export interface IBaseIntegration {
    /** Identifier to enable internal type checks. */
    readonly type: InternalIntegrationType;
    readonly xAmazonApigatewayIntegration: XAmazonApigatewayIntegration;
    readonly validator?: string;
}
export declare enum InternalIntegrationType {
    AWS = "AWS",
    CORS = "CORS",
    HTTP = "HTTP",
    LAMBDA = "LAMBDA",
    MOCK = "MOCK"
}
/** Method integration validator configuration. */
export interface ValidatorConfig {
    /**
     * Validator identifier for method integration. This will override the default
     * validator if one configured.
     *
     * Should match a key from OpenApi schema `components.securitySchemas`.
     */
    readonly validator?: string;
}
/** Base integration config. */
export interface IntegrationConfig extends ValidatorConfig {
    readonly type: InternalIntegrationType;
}
/**
 * Essentially responsible for converting CDK `IntegrationProps` into
 * API Gateway OpenApi integration extension ()`XAmazonApigatewayIntegration`).
 * Also defines few basic methods (`getIntegration` & `getValidatorId`) used
 * by derivative classes.
 */
export declare abstract class Integration implements IBaseIntegration {
    readonly xAmazonApigatewayIntegration: XAmazonApigatewayIntegration;
    readonly validator?: string;
    readonly type: InternalIntegrationType;
    /** Construc a new integration. */
    constructor(props: IntegrationProps, config: IntegrationConfig);
    /**
     * Convert CDK integration into API Gateway OpenApi integration extension.
     */
    private mapPropsToIntegration;
    private resolveTimeout;
    private resolveResponses;
    /**
     * Decide selection pattern.
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_apigateway.IntegrationResponse.html#selectionpattern
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-responses.html
     *
     * @default
     * resp.statusCode
     */
    private resolveSelectionPattern;
}
