import * as apigateway from 'aws-cdk-lib/aws-apigateway';
import { Construct } from 'constructs';
import { IDocument } from '../schema';
import { ApiBaseProps } from './props';
/** Represents an OpenAPI v3 definition asset. */
export declare class ApiDefinition extends apigateway.ApiDefinition {
    /**
     * Exposes the processed OpenApi Schema Object.
     * Mainly useful for testing purposes.
     */
    readonly document: IDocument;
    /** Determines if `s3Location` or `inlineDefinition` is used by `bind()` method. */
    private readonly upload;
    /** Construct scope into which the SpecRestApi is created. */
    private readonly scope;
    /** Schema instance that will be processed/modified. */
    private readonly schema;
    /** Represents an OpenAPI v3 definition asset. */
    constructor(scope: Construct, props: ApiBaseProps);
    /** Configures API Gateway validators (if any). */
    private configureValidators;
    /**
     * Configure Authorizers within OpenApi `components.securitySchemes`.
     */
    private configureAuthorizers;
    /**
     * Configure all `x-amazon-apigateway-integration` values within OpenApi `paths`.
     */
    private configurePaths;
    /**
     * Configure `x-amazon-apigateway-integration` for given method.
     */
    private configurePathMethods;
    /**
     * End-User can provide the OpenAPI definition either as a path to a file or
     * as an Asset. This method handles that and always returns Asset Source.
     */
    private resolveSource;
    /**
     * Implement the functionality of exposing the API definition, either as `s3Location` or as `inlineDefinition`.
     *
     * Called by `apigateway.SpecRestApi`.
     *
     * @see https://github.com/aws/aws-cdk/blob/87dd2a6eb0b8208e49ff5f0cc8486ad58410d3ef/packages/%40aws-cdk/aws-apigateway/lib/restapi.ts#L636
     * @see https://github.com/aws/aws-cdk/blob/87dd2a6eb0b8208e49ff5f0cc8486ad58410d3ef/packages/%40aws-cdk/aws-apigateway/lib/api-definition.ts#L81-L88
     */
    bind(_: Construct): apigateway.ApiDefinitionConfig;
    /**
     * Ensures OpenAPI definition contains a given method for the path.
     */
    private ensureMethodExists;
    /**
     * Ensures OpenAPI definition does not already have
     * `x-amazon-apigateway-integration` configuration for given method for the path.
     */
    private ensureNoIntegrationAlready;
    /** Validate final OpenApi v3 document. */
    private validateDocument;
}
