from setuptools import setup, find_packages
from os.path import join, dirname
from os import environ
from logging import getLogger
from typing import Optional
logger=getLogger(__name__)
warning=logger.warning

# Determine the revision using the following sourcr priorities:
# 1) version.txt+git 2) version.txt
# and save it to version.py
ver=open(join(dirname(__file__),'version.txt')).read().strip()
LITREPL_REVISION:Optional[str]
try:
  LITREPL_REVISION=environ["LITREPL_REVISION"]
except Exception:
  warning("Couldn't read LITREPL_REVISION, trying `git rev-parse`")
  try:
    from subprocess import check_output
    import sys
    LITREPL_REVISION=check_output(['git', 'rev-parse', 'HEAD'],
                                  cwd=environ['LITREPL_ROOT']).decode().strip()
  except Exception as e:
    warning("Couldn't use `git rev-parse`, no revision metadata will be set")
    LITREPL_REVISION=None

with open(join('python','litrepl','version.py'), 'w') as f:
  rev=f"+g{LITREPL_REVISION[:7]}" if LITREPL_REVISION is not None else ""
  f.write("# AUTOGENERATED by setup.exe!\n")
  f.write(f"__version__ = '{ver}{rev}'\n")

setup(
  name="litrepl",
  zip_safe=False, # https://mypy.readthedocs.io/en/latest/installed_packages.html
  version=f"{ver}",
  package_dir={'':'python'},
  packages=find_packages(where='python'),
  install_requires=['lark'],
  scripts=['./python/bin/litrepl'],
  python_requires='>=3.6',
  author="Sergei Mironov",
  author_email="grrwlf@gmail.com",
  description="LitREPL is a macroprocessing Python library for Litrate "\
              "programming and code execution.",
  classifiers=[
    "Programming Language :: Python :: 3",
    "License :: OSI Approved :: Apache Software License",
    "Operating System :: POSIX :: Linux",
    "Topic :: Software Development :: Build Tools",
    "Intended Audience :: Developers",
    "Development Status :: 3 - Alpha",
  ],
)

