## llm-cloudflare

A plugin for the [`llm`](https://llm.datasette.io/en/stable/) CLI that allows you to use the text generation models (LLMs) running on globally on Cloudflare [Workers AI](https://developers.cloudflare.com/workers-ai/models/#text-generation), including models like Llama 3.1, Mistral 7B, Gemma and a number of task-specific fine tunes.

`llm-cloudflare` is useful for:

* Using and building with LLMs that may not efficiently run on your local machine (limited GPU, memory, etc) vs. having Workers AI run it on a GPU near you.
* Validating the performance of and/or comparing multiple models.
* Experimenting without needing to download models ahead-of-time.

## Usage

**Prerequisite**: You'll need the `llm` CLI [installed first](https://llm.datasette.io/en/stable/setup.html).

Install and setup the plugin:

```sh
# Install the plugin from pip
llm install llm-cloudflare

# Provide a valid Workers AI token
# Docs: https://developers.cloudflare.com/workers-ai/get-started/rest-api/#1-get-api-token-and-account-id
llm keys set cloudflare

# Set your Cloudflare account ID
# Docs: https://developers.cloudflare.com/workers-ai/get-started/rest-api/#1-get-api-token-and-account-id
export CLOUDFLARE_ACCOUNT_ID="33charlonghexstringhere"
```

Use it by specifying a Workers AI model:

```sh
llm -m "@cf/meta/llama-3.1-8b-instruct" "Write a Cloudflare Worker in ESM format that returns an empty JSON object as a response. Show only the code."
```

You can set a Workers AI model as [the default model](https://llm.datasette.io/en/stable/setup.html#setting-a-custom-default-model) in `llm`:

```sh
# Set Llama 3.1 8B as the default
llm models default "@cf/meta/llama-3.1-8b-instruct" 
# See what model is set as the default
llm models default
# @cf/meta/llama-3.1-8b-instruct
```

## Available models

This plugin provides access to the [text generation models](https://developers.cloudflare.com/workers-ai/models/#text-generation) (LLMs) provided by Workers AI.

To see what models are available, invoke `llm models`. Models prefixed with `Cloudflare Workers AI` are provided by this plugin.

The supported models are generated by scripts. New models thus rely on this plugin being updated periodically.

In the future, this plugin may also add support for Workers AI's [embedding models](https://developers.cloudflare.com/workers-ai/models/#text-embeddings) for use with [`llm embed`](https://llm.datasette.io/en/stable/embeddings/index.html).

## Credits

Credit to [@hex](https://github.com/hex) for https://github.com/hex/llm-perplexity, which heavily inspired the design of this plugin.

## License

Copyright Cloudflare, Inc (2024). Apache-2.0 licensed. See the LICENSE file for details.
