"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBSeeder = void 0;
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const directories_1 = require("./directories");
class DynamoDBSeeder extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d;
        super(scope, id);
        const seeds = props.seeds.bind(this);
        const seedsBucket = ((_a = seeds.s3Location) === null || _a === void 0 ? void 0 : _a.bucketName) ? aws_s3_1.Bucket.fromBucketName(this, 'SeedsBucket', seeds.s3Location.bucketName) : undefined;
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, 'Custom::DynamodbSeeder', {
            codeDirectory: directories_1.dynamodbSeederDir,
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12,
            timeout: (_b = props.timeout) !== null && _b !== void 0 ? _b : core_1.Duration.minutes(15),
            policyStatements: [
                {
                    Effect: aws_iam_1.Effect.ALLOW,
                    Action: ['dynamodb:BatchWriteItem'],
                    Resource: props.table.tableArn,
                },
                seedsBucket
                    ? {
                        Effect: aws_iam_1.Effect.ALLOW,
                        Action: ['s3:GetObject'],
                        Resource: `${seedsBucket.bucketArn}/${(_d = (_c = seeds.s3Location) === null || _c === void 0 ? void 0 : _c.objectKey) !== null && _d !== void 0 ? _d : '*'}`,
                    }
                    : undefined,
            ],
        });
        new core_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType: 'Custom::DynamodbSeeder',
            properties: {
                TableName: props.table.tableName,
                Seeds: {
                    InlineSeeds: seeds.inlineSeeds,
                    S3Bucket: seeds.s3Location && seeds.s3Location.bucketName,
                    S3Key: seeds.s3Location && seeds.s3Location.objectKey,
                    S3ObjectVersion: seeds.s3Location && seeds.s3Location.objectVersion,
                },
            },
        });
    }
}
exports.DynamoDBSeeder = DynamoDBSeeder;
//# sourceMappingURL=data:application/json;base64,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