# Tally Python client
The Tally Python client is a wrapper for [Datasmoothie's Tally API](https://tally.datasmoothie.com) for market research and survey data. Tally is a RESTful
API that leverages Quantipy and other techologies to give users access to all the data processing, aggregation and
exporting functions they need.

Those who want to use python to communicate with Tally can both use the traditional
`requests` library, or they can use this wrapper for convenience.

# Installation
```pip isntall datasmoothie-tally-client```

The Tally client is compatible with all versions of Python 3.

# Quick start
Tally is compatible with both SPSS (.sav) files and Quantipy files.

```
import tally

ds = tally.DataSet(api_token=[your_token])
ds.use_spss('my_spss_file.sav')

pandas_dataframe = ds.crosstab(x=['q1', 'q2'], y=['gender'], ['locality'], sig_level=[0.05])

ds.build_powerpoint(filename='my_powerpoint.pptx',
                    powerpoint_template='My_Branded_Template.pptx', 
                    x=['q1', 'q2', 'q3'], 
                    y=['gender', 'locality']
                    )

ds.build_excel(filename='my_tables.xlsx',
               powerpoint_template='My_Branded_Template.pptx', 
               x=['q1', 'q2', 'q3'], 
               y=['gender', 'locality'],
               sig_level[0.05,  0.1]
               )

```
## Supported file formats and data sources
Tally supports SPSS fiels, Quantipy files. It also supports external datasources, such as Datasmoothie (with more on the way).

```
#datasmoothie (remote storage of data)
ds.use_datasmoothie(datasmoothie_token=[my_datasmoothie_api_token])

#datasmoothie (remote storage of data)
ds.use_confirmit(confirmit_credentials)

#using spss (local sav file)
ds.use_spss(path_to_sav_file)

#using csv (local CSV file, i.e. generated by Excel)
ds.use_csv(path_to_csv_file)

#using quantipy (local json and csv files)
ds.use_quantipy(path_to_json_metadata, path_to_csv_data)
```

# Building Excel tables

The Tally Python client has a convenience class called Build which wraps common Tally API tasks into an interface for easily building Excel Tables for surveys and market research.

## Get started with Build

Every build has a default dataset it uses to add tables. Users can also pass other datasets to the build process, for example when dealing with multple waves.

```
ds = tally.DataSet(api_key=your_token)
ds.use_spss('Example Data (A).sav')

build = tally.Build(name='client A', default_dataset=ds)
```

## Setting options for the build (layout, visuals, etc.)
A Build supports setting multiple options both on a sheet-by-sheet basis and on the build as a whole, which will apply to every sheet.

```
build.options.freeze_panes(9,1)
build.options.set_base_position('outside')
build.options.set_answer_format(
    'base', 
    {
        "font_color":"F15A30", 
        "bold":True,
        'text_wrap': True}
    )
build.options.set_question_format('percentage', {"bold":True})
build.options.set_format('base', {"bold":True})

sheet.options.set_format('base', {"bold": False})
```

## Adding tables to sheets of a build

```
sheet = build.add_sheet(banner=['gender', 'locality'])
sheet2 = build.add_sheet(banner=['gender', 'ethnicity'])

# set option that only applies to this sheet, not all of them
sheet2.options.set_format('stats', {"font_color":"98B4DF"})
sheet2.options.set_stats(stats=['mean', 'stddev'])

# add tables to the build, each sheet will have two questions
sheet.add_table(stub={'x':'q1'})
sheet.add_table(stub={'x':'q2b'})

sheet2.add_table(stub={'x':'q1'})
sheet2.add_table(stub={'x':'q2b'})
```
## Saving to Excel

Once the build is ready, saving the Excel output is simple.
```
build.save_excel('test_build_options.xlsx')
```

When the build is first created, the user can also decide on whether to auto-generate a table of contents or add a logo to the file.

# Developing the Tally Python client

## Gitpod
Click the button to get started developing the wrapper with GitPod:

[![Open in Gitpod](https://gitpod.io/button/open-in-gitpod.svg)](https://gitpod.io/#https://github.com/datasmoothie/tally-client/)

Once you are up and running in GitPod, the tests can be run with 

```python -m pytest --token=[my_token]```

In this case the tests will run against the live Tally server, which will count against your API calls quota. 

Or if you have a development server of Tally running, use

```python -m pytest --api_url=[url_for_tally] --token=[my_token]```

### Developing the wrapper

We use pytest to test. Example pytest commands are

Run all tests
```python -m pytest --token=[your_token]```

Run all tests for SPSS files
```python -m pytest -k spss --token=[your_token]```

Run test called `test_spss_crosstab`
```python -m pytest -k test_spss_crosstab --token=[your_token]```

The `-k` parameter for pytest uses the supplied argument as a keyword and runs all tests that match the string. 