# coding: utf-8

"""
    Xero Payroll NZ

    This is the Xero Payroll API for orgs in the NZ region.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class StatutoryDeductionLine(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "statutory_deduction_type_id": "str",
        "amount": "float",
        "fixed_amount": "float",
        "manual_adjustment": "bool",
    }

    attribute_map = {
        "statutory_deduction_type_id": "statutoryDeductionTypeID",
        "amount": "amount",
        "fixed_amount": "fixedAmount",
        "manual_adjustment": "manualAdjustment",
    }

    def __init__(
        self,
        statutory_deduction_type_id=None,
        amount=None,
        fixed_amount=None,
        manual_adjustment=None,
    ):  # noqa: E501
        """StatutoryDeductionLine - a model defined in OpenAPI"""  # noqa: E501

        self._statutory_deduction_type_id = None
        self._amount = None
        self._fixed_amount = None
        self._manual_adjustment = None
        self.discriminator = None

        if statutory_deduction_type_id is not None:
            self.statutory_deduction_type_id = statutory_deduction_type_id
        if amount is not None:
            self.amount = amount
        if fixed_amount is not None:
            self.fixed_amount = fixed_amount
        if manual_adjustment is not None:
            self.manual_adjustment = manual_adjustment

    @property
    def statutory_deduction_type_id(self):
        """Gets the statutory_deduction_type_id of this StatutoryDeductionLine.  # noqa: E501

        Xero identifier for payroll statutory deduction type  # noqa: E501

        :return: The statutory_deduction_type_id of this StatutoryDeductionLine.  # noqa: E501
        :rtype: str
        """
        return self._statutory_deduction_type_id

    @statutory_deduction_type_id.setter
    def statutory_deduction_type_id(self, statutory_deduction_type_id):
        """Sets the statutory_deduction_type_id of this StatutoryDeductionLine.

        Xero identifier for payroll statutory deduction type  # noqa: E501

        :param statutory_deduction_type_id: The statutory_deduction_type_id of this StatutoryDeductionLine.  # noqa: E501
        :type: str
        """

        self._statutory_deduction_type_id = statutory_deduction_type_id

    @property
    def amount(self):
        """Gets the amount of this StatutoryDeductionLine.  # noqa: E501

        The amount of the statutory deduction line  # noqa: E501

        :return: The amount of this StatutoryDeductionLine.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this StatutoryDeductionLine.

        The amount of the statutory deduction line  # noqa: E501

        :param amount: The amount of this StatutoryDeductionLine.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def fixed_amount(self):
        """Gets the fixed_amount of this StatutoryDeductionLine.  # noqa: E501

        Fixed Amount  # noqa: E501

        :return: The fixed_amount of this StatutoryDeductionLine.  # noqa: E501
        :rtype: float
        """
        return self._fixed_amount

    @fixed_amount.setter
    def fixed_amount(self, fixed_amount):
        """Sets the fixed_amount of this StatutoryDeductionLine.

        Fixed Amount  # noqa: E501

        :param fixed_amount: The fixed_amount of this StatutoryDeductionLine.  # noqa: E501
        :type: float
        """

        self._fixed_amount = fixed_amount

    @property
    def manual_adjustment(self):
        """Gets the manual_adjustment of this StatutoryDeductionLine.  # noqa: E501

        Identifies if the tax line is a manual adjustment  # noqa: E501

        :return: The manual_adjustment of this StatutoryDeductionLine.  # noqa: E501
        :rtype: bool
        """
        return self._manual_adjustment

    @manual_adjustment.setter
    def manual_adjustment(self, manual_adjustment):
        """Sets the manual_adjustment of this StatutoryDeductionLine.

        Identifies if the tax line is a manual adjustment  # noqa: E501

        :param manual_adjustment: The manual_adjustment of this StatutoryDeductionLine.  # noqa: E501
        :type: bool
        """

        self._manual_adjustment = manual_adjustment
