# coding: utf-8

"""
    Xero AppStore API

    These endpoints are for Xero Partners to interact with the App Store Billing platform  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class Subscription(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "current_period_end": "datetime",
        "end_date": "datetime",
        "id": "str",
        "organisation_id": "str",
        "plans": "list[Plan]",
        "start_date": "datetime",
        "status": "str",
        "test_mode": "bool",
    }

    attribute_map = {
        "current_period_end": "currentPeriodEnd",
        "end_date": "endDate",
        "id": "id",
        "organisation_id": "organisationId",
        "plans": "plans",
        "start_date": "startDate",
        "status": "status",
        "test_mode": "testMode",
    }

    def __init__(
        self,
        current_period_end=None,
        end_date=None,
        id=None,
        organisation_id=None,
        plans=None,
        start_date=None,
        status=None,
        test_mode=None,
    ):  # noqa: E501
        """Subscription - a model defined in OpenAPI"""  # noqa: E501

        self._current_period_end = None
        self._end_date = None
        self._id = None
        self._organisation_id = None
        self._plans = None
        self._start_date = None
        self._status = None
        self._test_mode = None
        self.discriminator = None

        self.current_period_end = current_period_end
        if end_date is not None:
            self.end_date = end_date
        self.id = id
        self.organisation_id = organisation_id
        self.plans = plans
        self.start_date = start_date
        self.status = status
        if test_mode is not None:
            self.test_mode = test_mode

    @property
    def current_period_end(self):
        """Gets the current_period_end of this Subscription.  # noqa: E501

        End of the current period that the subscription has been invoiced for.   # noqa: E501

        :return: The current_period_end of this Subscription.  # noqa: E501
        :rtype: datetime
        """
        return self._current_period_end

    @current_period_end.setter
    def current_period_end(self, current_period_end):
        """Sets the current_period_end of this Subscription.

        End of the current period that the subscription has been invoiced for.   # noqa: E501

        :param current_period_end: The current_period_end of this Subscription.  # noqa: E501
        :type: datetime
        """
        if current_period_end is None:
            raise ValueError(
                "Invalid value for `current_period_end`, must not be `None`"
            )  # noqa: E501

        self._current_period_end = current_period_end

    @property
    def end_date(self):
        """Gets the end_date of this Subscription.  # noqa: E501

        If the subscription has been canceled, this is the date when the subscription ends. If null, the subscription is active and has not been cancelled  # noqa: E501

        :return: The end_date of this Subscription.  # noqa: E501
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this Subscription.

        If the subscription has been canceled, this is the date when the subscription ends. If null, the subscription is active and has not been cancelled  # noqa: E501

        :param end_date: The end_date of this Subscription.  # noqa: E501
        :type: datetime
        """

        self._end_date = end_date

    @property
    def id(self):
        """Gets the id of this Subscription.  # noqa: E501

        The unique identifier of the subscription  # noqa: E501

        :return: The id of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Subscription.

        The unique identifier of the subscription  # noqa: E501

        :param id: The id of this Subscription.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def organisation_id(self):
        """Gets the organisation_id of this Subscription.  # noqa: E501

        The Xero generated unique identifier for the organisation  # noqa: E501

        :return: The organisation_id of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._organisation_id

    @organisation_id.setter
    def organisation_id(self, organisation_id):
        """Sets the organisation_id of this Subscription.

        The Xero generated unique identifier for the organisation  # noqa: E501

        :param organisation_id: The organisation_id of this Subscription.  # noqa: E501
        :type: str
        """
        if organisation_id is None:
            raise ValueError(
                "Invalid value for `organisation_id`, must not be `None`"
            )  # noqa: E501

        self._organisation_id = organisation_id

    @property
    def plans(self):
        """Gets the plans of this Subscription.  # noqa: E501

        List of plans for the subscription.  # noqa: E501

        :return: The plans of this Subscription.  # noqa: E501
        :rtype: list[Plan]
        """
        return self._plans

    @plans.setter
    def plans(self, plans):
        """Sets the plans of this Subscription.

        List of plans for the subscription.  # noqa: E501

        :param plans: The plans of this Subscription.  # noqa: E501
        :type: list[Plan]
        """
        if plans is None:
            raise ValueError(
                "Invalid value for `plans`, must not be `None`"
            )  # noqa: E501

        self._plans = plans

    @property
    def start_date(self):
        """Gets the start_date of this Subscription.  # noqa: E501

        Date when the subscription was first created.  # noqa: E501

        :return: The start_date of this Subscription.  # noqa: E501
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this Subscription.

        Date when the subscription was first created.  # noqa: E501

        :param start_date: The start_date of this Subscription.  # noqa: E501
        :type: datetime
        """
        if start_date is None:
            raise ValueError(
                "Invalid value for `start_date`, must not be `None`"
            )  # noqa: E501

        self._start_date = start_date

    @property
    def status(self):
        """Gets the status of this Subscription.  # noqa: E501

        Status of the subscription. Available statuses are ACTIVE, CANCELED, and PAST_DUE.  # noqa: E501

        :return: The status of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Subscription.

        Status of the subscription. Available statuses are ACTIVE, CANCELED, and PAST_DUE.  # noqa: E501

        :param status: The status of this Subscription.  # noqa: E501
        :type: str
        """
        if status is None:
            raise ValueError(
                "Invalid value for `status`, must not be `None`"
            )  # noqa: E501

        self._status = status

    @property
    def test_mode(self):
        """Gets the test_mode of this Subscription.  # noqa: E501

        Boolean used to indicate if the subscription is in test mode  # noqa: E501

        :return: The test_mode of this Subscription.  # noqa: E501
        :rtype: bool
        """
        return self._test_mode

    @test_mode.setter
    def test_mode(self, test_mode):
        """Sets the test_mode of this Subscription.

        Boolean used to indicate if the subscription is in test mode  # noqa: E501

        :param test_mode: The test_mode of this Subscription.  # noqa: E501
        :type: bool
        """

        self._test_mode = test_mode
