# Generated by Django 2.1.15 on 2020-03-26 14:56

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="OpeningHours",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "always_open",
                    models.BooleanField(
                        db_index=True, default=False, verbose_name="Open 24/7"
                    ),
                ),
            ],
            options={
                "verbose_name": "Opening hours",
                "verbose_name_plural": "Openings hours",
            },
        ),
        migrations.CreateModel(
            name="SpecificPeriodHours",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("from_date", models.DateField(verbose_name="From")),
                ("to_date", models.DateField(verbose_name="To")),
                ("closed", models.BooleanField(default=False, verbose_name="Closed")),
                (
                    "opening_hours",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="specific_period_hours",
                        to="opening_hours_management.OpeningHours",
                        verbose_name="Opening hours",
                    ),
                ),
            ],
            options={
                "verbose_name": "Specific period hours",
                "verbose_name_plural": "Specific periods hours",
            },
        ),
        migrations.CreateModel(
            name="SpecificPeriodTimeRange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "opening_time",
                    models.TimeField(
                        blank=True, null=True, verbose_name="Opening time"
                    ),
                ),
                (
                    "closing_time",
                    models.TimeField(
                        blank=True, null=True, verbose_name="Closing time"
                    ),
                ),
                (
                    "specific_period_hours",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="specific_period_time_ranges",
                        to="opening_hours_management.SpecificPeriodHours",
                        verbose_name="Specific period hours",
                    ),
                ),
            ],
            options={
                "verbose_name": "Specific period time range",
                "verbose_name_plural": "Specific periods times ranges",
            },
        ),
        migrations.CreateModel(
            name="WeekDayHours",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "week_day",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (1, "Monday"),
                            (2, "Tuesday"),
                            (3, "Wednesday"),
                            (4, "Thursday"),
                            (5, "Friday"),
                            (6, "Saturday"),
                            (7, "Sunday"),
                        ],
                        verbose_name="Week day",
                    ),
                ),
                ("closed", models.BooleanField(default=False, verbose_name="Closed")),
                (
                    "opening_hours",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="weekday_hours",
                        to="opening_hours_management.OpeningHours",
                        verbose_name="Opening hours",
                    ),
                ),
            ],
            options={
                "verbose_name": "Week day hours",
                "verbose_name_plural": "Week days hours",
                "ordering": ["week_day"],
            },
        ),
        migrations.CreateModel(
            name="WeekDayTimeRange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "opening_time",
                    models.TimeField(
                        blank=True, null=True, verbose_name="Opening time"
                    ),
                ),
                (
                    "closing_time",
                    models.TimeField(
                        blank=True, null=True, verbose_name="Closing time"
                    ),
                ),
                (
                    "week_day_hours",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="weekday_time_ranges",
                        to="opening_hours_management.WeekDayHours",
                        verbose_name="Week day hours",
                    ),
                ),
            ],
            options={
                "verbose_name": "Week day time range",
                "verbose_name_plural": "Week days time ranges",
            },
        ),
        migrations.AlterUniqueTogether(
            name="weekdayhours",
            unique_together={("opening_hours", "week_day")},
        ),
    ]
