# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AccessPolicyIamRoleArgs',
    'AccessPolicyIamUserArgs',
    'AccessPolicyIdentityArgs',
    'AccessPolicyPortalArgs',
    'AccessPolicyProjectArgs',
    'AccessPolicyResourceArgs',
    'AccessPolicyUserArgs',
    'AssetHierarchyArgs',
    'AssetModelAttributeArgs',
    'AssetModelCompositeModelArgs',
    'AssetModelExpressionVariableArgs',
    'AssetModelHierarchyArgs',
    'AssetModelMetricWindowArgs',
    'AssetModelMetricArgs',
    'AssetModelPropertyTypeArgs',
    'AssetModelPropertyArgs',
    'AssetModelTagArgs',
    'AssetModelTransformArgs',
    'AssetModelTumblingWindowArgs',
    'AssetModelVariableValueArgs',
    'AssetPropertyArgs',
    'AssetTagArgs',
    'DashboardTagArgs',
    'GatewayCapabilitySummaryArgs',
    'GatewayGreengrassArgs',
    'GatewayPlatformArgs',
    'GatewayTagArgs',
    'PortalTagArgs',
    'ProjectTagArgs',
]

@pulumi.input_type
class AccessPolicyIamRoleArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None):
        """
        Contains information for an IAM role identity in an access policy.
        :param pulumi.Input[str] arn: The ARN of the IAM role.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM role.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)


@pulumi.input_type
class AccessPolicyIamUserArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None):
        """
        Contains information for an IAM user identity in an access policy.
        :param pulumi.Input[str] arn: The ARN of the IAM user.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM user.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)


@pulumi.input_type
class AccessPolicyIdentityArgs:
    def __init__(__self__, *,
                 iam_role: Optional[pulumi.Input['AccessPolicyIamRoleArgs']] = None,
                 iam_user: Optional[pulumi.Input['AccessPolicyIamUserArgs']] = None,
                 user: Optional[pulumi.Input['AccessPolicyUserArgs']] = None):
        """
        The identity for this access policy. Choose either an SSO user or group or an IAM user or role.
        """
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if iam_user is not None:
            pulumi.set(__self__, "iam_user", iam_user)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[pulumi.Input['AccessPolicyIamRoleArgs']]:
        return pulumi.get(self, "iam_role")

    @iam_role.setter
    def iam_role(self, value: Optional[pulumi.Input['AccessPolicyIamRoleArgs']]):
        pulumi.set(self, "iam_role", value)

    @property
    @pulumi.getter(name="iamUser")
    def iam_user(self) -> Optional[pulumi.Input['AccessPolicyIamUserArgs']]:
        return pulumi.get(self, "iam_user")

    @iam_user.setter
    def iam_user(self, value: Optional[pulumi.Input['AccessPolicyIamUserArgs']]):
        pulumi.set(self, "iam_user", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input['AccessPolicyUserArgs']]:
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input['AccessPolicyUserArgs']]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class AccessPolicyPortalArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        A portal resource.
        :param pulumi.Input[str] id: The ID of the portal.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the portal.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class AccessPolicyProjectArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        A project resource.
        :param pulumi.Input[str] id: The ID of the project.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class AccessPolicyResourceArgs:
    def __init__(__self__, *,
                 portal: Optional[pulumi.Input['AccessPolicyPortalArgs']] = None,
                 project: Optional[pulumi.Input['AccessPolicyProjectArgs']] = None):
        """
        The AWS IoT SiteWise Monitor resource for this access policy. Choose either portal or project but not both.
        """
        if portal is not None:
            pulumi.set(__self__, "portal", portal)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def portal(self) -> Optional[pulumi.Input['AccessPolicyPortalArgs']]:
        return pulumi.get(self, "portal")

    @portal.setter
    def portal(self, value: Optional[pulumi.Input['AccessPolicyPortalArgs']]):
        pulumi.set(self, "portal", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input['AccessPolicyProjectArgs']]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input['AccessPolicyProjectArgs']]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class AccessPolicyUserArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Contains information for a user identity in an access policy.
        :param pulumi.Input[str] id: The AWS SSO ID of the user.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS SSO ID of the user.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class AssetHierarchyArgs:
    def __init__(__self__, *,
                 child_asset_id: pulumi.Input[str],
                 logical_id: pulumi.Input[str]):
        """
        A hierarchy specifies allowed parent/child asset relationships.
        :param pulumi.Input[str] child_asset_id: The ID of the child asset to be associated.
        :param pulumi.Input[str] logical_id: The LogicalID of a hierarchy in the parent asset's model.
        """
        pulumi.set(__self__, "child_asset_id", child_asset_id)
        pulumi.set(__self__, "logical_id", logical_id)

    @property
    @pulumi.getter(name="childAssetId")
    def child_asset_id(self) -> pulumi.Input[str]:
        """
        The ID of the child asset to be associated.
        """
        return pulumi.get(self, "child_asset_id")

    @child_asset_id.setter
    def child_asset_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "child_asset_id", value)

    @property
    @pulumi.getter(name="logicalId")
    def logical_id(self) -> pulumi.Input[str]:
        """
        The LogicalID of a hierarchy in the parent asset's model.
        """
        return pulumi.get(self, "logical_id")

    @logical_id.setter
    def logical_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "logical_id", value)


@pulumi.input_type
class AssetModelAttributeArgs:
    def __init__(__self__, *,
                 default_value: Optional[pulumi.Input[str]] = None):
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)


@pulumi.input_type
class AssetModelCompositeModelArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 composite_model_properties: Optional[pulumi.Input[Sequence[pulumi.Input['AssetModelPropertyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        Contains a composite model definition in an asset model. This composite model definition is applied to all assets created from the asset model.
        :param pulumi.Input[str] name: A unique, friendly name for the asset composite model.
        :param pulumi.Input[str] type: The type of the composite model. For alarm composite models, this type is AWS/ALARM
        :param pulumi.Input[Sequence[pulumi.Input['AssetModelPropertyArgs']]] composite_model_properties: The property definitions of the asset model. You can specify up to 200 properties per asset model.
        :param pulumi.Input[str] description: A description for the asset composite model.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if composite_model_properties is not None:
            pulumi.set(__self__, "composite_model_properties", composite_model_properties)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique, friendly name for the asset composite model.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the composite model. For alarm composite models, this type is AWS/ALARM
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="compositeModelProperties")
    def composite_model_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssetModelPropertyArgs']]]]:
        """
        The property definitions of the asset model. You can specify up to 200 properties per asset model.
        """
        return pulumi.get(self, "composite_model_properties")

    @composite_model_properties.setter
    def composite_model_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssetModelPropertyArgs']]]]):
        pulumi.set(self, "composite_model_properties", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the asset composite model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class AssetModelExpressionVariableArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input['AssetModelVariableValueArgs']):
        """
        :param pulumi.Input[str] name: The friendly name of the variable to be used in the expression.
        :param pulumi.Input['AssetModelVariableValueArgs'] value: The variable that identifies an asset property from which to use values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The friendly name of the variable to be used in the expression.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input['AssetModelVariableValueArgs']:
        """
        The variable that identifies an asset property from which to use values.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input['AssetModelVariableValueArgs']):
        pulumi.set(self, "value", value)


@pulumi.input_type
class AssetModelHierarchyArgs:
    def __init__(__self__, *,
                 child_asset_model_id: pulumi.Input[str],
                 logical_id: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        Contains information about an asset model hierarchy.
        :param pulumi.Input[str] child_asset_model_id: The ID of the asset model. All assets in this hierarchy must be instances of the child AssetModelId asset model.
        :param pulumi.Input[str] logical_id: Customer provided ID for hierarchy.
        :param pulumi.Input[str] name: The name of the asset model hierarchy.
        """
        pulumi.set(__self__, "child_asset_model_id", child_asset_model_id)
        pulumi.set(__self__, "logical_id", logical_id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="childAssetModelId")
    def child_asset_model_id(self) -> pulumi.Input[str]:
        """
        The ID of the asset model. All assets in this hierarchy must be instances of the child AssetModelId asset model.
        """
        return pulumi.get(self, "child_asset_model_id")

    @child_asset_model_id.setter
    def child_asset_model_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "child_asset_model_id", value)

    @property
    @pulumi.getter(name="logicalId")
    def logical_id(self) -> pulumi.Input[str]:
        """
        Customer provided ID for hierarchy.
        """
        return pulumi.get(self, "logical_id")

    @logical_id.setter
    def logical_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "logical_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the asset model hierarchy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AssetModelMetricWindowArgs:
    def __init__(__self__, *,
                 tumbling: Optional[pulumi.Input['AssetModelTumblingWindowArgs']] = None):
        """
        Contains a time interval window used for data aggregate computations (for example, average, sum, count, and so on).
        """
        if tumbling is not None:
            pulumi.set(__self__, "tumbling", tumbling)

    @property
    @pulumi.getter
    def tumbling(self) -> Optional[pulumi.Input['AssetModelTumblingWindowArgs']]:
        return pulumi.get(self, "tumbling")

    @tumbling.setter
    def tumbling(self, value: Optional[pulumi.Input['AssetModelTumblingWindowArgs']]):
        pulumi.set(self, "tumbling", value)


@pulumi.input_type
class AssetModelMetricArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 variables: pulumi.Input[Sequence[pulumi.Input['AssetModelExpressionVariableArgs']]],
                 window: pulumi.Input['AssetModelMetricWindowArgs']):
        """
        :param pulumi.Input[str] expression: The mathematical expression that defines the metric aggregation function. You can specify up to 10 functions per expression.
        :param pulumi.Input[Sequence[pulumi.Input['AssetModelExpressionVariableArgs']]] variables: The list of variables used in the expression.
        :param pulumi.Input['AssetModelMetricWindowArgs'] window: The window (time interval) over which AWS IoT SiteWise computes the metric's aggregation expression
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "variables", variables)
        pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        The mathematical expression that defines the metric aggregation function. You can specify up to 10 functions per expression.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def variables(self) -> pulumi.Input[Sequence[pulumi.Input['AssetModelExpressionVariableArgs']]]:
        """
        The list of variables used in the expression.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: pulumi.Input[Sequence[pulumi.Input['AssetModelExpressionVariableArgs']]]):
        pulumi.set(self, "variables", value)

    @property
    @pulumi.getter
    def window(self) -> pulumi.Input['AssetModelMetricWindowArgs']:
        """
        The window (time interval) over which AWS IoT SiteWise computes the metric's aggregation expression
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: pulumi.Input['AssetModelMetricWindowArgs']):
        pulumi.set(self, "window", value)


@pulumi.input_type
class AssetModelPropertyTypeArgs:
    def __init__(__self__, *,
                 type_name: pulumi.Input['AssetModelTypeName'],
                 attribute: Optional[pulumi.Input['AssetModelAttributeArgs']] = None,
                 metric: Optional[pulumi.Input['AssetModelMetricArgs']] = None,
                 transform: Optional[pulumi.Input['AssetModelTransformArgs']] = None):
        """
        Contains a property type, which can be one of attribute, measurement, metric, or transform.
        """
        pulumi.set(__self__, "type_name", type_name)
        if attribute is not None:
            pulumi.set(__self__, "attribute", attribute)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if transform is not None:
            pulumi.set(__self__, "transform", transform)

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> pulumi.Input['AssetModelTypeName']:
        return pulumi.get(self, "type_name")

    @type_name.setter
    def type_name(self, value: pulumi.Input['AssetModelTypeName']):
        pulumi.set(self, "type_name", value)

    @property
    @pulumi.getter
    def attribute(self) -> Optional[pulumi.Input['AssetModelAttributeArgs']]:
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: Optional[pulumi.Input['AssetModelAttributeArgs']]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input['AssetModelMetricArgs']]:
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input['AssetModelMetricArgs']]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def transform(self) -> Optional[pulumi.Input['AssetModelTransformArgs']]:
        return pulumi.get(self, "transform")

    @transform.setter
    def transform(self, value: Optional[pulumi.Input['AssetModelTransformArgs']]):
        pulumi.set(self, "transform", value)


@pulumi.input_type
class AssetModelPropertyArgs:
    def __init__(__self__, *,
                 data_type: pulumi.Input['AssetModelDataType'],
                 logical_id: pulumi.Input[str],
                 name: pulumi.Input[str],
                 type: pulumi.Input['AssetModelPropertyTypeArgs'],
                 data_type_spec: Optional[pulumi.Input['AssetModelDataTypeSpec']] = None,
                 unit: Optional[pulumi.Input[str]] = None):
        """
        Contains information about an asset model property.
        :param pulumi.Input['AssetModelDataType'] data_type: The data type of the asset model property.
        :param pulumi.Input[str] logical_id: Customer provided ID for property.
        :param pulumi.Input[str] name: The name of the asset model property.
        :param pulumi.Input['AssetModelPropertyTypeArgs'] type: The property type
        :param pulumi.Input['AssetModelDataTypeSpec'] data_type_spec: The data type of the structure for this property.
        :param pulumi.Input[str] unit: The unit of the asset model property, such as Newtons or RPM.
        """
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "logical_id", logical_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if data_type_spec is not None:
            pulumi.set(__self__, "data_type_spec", data_type_spec)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Input['AssetModelDataType']:
        """
        The data type of the asset model property.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: pulumi.Input['AssetModelDataType']):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="logicalId")
    def logical_id(self) -> pulumi.Input[str]:
        """
        Customer provided ID for property.
        """
        return pulumi.get(self, "logical_id")

    @logical_id.setter
    def logical_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "logical_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the asset model property.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['AssetModelPropertyTypeArgs']:
        """
        The property type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['AssetModelPropertyTypeArgs']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dataTypeSpec")
    def data_type_spec(self) -> Optional[pulumi.Input['AssetModelDataTypeSpec']]:
        """
        The data type of the structure for this property.
        """
        return pulumi.get(self, "data_type_spec")

    @data_type_spec.setter
    def data_type_spec(self, value: Optional[pulumi.Input['AssetModelDataTypeSpec']]):
        pulumi.set(self, "data_type_spec", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of the asset model property, such as Newtons or RPM.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)


@pulumi.input_type
class AssetModelTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class AssetModelTransformArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 variables: pulumi.Input[Sequence[pulumi.Input['AssetModelExpressionVariableArgs']]]):
        """
        :param pulumi.Input[str] expression: The mathematical expression that defines the transformation function. You can specify up to 10 functions per expression.
        :param pulumi.Input[Sequence[pulumi.Input['AssetModelExpressionVariableArgs']]] variables: The list of variables used in the expression.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        The mathematical expression that defines the transformation function. You can specify up to 10 functions per expression.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def variables(self) -> pulumi.Input[Sequence[pulumi.Input['AssetModelExpressionVariableArgs']]]:
        """
        The list of variables used in the expression.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: pulumi.Input[Sequence[pulumi.Input['AssetModelExpressionVariableArgs']]]):
        pulumi.set(self, "variables", value)


@pulumi.input_type
class AssetModelTumblingWindowArgs:
    def __init__(__self__, *,
                 interval: pulumi.Input[str],
                 offset: Optional[pulumi.Input[str]] = None):
        """
        Contains a tumbling window, which is a repeating fixed-sized, non-overlapping, and contiguous time interval. This window is used in metric and aggregation computations.
        """
        pulumi.set(__self__, "interval", interval)
        if offset is not None:
            pulumi.set(__self__, "offset", offset)

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Input[str]:
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[str]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def offset(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "offset")

    @offset.setter
    def offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offset", value)


@pulumi.input_type
class AssetModelVariableValueArgs:
    def __init__(__self__, *,
                 property_logical_id: pulumi.Input[str],
                 hierarchy_logical_id: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "property_logical_id", property_logical_id)
        if hierarchy_logical_id is not None:
            pulumi.set(__self__, "hierarchy_logical_id", hierarchy_logical_id)

    @property
    @pulumi.getter(name="propertyLogicalId")
    def property_logical_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "property_logical_id")

    @property_logical_id.setter
    def property_logical_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "property_logical_id", value)

    @property
    @pulumi.getter(name="hierarchyLogicalId")
    def hierarchy_logical_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "hierarchy_logical_id")

    @hierarchy_logical_id.setter
    def hierarchy_logical_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hierarchy_logical_id", value)


@pulumi.input_type
class AssetPropertyArgs:
    def __init__(__self__, *,
                 logical_id: pulumi.Input[str],
                 alias: Optional[pulumi.Input[str]] = None,
                 notification_state: Optional[pulumi.Input['AssetPropertyNotificationState']] = None):
        """
        The asset property's definition, alias, and notification state.
        :param pulumi.Input[str] logical_id: Customer provided ID for property.
        :param pulumi.Input[str] alias: The property alias that identifies the property.
        :param pulumi.Input['AssetPropertyNotificationState'] notification_state: The MQTT notification state (ENABLED or DISABLED) for this asset property.
        """
        pulumi.set(__self__, "logical_id", logical_id)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if notification_state is not None:
            pulumi.set(__self__, "notification_state", notification_state)

    @property
    @pulumi.getter(name="logicalId")
    def logical_id(self) -> pulumi.Input[str]:
        """
        Customer provided ID for property.
        """
        return pulumi.get(self, "logical_id")

    @logical_id.setter
    def logical_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "logical_id", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        The property alias that identifies the property.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="notificationState")
    def notification_state(self) -> Optional[pulumi.Input['AssetPropertyNotificationState']]:
        """
        The MQTT notification state (ENABLED or DISABLED) for this asset property.
        """
        return pulumi.get(self, "notification_state")

    @notification_state.setter
    def notification_state(self, value: Optional[pulumi.Input['AssetPropertyNotificationState']]):
        pulumi.set(self, "notification_state", value)


@pulumi.input_type
class AssetTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DashboardTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        To add or update tag, provide both key and value. To delete tag, provide only tag key to be deleted
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GatewayCapabilitySummaryArgs:
    def __init__(__self__, *,
                 capability_namespace: pulumi.Input[str],
                 capability_configuration: Optional[pulumi.Input[str]] = None):
        """
        Contains a summary of a gateway capability configuration.
        """
        pulumi.set(__self__, "capability_namespace", capability_namespace)
        if capability_configuration is not None:
            pulumi.set(__self__, "capability_configuration", capability_configuration)

    @property
    @pulumi.getter(name="capabilityNamespace")
    def capability_namespace(self) -> pulumi.Input[str]:
        return pulumi.get(self, "capability_namespace")

    @capability_namespace.setter
    def capability_namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "capability_namespace", value)

    @property
    @pulumi.getter(name="capabilityConfiguration")
    def capability_configuration(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "capability_configuration")

    @capability_configuration.setter
    def capability_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capability_configuration", value)


@pulumi.input_type
class GatewayGreengrassArgs:
    def __init__(__self__, *,
                 group_arn: pulumi.Input[str]):
        """
        Contains the ARN of AWS IoT Greengrass Group that the gateway runs on.
        :param pulumi.Input[str] group_arn: The ARN of the Greengrass group.
        """
        pulumi.set(__self__, "group_arn", group_arn)

    @property
    @pulumi.getter(name="groupArn")
    def group_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the Greengrass group.
        """
        return pulumi.get(self, "group_arn")

    @group_arn.setter
    def group_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_arn", value)


@pulumi.input_type
class GatewayPlatformArgs:
    def __init__(__self__, *,
                 greengrass: pulumi.Input['GatewayGreengrassArgs']):
        """
        Contains a gateway's platform information.
        :param pulumi.Input['GatewayGreengrassArgs'] greengrass: A gateway that runs on AWS IoT Greengrass.
        """
        pulumi.set(__self__, "greengrass", greengrass)

    @property
    @pulumi.getter
    def greengrass(self) -> pulumi.Input['GatewayGreengrassArgs']:
        """
        A gateway that runs on AWS IoT Greengrass.
        """
        return pulumi.get(self, "greengrass")

    @greengrass.setter
    def greengrass(self, value: pulumi.Input['GatewayGreengrassArgs']):
        pulumi.set(self, "greengrass", value)


@pulumi.input_type
class GatewayTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        To add or update tag, provide both key and value. To delete tag, provide only tag key to be deleted
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class PortalTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        To add or update tag, provide both key and value. To delete tag, provide only tag key to be deleted.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ProjectTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        To add or update tag, provide both key and value. To delete tag, provide only tag key to be deleted
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


