# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ContainerRecipeComponentConfiguration',
    'ContainerRecipeEbsInstanceBlockDeviceSpecification',
    'ContainerRecipeInstanceBlockDeviceMapping',
    'ContainerRecipeInstanceConfiguration',
    'ContainerRecipeTargetContainerRepository',
    'DistributionConfigurationDistribution',
    'DistributionConfigurationLaunchTemplateConfiguration',
    'ImagePipelineImageTestsConfiguration',
    'ImagePipelineSchedule',
    'ImageRecipeAdditionalInstanceConfiguration',
    'ImageRecipeComponentConfiguration',
    'ImageRecipeComponentParameter',
    'ImageRecipeEbsInstanceBlockDeviceSpecification',
    'ImageRecipeInstanceBlockDeviceMapping',
    'ImageRecipeSystemsManagerAgent',
    'ImageTestsConfiguration',
    'InfrastructureConfigurationLogging',
    'InfrastructureConfigurationS3Logs',
]

@pulumi.output_type
class ContainerRecipeComponentConfiguration(dict):
    """
    Configuration details of the component.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentArn":
            suggest = "component_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRecipeComponentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRecipeComponentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRecipeComponentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_arn: Optional[str] = None):
        """
        Configuration details of the component.
        :param str component_arn: The Amazon Resource Name (ARN) of the component.
        """
        if component_arn is not None:
            pulumi.set(__self__, "component_arn", component_arn)

    @property
    @pulumi.getter(name="componentArn")
    def component_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the component.
        """
        return pulumi.get(self, "component_arn")


@pulumi.output_type
class ContainerRecipeEbsInstanceBlockDeviceSpecification(dict):
    """
    Amazon EBS-specific block device mapping specifications. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRecipeEbsInstanceBlockDeviceSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRecipeEbsInstanceBlockDeviceSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRecipeEbsInstanceBlockDeviceSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[bool] = None,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 kms_key_id: Optional[str] = None,
                 snapshot_id: Optional[str] = None,
                 volume_size: Optional[int] = None,
                 volume_type: Optional['ContainerRecipeEbsInstanceBlockDeviceSpecificationVolumeType'] = None):
        """
        Amazon EBS-specific block device mapping specifications. 
        :param bool delete_on_termination: Use to configure delete on termination of the associated device.
        :param bool encrypted: Use to configure device encryption.
        :param int iops: Use to configure device IOPS.
        :param str kms_key_id: Use to configure the KMS key to use when encrypting the device.
        :param str snapshot_id: The snapshot that defines the device contents.
        :param int volume_size: Use to override the device's volume size.
        :param 'ContainerRecipeEbsInstanceBlockDeviceSpecificationVolumeType' volume_type: Use to override the device's volume type.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        """
        Use to configure delete on termination of the associated device.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Use to configure device encryption.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        Use to configure device IOPS.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        Use to configure the KMS key to use when encrypting the device.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        The snapshot that defines the device contents.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        """
        Use to override the device's volume size.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional['ContainerRecipeEbsInstanceBlockDeviceSpecificationVolumeType']:
        """
        Use to override the device's volume type.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ContainerRecipeInstanceBlockDeviceMapping(dict):
    """
    Defines block device mappings for the instance used to configure your image. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "noDevice":
            suggest = "no_device"
        elif key == "virtualName":
            suggest = "virtual_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRecipeInstanceBlockDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRecipeInstanceBlockDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRecipeInstanceBlockDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: Optional[str] = None,
                 ebs: Optional['outputs.ContainerRecipeEbsInstanceBlockDeviceSpecification'] = None,
                 no_device: Optional[str] = None,
                 virtual_name: Optional[str] = None):
        """
        Defines block device mappings for the instance used to configure your image. 
        :param str device_name: The device to which these mappings apply.
        :param 'ContainerRecipeEbsInstanceBlockDeviceSpecification' ebs: Use to manage Amazon EBS-specific configuration for this mapping.
        :param str no_device: Use to remove a mapping from the parent image.
        :param str virtual_name: Use to manage instance ephemeral devices.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[str]:
        """
        The device to which these mappings apply.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def ebs(self) -> Optional['outputs.ContainerRecipeEbsInstanceBlockDeviceSpecification']:
        """
        Use to manage Amazon EBS-specific configuration for this mapping.
        """
        return pulumi.get(self, "ebs")

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[str]:
        """
        Use to remove a mapping from the parent image.
        """
        return pulumi.get(self, "no_device")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[str]:
        """
        Use to manage instance ephemeral devices.
        """
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class ContainerRecipeInstanceConfiguration(dict):
    """
    A group of options that can be used to configure an instance for building and testing container images.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockDeviceMappings":
            suggest = "block_device_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRecipeInstanceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRecipeInstanceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRecipeInstanceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_device_mappings: Optional[Sequence['outputs.ContainerRecipeInstanceBlockDeviceMapping']] = None,
                 image: Optional[str] = None):
        """
        A group of options that can be used to configure an instance for building and testing container images.
        :param Sequence['ContainerRecipeInstanceBlockDeviceMapping'] block_device_mappings: Defines the block devices to attach for building an instance from this Image Builder AMI.
        :param str image: The AMI ID to use as the base image for a container build and test instance. If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
        """
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[Sequence['outputs.ContainerRecipeInstanceBlockDeviceMapping']]:
        """
        Defines the block devices to attach for building an instance from this Image Builder AMI.
        """
        return pulumi.get(self, "block_device_mappings")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        The AMI ID to use as the base image for a container build and test instance. If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class ContainerRecipeTargetContainerRepository(dict):
    """
    The container repository where the output container image is stored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryName":
            suggest = "repository_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRecipeTargetContainerRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRecipeTargetContainerRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRecipeTargetContainerRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_name: Optional[str] = None,
                 service: Optional['ContainerRecipeTargetContainerRepositoryService'] = None):
        """
        The container repository where the output container image is stored.
        :param str repository_name: The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
        :param 'ContainerRecipeTargetContainerRepositoryService' service: Specifies the service in which this image was registered.
        """
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[str]:
        """
        The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter
    def service(self) -> Optional['ContainerRecipeTargetContainerRepositoryService']:
        """
        Specifies the service in which this image was registered.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class DistributionConfigurationDistribution(dict):
    """
    The distributions of the distribution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amiDistributionConfiguration":
            suggest = "ami_distribution_configuration"
        elif key == "containerDistributionConfiguration":
            suggest = "container_distribution_configuration"
        elif key == "launchTemplateConfigurations":
            suggest = "launch_template_configurations"
        elif key == "licenseConfigurationArns":
            suggest = "license_configuration_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationDistribution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationDistribution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationDistribution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: str,
                 ami_distribution_configuration: Optional[Any] = None,
                 container_distribution_configuration: Optional[Any] = None,
                 launch_template_configurations: Optional[Sequence['outputs.DistributionConfigurationLaunchTemplateConfiguration']] = None,
                 license_configuration_arns: Optional[Sequence[str]] = None):
        """
        The distributions of the distribution configuration.
        :param str region: region
        :param Any ami_distribution_configuration: The specific AMI settings (for example, launch permissions, AMI tags).
        :param Any container_distribution_configuration: Container distribution settings for encryption, licensing, and sharing in a specific Region.
        :param Sequence['DistributionConfigurationLaunchTemplateConfiguration'] launch_template_configurations: A group of launchTemplateConfiguration settings that apply to image distribution.
        :param Sequence[str] license_configuration_arns: The License Manager Configuration to associate with the AMI in the specified Region.
        """
        pulumi.set(__self__, "region", region)
        if ami_distribution_configuration is not None:
            pulumi.set(__self__, "ami_distribution_configuration", ami_distribution_configuration)
        if container_distribution_configuration is not None:
            pulumi.set(__self__, "container_distribution_configuration", container_distribution_configuration)
        if launch_template_configurations is not None:
            pulumi.set(__self__, "launch_template_configurations", launch_template_configurations)
        if license_configuration_arns is not None:
            pulumi.set(__self__, "license_configuration_arns", license_configuration_arns)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        region
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="amiDistributionConfiguration")
    def ami_distribution_configuration(self) -> Optional[Any]:
        """
        The specific AMI settings (for example, launch permissions, AMI tags).
        """
        return pulumi.get(self, "ami_distribution_configuration")

    @property
    @pulumi.getter(name="containerDistributionConfiguration")
    def container_distribution_configuration(self) -> Optional[Any]:
        """
        Container distribution settings for encryption, licensing, and sharing in a specific Region.
        """
        return pulumi.get(self, "container_distribution_configuration")

    @property
    @pulumi.getter(name="launchTemplateConfigurations")
    def launch_template_configurations(self) -> Optional[Sequence['outputs.DistributionConfigurationLaunchTemplateConfiguration']]:
        """
        A group of launchTemplateConfiguration settings that apply to image distribution.
        """
        return pulumi.get(self, "launch_template_configurations")

    @property
    @pulumi.getter(name="licenseConfigurationArns")
    def license_configuration_arns(self) -> Optional[Sequence[str]]:
        """
        The License Manager Configuration to associate with the AMI in the specified Region.
        """
        return pulumi.get(self, "license_configuration_arns")


@pulumi.output_type
class DistributionConfigurationLaunchTemplateConfiguration(dict):
    """
    launchTemplateConfiguration settings that apply to image distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "launchTemplateId":
            suggest = "launch_template_id"
        elif key == "setDefaultVersion":
            suggest = "set_default_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationLaunchTemplateConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationLaunchTemplateConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationLaunchTemplateConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: Optional[str] = None,
                 launch_template_id: Optional[str] = None,
                 set_default_version: Optional[bool] = None):
        """
        launchTemplateConfiguration settings that apply to image distribution.
        :param str account_id: The account ID that this configuration applies to.
        :param str launch_template_id: Identifies the EC2 launch template to use.
        :param bool set_default_version: Set the specified EC2 launch template as the default launch template for the specified account.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if set_default_version is not None:
            pulumi.set(__self__, "set_default_version", set_default_version)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        The account ID that this configuration applies to.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[str]:
        """
        Identifies the EC2 launch template to use.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="setDefaultVersion")
    def set_default_version(self) -> Optional[bool]:
        """
        Set the specified EC2 launch template as the default launch template for the specified account.
        """
        return pulumi.get(self, "set_default_version")


@pulumi.output_type
class ImagePipelineImageTestsConfiguration(dict):
    """
    Image tests configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageTestsEnabled":
            suggest = "image_tests_enabled"
        elif key == "timeoutMinutes":
            suggest = "timeout_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImagePipelineImageTestsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImagePipelineImageTestsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImagePipelineImageTestsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_tests_enabled: Optional[bool] = None,
                 timeout_minutes: Optional[int] = None):
        """
        Image tests configuration.
        :param bool image_tests_enabled: Defines if tests should be executed when building this image.
        :param int timeout_minutes: The maximum time in minutes that tests are permitted to run.
        """
        if image_tests_enabled is not None:
            pulumi.set(__self__, "image_tests_enabled", image_tests_enabled)
        if timeout_minutes is not None:
            pulumi.set(__self__, "timeout_minutes", timeout_minutes)

    @property
    @pulumi.getter(name="imageTestsEnabled")
    def image_tests_enabled(self) -> Optional[bool]:
        """
        Defines if tests should be executed when building this image.
        """
        return pulumi.get(self, "image_tests_enabled")

    @property
    @pulumi.getter(name="timeoutMinutes")
    def timeout_minutes(self) -> Optional[int]:
        """
        The maximum time in minutes that tests are permitted to run.
        """
        return pulumi.get(self, "timeout_minutes")


@pulumi.output_type
class ImagePipelineSchedule(dict):
    """
    The schedule of the image pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineExecutionStartCondition":
            suggest = "pipeline_execution_start_condition"
        elif key == "scheduleExpression":
            suggest = "schedule_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImagePipelineSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImagePipelineSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImagePipelineSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_execution_start_condition: Optional['ImagePipelineSchedulePipelineExecutionStartCondition'] = None,
                 schedule_expression: Optional[str] = None):
        """
        The schedule of the image pipeline.
        :param 'ImagePipelineSchedulePipelineExecutionStartCondition' pipeline_execution_start_condition: The condition configures when the pipeline should trigger a new image build.
        :param str schedule_expression: The expression determines how often EC2 Image Builder evaluates your pipelineExecutionStartCondition.
        """
        if pipeline_execution_start_condition is not None:
            pulumi.set(__self__, "pipeline_execution_start_condition", pipeline_execution_start_condition)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="pipelineExecutionStartCondition")
    def pipeline_execution_start_condition(self) -> Optional['ImagePipelineSchedulePipelineExecutionStartCondition']:
        """
        The condition configures when the pipeline should trigger a new image build.
        """
        return pulumi.get(self, "pipeline_execution_start_condition")

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[str]:
        """
        The expression determines how often EC2 Image Builder evaluates your pipelineExecutionStartCondition.
        """
        return pulumi.get(self, "schedule_expression")


@pulumi.output_type
class ImageRecipeAdditionalInstanceConfiguration(dict):
    """
    Specify additional settings and launch scripts for your build instances.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemsManagerAgent":
            suggest = "systems_manager_agent"
        elif key == "userDataOverride":
            suggest = "user_data_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRecipeAdditionalInstanceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRecipeAdditionalInstanceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRecipeAdditionalInstanceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 systems_manager_agent: Optional['outputs.ImageRecipeSystemsManagerAgent'] = None,
                 user_data_override: Optional[str] = None):
        """
        Specify additional settings and launch scripts for your build instances.
        :param 'ImageRecipeSystemsManagerAgent' systems_manager_agent: Contains settings for the SSM agent on your build instance.
        :param str user_data_override: Use this property to provide commands or a command script to run when you launch your build instance.
        """
        if systems_manager_agent is not None:
            pulumi.set(__self__, "systems_manager_agent", systems_manager_agent)
        if user_data_override is not None:
            pulumi.set(__self__, "user_data_override", user_data_override)

    @property
    @pulumi.getter(name="systemsManagerAgent")
    def systems_manager_agent(self) -> Optional['outputs.ImageRecipeSystemsManagerAgent']:
        """
        Contains settings for the SSM agent on your build instance.
        """
        return pulumi.get(self, "systems_manager_agent")

    @property
    @pulumi.getter(name="userDataOverride")
    def user_data_override(self) -> Optional[str]:
        """
        Use this property to provide commands or a command script to run when you launch your build instance.
        """
        return pulumi.get(self, "user_data_override")


@pulumi.output_type
class ImageRecipeComponentConfiguration(dict):
    """
    Configuration details of the component.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentArn":
            suggest = "component_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRecipeComponentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRecipeComponentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRecipeComponentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_arn: Optional[str] = None,
                 parameters: Optional[Sequence['outputs.ImageRecipeComponentParameter']] = None):
        """
        Configuration details of the component.
        :param str component_arn: The Amazon Resource Name (ARN) of the component.
        :param Sequence['ImageRecipeComponentParameter'] parameters: A group of parameter settings that are used to configure the component for a specific recipe.
        """
        if component_arn is not None:
            pulumi.set(__self__, "component_arn", component_arn)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="componentArn")
    def component_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the component.
        """
        return pulumi.get(self, "component_arn")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ImageRecipeComponentParameter']]:
        """
        A group of parameter settings that are used to configure the component for a specific recipe.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class ImageRecipeComponentParameter(dict):
    """
    Contains a key/value pair that sets the named component parameter.
    """
    def __init__(__self__, *,
                 name: str,
                 value: Sequence[str]):
        """
        Contains a key/value pair that sets the named component parameter.
        :param str name: The name of the component parameter to set.
        :param Sequence[str] value: Sets the value for the named component parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component parameter to set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Sequence[str]:
        """
        Sets the value for the named component parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ImageRecipeEbsInstanceBlockDeviceSpecification(dict):
    """
    Amazon EBS-specific block device mapping specifications. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRecipeEbsInstanceBlockDeviceSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRecipeEbsInstanceBlockDeviceSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRecipeEbsInstanceBlockDeviceSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[bool] = None,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 kms_key_id: Optional[str] = None,
                 snapshot_id: Optional[str] = None,
                 volume_size: Optional[int] = None,
                 volume_type: Optional['ImageRecipeEbsInstanceBlockDeviceSpecificationVolumeType'] = None):
        """
        Amazon EBS-specific block device mapping specifications. 
        :param bool delete_on_termination: Use to configure delete on termination of the associated device.
        :param bool encrypted: Use to configure device encryption.
        :param int iops: Use to configure device IOPS.
        :param str kms_key_id: Use to configure the KMS key to use when encrypting the device.
        :param str snapshot_id: The snapshot that defines the device contents.
        :param int volume_size: Use to override the device's volume size.
        :param 'ImageRecipeEbsInstanceBlockDeviceSpecificationVolumeType' volume_type: Use to override the device's volume type.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        """
        Use to configure delete on termination of the associated device.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Use to configure device encryption.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        Use to configure device IOPS.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        Use to configure the KMS key to use when encrypting the device.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        The snapshot that defines the device contents.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        """
        Use to override the device's volume size.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional['ImageRecipeEbsInstanceBlockDeviceSpecificationVolumeType']:
        """
        Use to override the device's volume type.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ImageRecipeInstanceBlockDeviceMapping(dict):
    """
    Defines block device mappings for the instance used to configure your image. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "noDevice":
            suggest = "no_device"
        elif key == "virtualName":
            suggest = "virtual_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRecipeInstanceBlockDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRecipeInstanceBlockDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRecipeInstanceBlockDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: Optional[str] = None,
                 ebs: Optional['outputs.ImageRecipeEbsInstanceBlockDeviceSpecification'] = None,
                 no_device: Optional[str] = None,
                 virtual_name: Optional[str] = None):
        """
        Defines block device mappings for the instance used to configure your image. 
        :param str device_name: The device to which these mappings apply.
        :param 'ImageRecipeEbsInstanceBlockDeviceSpecification' ebs: Use to manage Amazon EBS-specific configuration for this mapping.
        :param str no_device: Use to remove a mapping from the parent image.
        :param str virtual_name: Use to manage instance ephemeral devices.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[str]:
        """
        The device to which these mappings apply.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def ebs(self) -> Optional['outputs.ImageRecipeEbsInstanceBlockDeviceSpecification']:
        """
        Use to manage Amazon EBS-specific configuration for this mapping.
        """
        return pulumi.get(self, "ebs")

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[str]:
        """
        Use to remove a mapping from the parent image.
        """
        return pulumi.get(self, "no_device")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[str]:
        """
        Use to manage instance ephemeral devices.
        """
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class ImageRecipeSystemsManagerAgent(dict):
    """
    Contains settings for the SSM agent on your build instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "uninstallAfterBuild":
            suggest = "uninstall_after_build"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRecipeSystemsManagerAgent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRecipeSystemsManagerAgent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRecipeSystemsManagerAgent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uninstall_after_build: Optional[bool] = None):
        """
        Contains settings for the SSM agent on your build instance.
        :param bool uninstall_after_build: Controls whether the SSM agent is removed from your final build image, prior to creating the new AMI. If this is set to true, then the agent is removed from the final image. If it's set to false, then the agent is left in, so that it is included in the new AMI. The default value is false.
        """
        if uninstall_after_build is not None:
            pulumi.set(__self__, "uninstall_after_build", uninstall_after_build)

    @property
    @pulumi.getter(name="uninstallAfterBuild")
    def uninstall_after_build(self) -> Optional[bool]:
        """
        Controls whether the SSM agent is removed from your final build image, prior to creating the new AMI. If this is set to true, then the agent is removed from the final image. If it's set to false, then the agent is left in, so that it is included in the new AMI. The default value is false.
        """
        return pulumi.get(self, "uninstall_after_build")


@pulumi.output_type
class ImageTestsConfiguration(dict):
    """
    The image tests configuration used when creating this image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageTestsEnabled":
            suggest = "image_tests_enabled"
        elif key == "timeoutMinutes":
            suggest = "timeout_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageTestsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageTestsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageTestsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_tests_enabled: Optional[bool] = None,
                 timeout_minutes: Optional[int] = None):
        """
        The image tests configuration used when creating this image.
        :param bool image_tests_enabled: ImageTestsEnabled
        :param int timeout_minutes: TimeoutMinutes
        """
        if image_tests_enabled is not None:
            pulumi.set(__self__, "image_tests_enabled", image_tests_enabled)
        if timeout_minutes is not None:
            pulumi.set(__self__, "timeout_minutes", timeout_minutes)

    @property
    @pulumi.getter(name="imageTestsEnabled")
    def image_tests_enabled(self) -> Optional[bool]:
        """
        ImageTestsEnabled
        """
        return pulumi.get(self, "image_tests_enabled")

    @property
    @pulumi.getter(name="timeoutMinutes")
    def timeout_minutes(self) -> Optional[int]:
        """
        TimeoutMinutes
        """
        return pulumi.get(self, "timeout_minutes")


@pulumi.output_type
class InfrastructureConfigurationLogging(dict):
    """
    The logging configuration of the infrastructure configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Logs":
            suggest = "s3_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureConfigurationLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureConfigurationLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureConfigurationLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_logs: Optional['outputs.InfrastructureConfigurationS3Logs'] = None):
        """
        The logging configuration of the infrastructure configuration.
        """
        if s3_logs is not None:
            pulumi.set(__self__, "s3_logs", s3_logs)

    @property
    @pulumi.getter(name="s3Logs")
    def s3_logs(self) -> Optional['outputs.InfrastructureConfigurationS3Logs']:
        return pulumi.get(self, "s3_logs")


@pulumi.output_type
class InfrastructureConfigurationS3Logs(dict):
    """
    The S3 path in which to store the logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3KeyPrefix":
            suggest = "s3_key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureConfigurationS3Logs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureConfigurationS3Logs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureConfigurationS3Logs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_name: Optional[str] = None,
                 s3_key_prefix: Optional[str] = None):
        """
        The S3 path in which to store the logs.
        :param str s3_bucket_name: S3BucketName
        :param str s3_key_prefix: S3KeyPrefix
        """
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[str]:
        """
        S3BucketName
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[str]:
        """
        S3KeyPrefix
        """
        return pulumi.get(self, "s3_key_prefix")


