# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CapacityProviderAutoScalingGroupProvider',
    'CapacityProviderManagedScaling',
    'CapacityProviderTag',
    'ClusterCapacityProviderAssociationsCapacityProviderStrategy',
    'ClusterCapacityProviderStrategyItem',
    'ClusterConfiguration',
    'ClusterExecuteCommandConfiguration',
    'ClusterExecuteCommandLogConfiguration',
    'ClusterSettings',
    'ClusterTag',
    'ServiceAwsVpcConfiguration',
    'ServiceCapacityProviderStrategyItem',
    'ServiceDeploymentCircuitBreaker',
    'ServiceDeploymentConfiguration',
    'ServiceDeploymentController',
    'ServiceLoadBalancer',
    'ServiceNetworkConfiguration',
    'ServicePlacementConstraint',
    'ServicePlacementStrategy',
    'ServiceRegistry',
    'ServiceTag',
    'TaskDefinitionAuthorizationConfig',
    'TaskDefinitionContainerDefinition',
    'TaskDefinitionContainerDependency',
    'TaskDefinitionDevice',
    'TaskDefinitionDockerVolumeConfiguration',
    'TaskDefinitionEFSVolumeConfiguration',
    'TaskDefinitionEnvironmentFile',
    'TaskDefinitionEphemeralStorage',
    'TaskDefinitionFirelensConfiguration',
    'TaskDefinitionHealthCheck',
    'TaskDefinitionHostEntry',
    'TaskDefinitionHostVolumeProperties',
    'TaskDefinitionInferenceAccelerator',
    'TaskDefinitionKernelCapabilities',
    'TaskDefinitionKeyValuePair',
    'TaskDefinitionLinuxParameters',
    'TaskDefinitionLogConfiguration',
    'TaskDefinitionMountPoint',
    'TaskDefinitionPlacementConstraint',
    'TaskDefinitionPortMapping',
    'TaskDefinitionProxyConfiguration',
    'TaskDefinitionRepositoryCredentials',
    'TaskDefinitionResourceRequirement',
    'TaskDefinitionSecret',
    'TaskDefinitionSystemControl',
    'TaskDefinitionTag',
    'TaskDefinitionTmpfs',
    'TaskDefinitionUlimit',
    'TaskDefinitionVolume',
    'TaskDefinitionVolumeFrom',
    'TaskSetAwsVpcConfiguration',
    'TaskSetLoadBalancer',
    'TaskSetNetworkConfiguration',
    'TaskSetScale',
    'TaskSetServiceRegistry',
]

@pulumi.output_type
class CapacityProviderAutoScalingGroupProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoScalingGroupArn":
            suggest = "auto_scaling_group_arn"
        elif key == "managedScaling":
            suggest = "managed_scaling"
        elif key == "managedTerminationProtection":
            suggest = "managed_termination_protection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CapacityProviderAutoScalingGroupProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CapacityProviderAutoScalingGroupProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CapacityProviderAutoScalingGroupProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_scaling_group_arn: str,
                 managed_scaling: Optional['outputs.CapacityProviderManagedScaling'] = None,
                 managed_termination_protection: Optional['CapacityProviderAutoScalingGroupProviderManagedTerminationProtection'] = None):
        pulumi.set(__self__, "auto_scaling_group_arn", auto_scaling_group_arn)
        if managed_scaling is not None:
            pulumi.set(__self__, "managed_scaling", managed_scaling)
        if managed_termination_protection is not None:
            pulumi.set(__self__, "managed_termination_protection", managed_termination_protection)

    @property
    @pulumi.getter(name="autoScalingGroupArn")
    def auto_scaling_group_arn(self) -> str:
        return pulumi.get(self, "auto_scaling_group_arn")

    @property
    @pulumi.getter(name="managedScaling")
    def managed_scaling(self) -> Optional['outputs.CapacityProviderManagedScaling']:
        return pulumi.get(self, "managed_scaling")

    @property
    @pulumi.getter(name="managedTerminationProtection")
    def managed_termination_protection(self) -> Optional['CapacityProviderAutoScalingGroupProviderManagedTerminationProtection']:
        return pulumi.get(self, "managed_termination_protection")


@pulumi.output_type
class CapacityProviderManagedScaling(dict):
    """
    The managed scaling settings for the Auto Scaling group capacity provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceWarmupPeriod":
            suggest = "instance_warmup_period"
        elif key == "maximumScalingStepSize":
            suggest = "maximum_scaling_step_size"
        elif key == "minimumScalingStepSize":
            suggest = "minimum_scaling_step_size"
        elif key == "targetCapacity":
            suggest = "target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CapacityProviderManagedScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CapacityProviderManagedScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CapacityProviderManagedScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_warmup_period: Optional[int] = None,
                 maximum_scaling_step_size: Optional[int] = None,
                 minimum_scaling_step_size: Optional[int] = None,
                 status: Optional['CapacityProviderManagedScalingStatus'] = None,
                 target_capacity: Optional[int] = None):
        """
        The managed scaling settings for the Auto Scaling group capacity provider.
        """
        if instance_warmup_period is not None:
            pulumi.set(__self__, "instance_warmup_period", instance_warmup_period)
        if maximum_scaling_step_size is not None:
            pulumi.set(__self__, "maximum_scaling_step_size", maximum_scaling_step_size)
        if minimum_scaling_step_size is not None:
            pulumi.set(__self__, "minimum_scaling_step_size", minimum_scaling_step_size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_capacity is not None:
            pulumi.set(__self__, "target_capacity", target_capacity)

    @property
    @pulumi.getter(name="instanceWarmupPeriod")
    def instance_warmup_period(self) -> Optional[int]:
        return pulumi.get(self, "instance_warmup_period")

    @property
    @pulumi.getter(name="maximumScalingStepSize")
    def maximum_scaling_step_size(self) -> Optional[int]:
        return pulumi.get(self, "maximum_scaling_step_size")

    @property
    @pulumi.getter(name="minimumScalingStepSize")
    def minimum_scaling_step_size(self) -> Optional[int]:
        return pulumi.get(self, "minimum_scaling_step_size")

    @property
    @pulumi.getter
    def status(self) -> Optional['CapacityProviderManagedScalingStatus']:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetCapacity")
    def target_capacity(self) -> Optional[int]:
        return pulumi.get(self, "target_capacity")


@pulumi.output_type
class CapacityProviderTag(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ClusterCapacityProviderAssociationsCapacityProviderStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCapacityProviderAssociationsCapacityProviderStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCapacityProviderAssociationsCapacityProviderStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCapacityProviderAssociationsCapacityProviderStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: str,
                 base: Optional[int] = None,
                 weight: Optional[int] = None):
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> str:
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def base(self) -> Optional[int]:
        return pulumi.get(self, "base")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        return pulumi.get(self, "weight")


@pulumi.output_type
class ClusterCapacityProviderStrategyItem(dict):
    """
    A capacity provider strategy consists of one or more capacity providers along with the `base` and `weight` to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an `ACTIVE` or `UPDATING` status can be used.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCapacityProviderStrategyItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCapacityProviderStrategyItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCapacityProviderStrategyItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base: Optional[int] = None,
                 capacity_provider: Optional[str] = None,
                 weight: Optional[int] = None):
        """
        A capacity provider strategy consists of one or more capacity providers along with the `base` and `weight` to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an `ACTIVE` or `UPDATING` status can be used.
        """
        if base is not None:
            pulumi.set(__self__, "base", base)
        if capacity_provider is not None:
            pulumi.set(__self__, "capacity_provider", capacity_provider)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def base(self) -> Optional[int]:
        return pulumi.get(self, "base")

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> Optional[str]:
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        return pulumi.get(self, "weight")


@pulumi.output_type
class ClusterConfiguration(dict):
    """
    The configurations to be set at cluster level.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executeCommandConfiguration":
            suggest = "execute_command_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execute_command_configuration: Optional['outputs.ClusterExecuteCommandConfiguration'] = None):
        """
        The configurations to be set at cluster level.
        """
        if execute_command_configuration is not None:
            pulumi.set(__self__, "execute_command_configuration", execute_command_configuration)

    @property
    @pulumi.getter(name="executeCommandConfiguration")
    def execute_command_configuration(self) -> Optional['outputs.ClusterExecuteCommandConfiguration']:
        return pulumi.get(self, "execute_command_configuration")


@pulumi.output_type
class ClusterExecuteCommandConfiguration(dict):
    """
    The configuration for ExecuteCommand.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "logConfiguration":
            suggest = "log_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterExecuteCommandConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterExecuteCommandConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterExecuteCommandConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[str] = None,
                 log_configuration: Optional['outputs.ClusterExecuteCommandLogConfiguration'] = None,
                 logging: Optional[str] = None):
        """
        The configuration for ExecuteCommand.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.ClusterExecuteCommandLogConfiguration']:
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter
    def logging(self) -> Optional[str]:
        return pulumi.get(self, "logging")


@pulumi.output_type
class ClusterExecuteCommandLogConfiguration(dict):
    """
    The session logging configuration for ExecuteCommand.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchEncryptionEnabled":
            suggest = "cloud_watch_encryption_enabled"
        elif key == "cloudWatchLogGroupName":
            suggest = "cloud_watch_log_group_name"
        elif key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3EncryptionEnabled":
            suggest = "s3_encryption_enabled"
        elif key == "s3KeyPrefix":
            suggest = "s3_key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterExecuteCommandLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterExecuteCommandLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterExecuteCommandLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_encryption_enabled: Optional[bool] = None,
                 cloud_watch_log_group_name: Optional[str] = None,
                 s3_bucket_name: Optional[str] = None,
                 s3_encryption_enabled: Optional[bool] = None,
                 s3_key_prefix: Optional[str] = None):
        """
        The session logging configuration for ExecuteCommand.
        """
        if cloud_watch_encryption_enabled is not None:
            pulumi.set(__self__, "cloud_watch_encryption_enabled", cloud_watch_encryption_enabled)
        if cloud_watch_log_group_name is not None:
            pulumi.set(__self__, "cloud_watch_log_group_name", cloud_watch_log_group_name)
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_encryption_enabled is not None:
            pulumi.set(__self__, "s3_encryption_enabled", s3_encryption_enabled)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="cloudWatchEncryptionEnabled")
    def cloud_watch_encryption_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "cloud_watch_encryption_enabled")

    @property
    @pulumi.getter(name="cloudWatchLogGroupName")
    def cloud_watch_log_group_name(self) -> Optional[str]:
        return pulumi.get(self, "cloud_watch_log_group_name")

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[str]:
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3EncryptionEnabled")
    def s3_encryption_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "s3_encryption_enabled")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[str]:
        return pulumi.get(self, "s3_key_prefix")


@pulumi.output_type
class ClusterSettings(dict):
    """
    The setting to use when creating a cluster. This parameter is used to enable CloudWatch Container Insights for a cluster. If this value is specified, it will override the containerInsights value set with PutAccountSetting or PutAccountSettingDefault.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        The setting to use when creating a cluster. This parameter is used to enable CloudWatch Container Insights for a cluster. If this value is specified, it will override the containerInsights value set with PutAccountSetting or PutAccountSettingDefault.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ClusterTag(dict):
    """
    The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
    """
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceAwsVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAwsVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAwsVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAwsVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assign_public_ip: Optional['ServiceAwsVpcConfigurationAssignPublicIp'] = None,
                 security_groups: Optional[Sequence[str]] = None,
                 subnets: Optional[Sequence[str]] = None):
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional['ServiceAwsVpcConfigurationAssignPublicIp']:
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def subnets(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "subnets")


@pulumi.output_type
class ServiceCapacityProviderStrategyItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCapacityProviderStrategyItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCapacityProviderStrategyItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCapacityProviderStrategyItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base: Optional[int] = None,
                 capacity_provider: Optional[str] = None,
                 weight: Optional[int] = None):
        if base is not None:
            pulumi.set(__self__, "base", base)
        if capacity_provider is not None:
            pulumi.set(__self__, "capacity_provider", capacity_provider)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def base(self) -> Optional[int]:
        return pulumi.get(self, "base")

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> Optional[str]:
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServiceDeploymentCircuitBreaker(dict):
    def __init__(__self__, *,
                 enable: bool,
                 rollback: bool):
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "rollback", rollback)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def rollback(self) -> bool:
        return pulumi.get(self, "rollback")


@pulumi.output_type
class ServiceDeploymentConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentCircuitBreaker":
            suggest = "deployment_circuit_breaker"
        elif key == "maximumPercent":
            suggest = "maximum_percent"
        elif key == "minimumHealthyPercent":
            suggest = "minimum_healthy_percent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDeploymentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDeploymentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDeploymentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_circuit_breaker: Optional['outputs.ServiceDeploymentCircuitBreaker'] = None,
                 maximum_percent: Optional[int] = None,
                 minimum_healthy_percent: Optional[int] = None):
        if deployment_circuit_breaker is not None:
            pulumi.set(__self__, "deployment_circuit_breaker", deployment_circuit_breaker)
        if maximum_percent is not None:
            pulumi.set(__self__, "maximum_percent", maximum_percent)
        if minimum_healthy_percent is not None:
            pulumi.set(__self__, "minimum_healthy_percent", minimum_healthy_percent)

    @property
    @pulumi.getter(name="deploymentCircuitBreaker")
    def deployment_circuit_breaker(self) -> Optional['outputs.ServiceDeploymentCircuitBreaker']:
        return pulumi.get(self, "deployment_circuit_breaker")

    @property
    @pulumi.getter(name="maximumPercent")
    def maximum_percent(self) -> Optional[int]:
        return pulumi.get(self, "maximum_percent")

    @property
    @pulumi.getter(name="minimumHealthyPercent")
    def minimum_healthy_percent(self) -> Optional[int]:
        return pulumi.get(self, "minimum_healthy_percent")


@pulumi.output_type
class ServiceDeploymentController(dict):
    def __init__(__self__, *,
                 type: Optional['ServiceDeploymentControllerType'] = None):
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional['ServiceDeploymentControllerType']:
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "loadBalancerName":
            suggest = "load_balancer_name"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: Optional[str] = None,
                 container_port: Optional[int] = None,
                 load_balancer_name: Optional[str] = None,
                 target_group_arn: Optional[str] = None):
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[int]:
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[str]:
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[str]:
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class ServiceNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsvpcConfiguration":
            suggest = "awsvpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 awsvpc_configuration: Optional['outputs.ServiceAwsVpcConfiguration'] = None):
        if awsvpc_configuration is not None:
            pulumi.set(__self__, "awsvpc_configuration", awsvpc_configuration)

    @property
    @pulumi.getter(name="awsvpcConfiguration")
    def awsvpc_configuration(self) -> Optional['outputs.ServiceAwsVpcConfiguration']:
        return pulumi.get(self, "awsvpc_configuration")


@pulumi.output_type
class ServicePlacementConstraint(dict):
    def __init__(__self__, *,
                 type: 'ServicePlacementConstraintType',
                 expression: Optional[str] = None):
        pulumi.set(__self__, "type", type)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def type(self) -> 'ServicePlacementConstraintType':
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        return pulumi.get(self, "expression")


@pulumi.output_type
class ServicePlacementStrategy(dict):
    def __init__(__self__, *,
                 type: 'ServicePlacementStrategyType',
                 field: Optional[str] = None):
        pulumi.set(__self__, "type", type)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def type(self) -> 'ServicePlacementStrategyType':
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        return pulumi.get(self, "field")


@pulumi.output_type
class ServiceRegistry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "registryArn":
            suggest = "registry_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceRegistry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceRegistry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceRegistry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: Optional[str] = None,
                 container_port: Optional[int] = None,
                 port: Optional[int] = None,
                 registry_arn: Optional[str] = None):
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if registry_arn is not None:
            pulumi.set(__self__, "registry_arn", registry_arn)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[int]:
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="registryArn")
    def registry_arn(self) -> Optional[str]:
        return pulumi.get(self, "registry_arn")


@pulumi.output_type
class ServiceTag(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskDefinitionAuthorizationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessPointId":
            suggest = "access_point_id"
        elif key == "iAM":
            suggest = "i_am"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionAuthorizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionAuthorizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionAuthorizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_point_id: Optional[str] = None,
                 i_am: Optional['TaskDefinitionAuthorizationConfigIAM'] = None):
        if access_point_id is not None:
            pulumi.set(__self__, "access_point_id", access_point_id)
        if i_am is not None:
            pulumi.set(__self__, "i_am", i_am)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> Optional[str]:
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter(name="iAM")
    def i_am(self) -> Optional['TaskDefinitionAuthorizationConfigIAM']:
        return pulumi.get(self, "i_am")


@pulumi.output_type
class TaskDefinitionContainerDefinition(dict):
    """
    List of container definitions that are passed to the Docker daemon on a container instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "disableNetworking":
            suggest = "disable_networking"
        elif key == "dnsSearchDomains":
            suggest = "dns_search_domains"
        elif key == "dnsServers":
            suggest = "dns_servers"
        elif key == "dockerLabels":
            suggest = "docker_labels"
        elif key == "dockerSecurityOptions":
            suggest = "docker_security_options"
        elif key == "entryPoint":
            suggest = "entry_point"
        elif key == "environmentFiles":
            suggest = "environment_files"
        elif key == "extraHosts":
            suggest = "extra_hosts"
        elif key == "firelensConfiguration":
            suggest = "firelens_configuration"
        elif key == "healthCheck":
            suggest = "health_check"
        elif key == "linuxParameters":
            suggest = "linux_parameters"
        elif key == "logConfiguration":
            suggest = "log_configuration"
        elif key == "memoryReservation":
            suggest = "memory_reservation"
        elif key == "mountPoints":
            suggest = "mount_points"
        elif key == "portMappings":
            suggest = "port_mappings"
        elif key == "pseudoTerminal":
            suggest = "pseudo_terminal"
        elif key == "readonlyRootFilesystem":
            suggest = "readonly_root_filesystem"
        elif key == "repositoryCredentials":
            suggest = "repository_credentials"
        elif key == "resourceRequirements":
            suggest = "resource_requirements"
        elif key == "startTimeout":
            suggest = "start_timeout"
        elif key == "stopTimeout":
            suggest = "stop_timeout"
        elif key == "systemControls":
            suggest = "system_controls"
        elif key == "volumesFrom":
            suggest = "volumes_from"
        elif key == "workingDirectory":
            suggest = "working_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionContainerDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionContainerDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionContainerDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: Optional[Sequence[str]] = None,
                 cpu: Optional[int] = None,
                 depends_on: Optional[Sequence['outputs.TaskDefinitionContainerDependency']] = None,
                 disable_networking: Optional[bool] = None,
                 dns_search_domains: Optional[Sequence[str]] = None,
                 dns_servers: Optional[Sequence[str]] = None,
                 docker_labels: Optional[Any] = None,
                 docker_security_options: Optional[Sequence[str]] = None,
                 entry_point: Optional[Sequence[str]] = None,
                 environment: Optional[Sequence['outputs.TaskDefinitionKeyValuePair']] = None,
                 environment_files: Optional[Sequence['outputs.TaskDefinitionEnvironmentFile']] = None,
                 essential: Optional[bool] = None,
                 extra_hosts: Optional[Sequence['outputs.TaskDefinitionHostEntry']] = None,
                 firelens_configuration: Optional['outputs.TaskDefinitionFirelensConfiguration'] = None,
                 health_check: Optional['outputs.TaskDefinitionHealthCheck'] = None,
                 hostname: Optional[str] = None,
                 image: Optional[str] = None,
                 interactive: Optional[bool] = None,
                 links: Optional[Sequence[str]] = None,
                 linux_parameters: Optional['outputs.TaskDefinitionLinuxParameters'] = None,
                 log_configuration: Optional['outputs.TaskDefinitionLogConfiguration'] = None,
                 memory: Optional[int] = None,
                 memory_reservation: Optional[int] = None,
                 mount_points: Optional[Sequence['outputs.TaskDefinitionMountPoint']] = None,
                 name: Optional[str] = None,
                 port_mappings: Optional[Sequence['outputs.TaskDefinitionPortMapping']] = None,
                 privileged: Optional[bool] = None,
                 pseudo_terminal: Optional[bool] = None,
                 readonly_root_filesystem: Optional[bool] = None,
                 repository_credentials: Optional['outputs.TaskDefinitionRepositoryCredentials'] = None,
                 resource_requirements: Optional[Sequence['outputs.TaskDefinitionResourceRequirement']] = None,
                 secrets: Optional[Sequence['outputs.TaskDefinitionSecret']] = None,
                 start_timeout: Optional[int] = None,
                 stop_timeout: Optional[int] = None,
                 system_controls: Optional[Sequence['outputs.TaskDefinitionSystemControl']] = None,
                 ulimits: Optional[Sequence['outputs.TaskDefinitionUlimit']] = None,
                 user: Optional[str] = None,
                 volumes_from: Optional[Sequence['outputs.TaskDefinitionVolumeFrom']] = None,
                 working_directory: Optional[str] = None):
        """
        List of container definitions that are passed to the Docker daemon on a container instance
        :param Sequence['TaskDefinitionKeyValuePair'] environment: The environment variables to pass to a container
        :param Sequence['TaskDefinitionEnvironmentFile'] environment_files: The list of one or more files that contain the environment variables to pass to a container
        :param str image: The image used to start a container. This string is passed directly to the Docker daemon.
        :param int memory: The amount (in MiB) of memory to present to the container. If your container attempts to exceed the memory specified here, the container is killed.
        :param str name: The name of a container. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed
        :param Sequence['TaskDefinitionPortMapping'] port_mappings: Port mappings allow containers to access ports on the host container instance to send or receive traffic.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if disable_networking is not None:
            pulumi.set(__self__, "disable_networking", disable_networking)
        if dns_search_domains is not None:
            pulumi.set(__self__, "dns_search_domains", dns_search_domains)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if docker_labels is not None:
            pulumi.set(__self__, "docker_labels", docker_labels)
        if docker_security_options is not None:
            pulumi.set(__self__, "docker_security_options", docker_security_options)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if environment_files is not None:
            pulumi.set(__self__, "environment_files", environment_files)
        if essential is not None:
            pulumi.set(__self__, "essential", essential)
        if extra_hosts is not None:
            pulumi.set(__self__, "extra_hosts", extra_hosts)
        if firelens_configuration is not None:
            pulumi.set(__self__, "firelens_configuration", firelens_configuration)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if interactive is not None:
            pulumi.set(__self__, "interactive", interactive)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if linux_parameters is not None:
            pulumi.set(__self__, "linux_parameters", linux_parameters)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_reservation is not None:
            pulumi.set(__self__, "memory_reservation", memory_reservation)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_mappings is not None:
            pulumi.set(__self__, "port_mappings", port_mappings)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if pseudo_terminal is not None:
            pulumi.set(__self__, "pseudo_terminal", pseudo_terminal)
        if readonly_root_filesystem is not None:
            pulumi.set(__self__, "readonly_root_filesystem", readonly_root_filesystem)
        if repository_credentials is not None:
            pulumi.set(__self__, "repository_credentials", repository_credentials)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if start_timeout is not None:
            pulumi.set(__self__, "start_timeout", start_timeout)
        if stop_timeout is not None:
            pulumi.set(__self__, "stop_timeout", stop_timeout)
        if system_controls is not None:
            pulumi.set(__self__, "system_controls", system_controls)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if volumes_from is not None:
            pulumi.set(__self__, "volumes_from", volumes_from)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[int]:
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.TaskDefinitionContainerDependency']]:
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter(name="disableNetworking")
    def disable_networking(self) -> Optional[bool]:
        return pulumi.get(self, "disable_networking")

    @property
    @pulumi.getter(name="dnsSearchDomains")
    def dns_search_domains(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "dns_search_domains")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="dockerLabels")
    def docker_labels(self) -> Optional[Any]:
        return pulumi.get(self, "docker_labels")

    @property
    @pulumi.getter(name="dockerSecurityOptions")
    def docker_security_options(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "docker_security_options")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Sequence['outputs.TaskDefinitionKeyValuePair']]:
        """
        The environment variables to pass to a container
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="environmentFiles")
    def environment_files(self) -> Optional[Sequence['outputs.TaskDefinitionEnvironmentFile']]:
        """
        The list of one or more files that contain the environment variables to pass to a container
        """
        return pulumi.get(self, "environment_files")

    @property
    @pulumi.getter
    def essential(self) -> Optional[bool]:
        return pulumi.get(self, "essential")

    @property
    @pulumi.getter(name="extraHosts")
    def extra_hosts(self) -> Optional[Sequence['outputs.TaskDefinitionHostEntry']]:
        return pulumi.get(self, "extra_hosts")

    @property
    @pulumi.getter(name="firelensConfiguration")
    def firelens_configuration(self) -> Optional['outputs.TaskDefinitionFirelensConfiguration']:
        return pulumi.get(self, "firelens_configuration")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional['outputs.TaskDefinitionHealthCheck']:
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        The image used to start a container. This string is passed directly to the Docker daemon.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def interactive(self) -> Optional[bool]:
        return pulumi.get(self, "interactive")

    @property
    @pulumi.getter
    def links(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "links")

    @property
    @pulumi.getter(name="linuxParameters")
    def linux_parameters(self) -> Optional['outputs.TaskDefinitionLinuxParameters']:
        return pulumi.get(self, "linux_parameters")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.TaskDefinitionLogConfiguration']:
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter
    def memory(self) -> Optional[int]:
        """
        The amount (in MiB) of memory to present to the container. If your container attempts to exceed the memory specified here, the container is killed.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[int]:
        return pulumi.get(self, "memory_reservation")

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[Sequence['outputs.TaskDefinitionMountPoint']]:
        return pulumi.get(self, "mount_points")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of a container. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="portMappings")
    def port_mappings(self) -> Optional[Sequence['outputs.TaskDefinitionPortMapping']]:
        """
        Port mappings allow containers to access ports on the host container instance to send or receive traffic.
        """
        return pulumi.get(self, "port_mappings")

    @property
    @pulumi.getter
    def privileged(self) -> Optional[bool]:
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="pseudoTerminal")
    def pseudo_terminal(self) -> Optional[bool]:
        return pulumi.get(self, "pseudo_terminal")

    @property
    @pulumi.getter(name="readonlyRootFilesystem")
    def readonly_root_filesystem(self) -> Optional[bool]:
        return pulumi.get(self, "readonly_root_filesystem")

    @property
    @pulumi.getter(name="repositoryCredentials")
    def repository_credentials(self) -> Optional['outputs.TaskDefinitionRepositoryCredentials']:
        return pulumi.get(self, "repository_credentials")

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[Sequence['outputs.TaskDefinitionResourceRequirement']]:
        return pulumi.get(self, "resource_requirements")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.TaskDefinitionSecret']]:
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="startTimeout")
    def start_timeout(self) -> Optional[int]:
        return pulumi.get(self, "start_timeout")

    @property
    @pulumi.getter(name="stopTimeout")
    def stop_timeout(self) -> Optional[int]:
        return pulumi.get(self, "stop_timeout")

    @property
    @pulumi.getter(name="systemControls")
    def system_controls(self) -> Optional[Sequence['outputs.TaskDefinitionSystemControl']]:
        return pulumi.get(self, "system_controls")

    @property
    @pulumi.getter
    def ulimits(self) -> Optional[Sequence['outputs.TaskDefinitionUlimit']]:
        return pulumi.get(self, "ulimits")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="volumesFrom")
    def volumes_from(self) -> Optional[Sequence['outputs.TaskDefinitionVolumeFrom']]:
        return pulumi.get(self, "volumes_from")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[str]:
        return pulumi.get(self, "working_directory")


@pulumi.output_type
class TaskDefinitionContainerDependency(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionContainerDependency. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionContainerDependency.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionContainerDependency.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: Optional[str] = None,
                 container_name: Optional[str] = None):
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)

    @property
    @pulumi.getter
    def condition(self) -> Optional[str]:
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        return pulumi.get(self, "container_name")


@pulumi.output_type
class TaskDefinitionDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPath":
            suggest = "container_path"
        elif key == "hostPath":
            suggest = "host_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_path: Optional[str] = None,
                 host_path: Optional[str] = None,
                 permissions: Optional[Sequence[str]] = None):
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[str]:
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[str]:
        return pulumi.get(self, "host_path")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "permissions")


@pulumi.output_type
class TaskDefinitionDockerVolumeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverOpts":
            suggest = "driver_opts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionDockerVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionDockerVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionDockerVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoprovision: Optional[bool] = None,
                 driver: Optional[str] = None,
                 driver_opts: Optional[Any] = None,
                 labels: Optional[Any] = None,
                 scope: Optional[str] = None):
        if autoprovision is not None:
            pulumi.set(__self__, "autoprovision", autoprovision)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if driver_opts is not None:
            pulumi.set(__self__, "driver_opts", driver_opts)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def autoprovision(self) -> Optional[bool]:
        return pulumi.get(self, "autoprovision")

    @property
    @pulumi.getter
    def driver(self) -> Optional[str]:
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter(name="driverOpts")
    def driver_opts(self) -> Optional[Any]:
        return pulumi.get(self, "driver_opts")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Any]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        return pulumi.get(self, "scope")


@pulumi.output_type
class TaskDefinitionEFSVolumeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filesystemId":
            suggest = "filesystem_id"
        elif key == "authorizationConfig":
            suggest = "authorization_config"
        elif key == "rootDirectory":
            suggest = "root_directory"
        elif key == "transitEncryption":
            suggest = "transit_encryption"
        elif key == "transitEncryptionPort":
            suggest = "transit_encryption_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionEFSVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionEFSVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionEFSVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filesystem_id: str,
                 authorization_config: Optional['outputs.TaskDefinitionAuthorizationConfig'] = None,
                 root_directory: Optional[str] = None,
                 transit_encryption: Optional['TaskDefinitionEFSVolumeConfigurationTransitEncryption'] = None,
                 transit_encryption_port: Optional[int] = None):
        pulumi.set(__self__, "filesystem_id", filesystem_id)
        if authorization_config is not None:
            pulumi.set(__self__, "authorization_config", authorization_config)
        if root_directory is not None:
            pulumi.set(__self__, "root_directory", root_directory)
        if transit_encryption is not None:
            pulumi.set(__self__, "transit_encryption", transit_encryption)
        if transit_encryption_port is not None:
            pulumi.set(__self__, "transit_encryption_port", transit_encryption_port)

    @property
    @pulumi.getter(name="filesystemId")
    def filesystem_id(self) -> str:
        return pulumi.get(self, "filesystem_id")

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> Optional['outputs.TaskDefinitionAuthorizationConfig']:
        return pulumi.get(self, "authorization_config")

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> Optional[str]:
        return pulumi.get(self, "root_directory")

    @property
    @pulumi.getter(name="transitEncryption")
    def transit_encryption(self) -> Optional['TaskDefinitionEFSVolumeConfigurationTransitEncryption']:
        return pulumi.get(self, "transit_encryption")

    @property
    @pulumi.getter(name="transitEncryptionPort")
    def transit_encryption_port(self) -> Optional[int]:
        return pulumi.get(self, "transit_encryption_port")


@pulumi.output_type
class TaskDefinitionEnvironmentFile(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskDefinitionEphemeralStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInGiB":
            suggest = "size_in_gi_b"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionEphemeralStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionEphemeralStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionEphemeralStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_in_gi_b: Optional[int] = None):
        if size_in_gi_b is not None:
            pulumi.set(__self__, "size_in_gi_b", size_in_gi_b)

    @property
    @pulumi.getter(name="sizeInGiB")
    def size_in_gi_b(self) -> Optional[int]:
        return pulumi.get(self, "size_in_gi_b")


@pulumi.output_type
class TaskDefinitionFirelensConfiguration(dict):
    def __init__(__self__, *,
                 options: Optional[Any] = None,
                 type: Optional[str] = None):
        if options is not None:
            pulumi.set(__self__, "options", options)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def options(self) -> Optional[Any]:
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class TaskDefinitionHealthCheck(dict):
    """
    The health check command and associated configuration parameters for the container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startPeriod":
            suggest = "start_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: Optional[Sequence[str]] = None,
                 interval: Optional[int] = None,
                 retries: Optional[int] = None,
                 start_period: Optional[int] = None,
                 timeout: Optional[int] = None):
        """
        The health check command and associated configuration parameters for the container.
        :param Sequence[str] command: A string array representing the command that the container runs to determine if it is healthy.
        :param int interval: The time period in seconds between each health check execution. You may specify between 5 and 300 seconds. The default value is 30 seconds.
        :param int retries: The number of times to retry a failed health check before the container is considered unhealthy. You may specify between 1 and 10 retries. The default value is three retries.
        :param int start_period: The optional grace period within which to provide containers time to bootstrap before failed health checks count towards the maximum number of retries. You may specify between 0 and 300 seconds. The startPeriod is disabled by default.
        :param int timeout: The time period in seconds to wait for a health check to succeed before it is considered a failure. You may specify between 2 and 60 seconds. The default value is 5 seconds.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[str]]:
        """
        A string array representing the command that the container runs to determine if it is healthy.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The time period in seconds between each health check execution. You may specify between 5 and 300 seconds. The default value is 30 seconds.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def retries(self) -> Optional[int]:
        """
        The number of times to retry a failed health check before the container is considered unhealthy. You may specify between 1 and 10 retries. The default value is three retries.
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[int]:
        """
        The optional grace period within which to provide containers time to bootstrap before failed health checks count towards the maximum number of retries. You may specify between 0 and 300 seconds. The startPeriod is disabled by default.
        """
        return pulumi.get(self, "start_period")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        The time period in seconds to wait for a health check to succeed before it is considered a failure. You may specify between 2 and 60 seconds. The default value is 5 seconds.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class TaskDefinitionHostEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionHostEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionHostEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionHostEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: Optional[str] = None,
                 ip_address: Optional[str] = None):
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class TaskDefinitionHostVolumeProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourcePath":
            suggest = "source_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionHostVolumeProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionHostVolumeProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionHostVolumeProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_path: Optional[str] = None):
        if source_path is not None:
            pulumi.set(__self__, "source_path", source_path)

    @property
    @pulumi.getter(name="sourcePath")
    def source_path(self) -> Optional[str]:
        return pulumi.get(self, "source_path")


@pulumi.output_type
class TaskDefinitionInferenceAccelerator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "deviceType":
            suggest = "device_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionInferenceAccelerator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionInferenceAccelerator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionInferenceAccelerator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: Optional[str] = None,
                 device_type: Optional[str] = None):
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[str]:
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[str]:
        return pulumi.get(self, "device_type")


@pulumi.output_type
class TaskDefinitionKernelCapabilities(dict):
    def __init__(__self__, *,
                 add: Optional[Sequence[str]] = None,
                 drop: Optional[Sequence[str]] = None):
        if add is not None:
            pulumi.set(__self__, "add", add)
        if drop is not None:
            pulumi.set(__self__, "drop", drop)

    @property
    @pulumi.getter
    def add(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "add")

    @property
    @pulumi.getter
    def drop(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "drop")


@pulumi.output_type
class TaskDefinitionKeyValuePair(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskDefinitionLinuxParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initProcessEnabled":
            suggest = "init_process_enabled"
        elif key == "maxSwap":
            suggest = "max_swap"
        elif key == "sharedMemorySize":
            suggest = "shared_memory_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionLinuxParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionLinuxParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionLinuxParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capabilities: Optional['outputs.TaskDefinitionKernelCapabilities'] = None,
                 devices: Optional[Sequence['outputs.TaskDefinitionDevice']] = None,
                 init_process_enabled: Optional[bool] = None,
                 max_swap: Optional[int] = None,
                 shared_memory_size: Optional[int] = None,
                 swappiness: Optional[int] = None,
                 tmpfs: Optional[Sequence['outputs.TaskDefinitionTmpfs']] = None):
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if init_process_enabled is not None:
            pulumi.set(__self__, "init_process_enabled", init_process_enabled)
        if max_swap is not None:
            pulumi.set(__self__, "max_swap", max_swap)
        if shared_memory_size is not None:
            pulumi.set(__self__, "shared_memory_size", shared_memory_size)
        if swappiness is not None:
            pulumi.set(__self__, "swappiness", swappiness)
        if tmpfs is not None:
            pulumi.set(__self__, "tmpfs", tmpfs)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional['outputs.TaskDefinitionKernelCapabilities']:
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def devices(self) -> Optional[Sequence['outputs.TaskDefinitionDevice']]:
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="initProcessEnabled")
    def init_process_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "init_process_enabled")

    @property
    @pulumi.getter(name="maxSwap")
    def max_swap(self) -> Optional[int]:
        return pulumi.get(self, "max_swap")

    @property
    @pulumi.getter(name="sharedMemorySize")
    def shared_memory_size(self) -> Optional[int]:
        return pulumi.get(self, "shared_memory_size")

    @property
    @pulumi.getter
    def swappiness(self) -> Optional[int]:
        return pulumi.get(self, "swappiness")

    @property
    @pulumi.getter
    def tmpfs(self) -> Optional[Sequence['outputs.TaskDefinitionTmpfs']]:
        return pulumi.get(self, "tmpfs")


@pulumi.output_type
class TaskDefinitionLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logDriver":
            suggest = "log_driver"
        elif key == "secretOptions":
            suggest = "secret_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_driver: str,
                 options: Optional[Any] = None,
                 secret_options: Optional[Sequence['outputs.TaskDefinitionSecret']] = None):
        pulumi.set(__self__, "log_driver", log_driver)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if secret_options is not None:
            pulumi.set(__self__, "secret_options", secret_options)

    @property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> str:
        return pulumi.get(self, "log_driver")

    @property
    @pulumi.getter
    def options(self) -> Optional[Any]:
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="secretOptions")
    def secret_options(self) -> Optional[Sequence['outputs.TaskDefinitionSecret']]:
        return pulumi.get(self, "secret_options")


@pulumi.output_type
class TaskDefinitionMountPoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPath":
            suggest = "container_path"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "sourceVolume":
            suggest = "source_volume"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionMountPoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionMountPoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionMountPoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_path: Optional[str] = None,
                 read_only: Optional[bool] = None,
                 source_volume: Optional[str] = None):
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source_volume is not None:
            pulumi.set(__self__, "source_volume", source_volume)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[str]:
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="sourceVolume")
    def source_volume(self) -> Optional[str]:
        return pulumi.get(self, "source_volume")


@pulumi.output_type
class TaskDefinitionPlacementConstraint(dict):
    def __init__(__self__, *,
                 type: str,
                 expression: Optional[str] = None):
        pulumi.set(__self__, "type", type)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        return pulumi.get(self, "expression")


@pulumi.output_type
class TaskDefinitionPortMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"
        elif key == "hostPort":
            suggest = "host_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionPortMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionPortMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionPortMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: Optional[int] = None,
                 host_port: Optional[int] = None,
                 protocol: Optional[str] = None):
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[int]:
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[int]:
        return pulumi.get(self, "host_port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class TaskDefinitionProxyConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "proxyConfigurationProperties":
            suggest = "proxy_configuration_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionProxyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionProxyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionProxyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: str,
                 proxy_configuration_properties: Optional[Sequence['outputs.TaskDefinitionKeyValuePair']] = None,
                 type: Optional[str] = None):
        pulumi.set(__self__, "container_name", container_name)
        if proxy_configuration_properties is not None:
            pulumi.set(__self__, "proxy_configuration_properties", proxy_configuration_properties)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="proxyConfigurationProperties")
    def proxy_configuration_properties(self) -> Optional[Sequence['outputs.TaskDefinitionKeyValuePair']]:
        return pulumi.get(self, "proxy_configuration_properties")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class TaskDefinitionRepositoryCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsParameter":
            suggest = "credentials_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionRepositoryCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionRepositoryCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionRepositoryCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_parameter: Optional[str] = None):
        if credentials_parameter is not None:
            pulumi.set(__self__, "credentials_parameter", credentials_parameter)

    @property
    @pulumi.getter(name="credentialsParameter")
    def credentials_parameter(self) -> Optional[str]:
        return pulumi.get(self, "credentials_parameter")


@pulumi.output_type
class TaskDefinitionResourceRequirement(dict):
    def __init__(__self__, *,
                 type: str,
                 value: str):
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskDefinitionSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value_from: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> str:
        return pulumi.get(self, "value_from")


@pulumi.output_type
class TaskDefinitionSystemControl(dict):
    def __init__(__self__, *,
                 namespace: Optional[str] = None,
                 value: Optional[str] = None):
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskDefinitionTag(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskDefinitionTmpfs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPath":
            suggest = "container_path"
        elif key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionTmpfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionTmpfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionTmpfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 container_path: Optional[str] = None,
                 mount_options: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "size", size)
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter
    def size(self) -> int:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[str]:
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "mount_options")


@pulumi.output_type
class TaskDefinitionUlimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hardLimit":
            suggest = "hard_limit"
        elif key == "softLimit":
            suggest = "soft_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionUlimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionUlimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionUlimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hard_limit: int,
                 name: str,
                 soft_limit: int):
        pulumi.set(__self__, "hard_limit", hard_limit)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft_limit", soft_limit)

    @property
    @pulumi.getter(name="hardLimit")
    def hard_limit(self) -> int:
        return pulumi.get(self, "hard_limit")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="softLimit")
    def soft_limit(self) -> int:
        return pulumi.get(self, "soft_limit")


@pulumi.output_type
class TaskDefinitionVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerVolumeConfiguration":
            suggest = "docker_volume_configuration"
        elif key == "eFSVolumeConfiguration":
            suggest = "e_fs_volume_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 docker_volume_configuration: Optional['outputs.TaskDefinitionDockerVolumeConfiguration'] = None,
                 e_fs_volume_configuration: Optional['outputs.TaskDefinitionEFSVolumeConfiguration'] = None,
                 host: Optional['outputs.TaskDefinitionHostVolumeProperties'] = None,
                 name: Optional[str] = None):
        if docker_volume_configuration is not None:
            pulumi.set(__self__, "docker_volume_configuration", docker_volume_configuration)
        if e_fs_volume_configuration is not None:
            pulumi.set(__self__, "e_fs_volume_configuration", e_fs_volume_configuration)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dockerVolumeConfiguration")
    def docker_volume_configuration(self) -> Optional['outputs.TaskDefinitionDockerVolumeConfiguration']:
        return pulumi.get(self, "docker_volume_configuration")

    @property
    @pulumi.getter(name="eFSVolumeConfiguration")
    def e_fs_volume_configuration(self) -> Optional['outputs.TaskDefinitionEFSVolumeConfiguration']:
        return pulumi.get(self, "e_fs_volume_configuration")

    @property
    @pulumi.getter
    def host(self) -> Optional['outputs.TaskDefinitionHostVolumeProperties']:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class TaskDefinitionVolumeFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"
        elif key == "sourceContainer":
            suggest = "source_container"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolumeFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolumeFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolumeFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 read_only: Optional[bool] = None,
                 source_container: Optional[str] = None):
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source_container is not None:
            pulumi.set(__self__, "source_container", source_container)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="sourceContainer")
    def source_container(self) -> Optional[str]:
        return pulumi.get(self, "source_container")


@pulumi.output_type
class TaskSetAwsVpcConfiguration(dict):
    """
    The VPC subnets and security groups associated with a task. All specified subnets and security groups must be from the same VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSetAwsVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSetAwsVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSetAwsVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnets: Sequence[str],
                 assign_public_ip: Optional['TaskSetAwsVpcConfigurationAssignPublicIp'] = None,
                 security_groups: Optional[Sequence[str]] = None):
        """
        The VPC subnets and security groups associated with a task. All specified subnets and security groups must be from the same VPC.
        :param Sequence[str] subnets: The subnets associated with the task or service. There is a limit of 16 subnets that can be specified per AwsVpcConfiguration.
        :param 'TaskSetAwsVpcConfigurationAssignPublicIp' assign_public_ip: Whether the task's elastic network interface receives a public IP address. The default value is DISABLED.
        :param Sequence[str] security_groups: The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used. There is a limit of 5 security groups that can be specified per AwsVpcConfiguration.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The subnets associated with the task or service. There is a limit of 16 subnets that can be specified per AwsVpcConfiguration.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional['TaskSetAwsVpcConfigurationAssignPublicIp']:
        """
        Whether the task's elastic network interface receives a public IP address. The default value is DISABLED.
        """
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        """
        The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used. There is a limit of 5 security groups that can be specified per AwsVpcConfiguration.
        """
        return pulumi.get(self, "security_groups")


@pulumi.output_type
class TaskSetLoadBalancer(dict):
    """
    A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "loadBalancerName":
            suggest = "load_balancer_name"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSetLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSetLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSetLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: Optional[str] = None,
                 container_port: Optional[int] = None,
                 load_balancer_name: Optional[str] = None,
                 target_group_arn: Optional[str] = None):
        """
        A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer. 
        :param str container_name: The name of the container (as it appears in a container definition) to associate with the load balancer.
        :param int container_port: The port on the container to associate with the load balancer. This port must correspond to a containerPort in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they are launched on must allow ingress traffic on the hostPort of the port mapping.
        :param str load_balancer_name: The name of the load balancer to associate with the Amazon ECS service or task set. A load balancer name is only specified when using a Classic Load Balancer. If you are using an Application Load Balancer or a Network Load Balancer this should be omitted.
        :param str target_group_arn: The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or task set. A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer. If you are using a Classic Load Balancer this should be omitted. For services using the ECS deployment controller, you can specify one or multiple target groups. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html in the Amazon Elastic Container Service Developer Guide. For services using the CODE_DEPLOY deployment controller, you are required to define two target groups for the load balancer. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html in the Amazon Elastic Container Service Developer Guide. If your service's task definition uses the awsvpc network mode (which is required for the Fargate launch type), you must choose ip as the target type, not instance, when creating your target groups because tasks that use the awsvpc network mode are associated with an elastic network interface, not an Amazon EC2 instance.
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        The name of the container (as it appears in a container definition) to associate with the load balancer.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[int]:
        """
        The port on the container to associate with the load balancer. This port must correspond to a containerPort in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they are launched on must allow ingress traffic on the hostPort of the port mapping.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[str]:
        """
        The name of the load balancer to associate with the Amazon ECS service or task set. A load balancer name is only specified when using a Classic Load Balancer. If you are using an Application Load Balancer or a Network Load Balancer this should be omitted.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[str]:
        """
        The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or task set. A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer. If you are using a Classic Load Balancer this should be omitted. For services using the ECS deployment controller, you can specify one or multiple target groups. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html in the Amazon Elastic Container Service Developer Guide. For services using the CODE_DEPLOY deployment controller, you are required to define two target groups for the load balancer. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html in the Amazon Elastic Container Service Developer Guide. If your service's task definition uses the awsvpc network mode (which is required for the Fargate launch type), you must choose ip as the target type, not instance, when creating your target groups because tasks that use the awsvpc network mode are associated with an elastic network interface, not an Amazon EC2 instance.
        """
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class TaskSetNetworkConfiguration(dict):
    """
    An object representing the network configuration for a task or service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsVpcConfiguration":
            suggest = "aws_vpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSetNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSetNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSetNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_vpc_configuration: Optional['outputs.TaskSetAwsVpcConfiguration'] = None):
        """
        An object representing the network configuration for a task or service.
        """
        if aws_vpc_configuration is not None:
            pulumi.set(__self__, "aws_vpc_configuration", aws_vpc_configuration)

    @property
    @pulumi.getter(name="awsVpcConfiguration")
    def aws_vpc_configuration(self) -> Optional['outputs.TaskSetAwsVpcConfiguration']:
        return pulumi.get(self, "aws_vpc_configuration")


@pulumi.output_type
class TaskSetScale(dict):
    def __init__(__self__, *,
                 unit: Optional['TaskSetScaleUnit'] = None,
                 value: Optional[float] = None):
        """
        :param 'TaskSetScaleUnit' unit: The unit of measure for the scale value.
        :param float value: The value, specified as a percent total of a service's desiredCount, to scale the task set. Accepted values are numbers between 0 and 100.
        """
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional['TaskSetScaleUnit']:
        """
        The unit of measure for the scale value.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> Optional[float]:
        """
        The value, specified as a percent total of a service's desiredCount, to scale the task set. Accepted values are numbers between 0 and 100.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskSetServiceRegistry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "registryArn":
            suggest = "registry_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSetServiceRegistry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSetServiceRegistry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSetServiceRegistry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: Optional[str] = None,
                 container_port: Optional[int] = None,
                 port: Optional[int] = None,
                 registry_arn: Optional[str] = None):
        """
        :param str container_name: The container name value, already specified in the task definition, to be used for your service discovery service. If the task definition that your service task specifies uses the bridge or host network mode, you must specify a containerName and containerPort combination from the task definition. If the task definition that your service task specifies uses the awsvpc network mode and a type SRV DNS record is used, you must specify either a containerName and containerPort combination or a port value, but not both.
        :param int container_port: The port value, already specified in the task definition, to be used for your service discovery service. If the task definition your service task specifies uses the bridge or host network mode, you must specify a containerName and containerPort combination from the task definition. If the task definition your service task specifies uses the awsvpc network mode and a type SRV DNS record is used, you must specify either a containerName and containerPort combination or a port value, but not both.
        :param int port: The port value used if your service discovery service specified an SRV record. This field may be used if both the awsvpc network mode and SRV records are used.
        :param str registry_arn: The Amazon Resource Name (ARN) of the service registry. The currently supported service registry is AWS Cloud Map. For more information, see https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if registry_arn is not None:
            pulumi.set(__self__, "registry_arn", registry_arn)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        The container name value, already specified in the task definition, to be used for your service discovery service. If the task definition that your service task specifies uses the bridge or host network mode, you must specify a containerName and containerPort combination from the task definition. If the task definition that your service task specifies uses the awsvpc network mode and a type SRV DNS record is used, you must specify either a containerName and containerPort combination or a port value, but not both.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[int]:
        """
        The port value, already specified in the task definition, to be used for your service discovery service. If the task definition your service task specifies uses the bridge or host network mode, you must specify a containerName and containerPort combination from the task definition. If the task definition your service task specifies uses the awsvpc network mode and a type SRV DNS record is used, you must specify either a containerName and containerPort combination or a port value, but not both.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port value used if your service discovery service specified an SRV record. This field may be used if both the awsvpc network mode and SRV records are used.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="registryArn")
    def registry_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the service registry. The currently supported service registry is AWS Cloud Map. For more information, see https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html
        """
        return pulumi.get(self, "registry_arn")


