/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Iterator;

public abstract class ImmutableConverter<ImmutableItem, Item> {
    protected abstract boolean isImmutable(Item var1);

    protected abstract ImmutableItem makeImmutable(Item var1);

    public ImmutableList<ImmutableItem> toList(Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return ImmutableList.of();
        }
        boolean needsCopy = false;
        if (iterable instanceof ImmutableList) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return (ImmutableList)iterable;
        }
        final Iterator<? extends Item> iter = iterable.iterator();
        return ImmutableList.copyOf(new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        });
    }

    public ImmutableSet<ImmutableItem> toSet(Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return ImmutableSet.of();
        }
        boolean needsCopy = false;
        if (iterable instanceof ImmutableSet) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return (ImmutableSet)iterable;
        }
        final Iterator<? extends Item> iter = iterable.iterator();
        return ImmutableSet.copyOf(new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        });
    }

    public ImmutableSortedSet<ImmutableItem> toSortedSet(Comparator<? super ImmutableItem> comparator, Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return ImmutableSortedSet.of();
        }
        boolean needsCopy = false;
        if (iterable instanceof ImmutableSortedSet && ((ImmutableSortedSet)iterable).comparator().equals(comparator)) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return (ImmutableSortedSet)iterable;
        }
        final Iterator<? extends Item> iter = iterable.iterator();
        return ImmutableSortedSet.copyOf(comparator, new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        });
    }
}

