/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.VersionMap;
import org.jf.dexlib2.dexbacked.CDexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBuffer;
import org.jf.dexlib2.dexbacked.raw.CdexHeaderItem;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;
import org.jf.util.StringUtils;

public class HeaderItem {
    private static final byte[] MAGIC_VALUE = new byte[]{100, 101, 120, 10, 0, 0, 0, 0};

    public static SectionAnnotator makeAnnotator(DexAnnotator annotator, MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            public String getItemName() {
                return "header_item";
            }

            @Override
            protected void annotateItem(AnnotatedBytes out, int itemIndex, String itemIdentity) {
                int startOffset = out.getCursor();
                StringBuilder magicBuilder = new StringBuilder();
                for (int i = 0; i < 8; ++i) {
                    magicBuilder.append((char)this.dexFile.getBuffer().readUbyte(startOffset + i));
                }
                out.annotate(8, "magic: %s", StringUtils.escapeString(magicBuilder.toString()));
                out.annotate(4, "checksum", new Object[0]);
                out.annotate(20, "signature", new Object[0]);
                out.annotate(4, "file_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                int headerSize = this.dexFile.getBuffer().readInt(out.getCursor());
                out.annotate(4, "header_size: %d", headerSize);
                int endianTag = this.dexFile.getBuffer().readInt(out.getCursor());
                out.annotate(4, "endian_tag: 0x%x (%s)", endianTag, HeaderItem.getEndianText(endianTag));
                out.annotate(4, "link_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "link_offset: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "map_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "string_ids_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "string_ids_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "type_ids_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "type_ids_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "proto_ids_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "proto_ids_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "field_ids_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "field_ids_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "method_ids_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "method_ids_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "class_defs_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "class_defs_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "data_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "data_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                if (this.annotator.dexFile instanceof CDexBackedDexFile) {
                    CdexHeaderItem.annotateCdexHeaderFields(out, this.dexFile.getBuffer());
                }
                if (headerSize > 112) {
                    out.annotateTo(headerSize, "header padding", new Object[0]);
                }
            }
        };
    }

    private static String getEndianText(int endianTag) {
        if (endianTag == 305419896) {
            return "Little Endian";
        }
        if (endianTag == 2018915346) {
            return "Big Endian";
        }
        return "Invalid";
    }

    public static boolean verifyMagic(byte[] buf, int offset) {
        int i;
        if (buf.length - offset < 8) {
            return false;
        }
        for (i = 0; i < 4; ++i) {
            if (buf[offset + i] == MAGIC_VALUE[i]) continue;
            return false;
        }
        for (i = 4; i < 7; ++i) {
            if (buf[offset + i] >= 48 && buf[offset + i] <= 57) continue;
            return false;
        }
        return buf[offset + 7] == MAGIC_VALUE[7];
    }

    public static int getVersion(byte[] buf, int offset) {
        if (!HeaderItem.verifyMagic(buf, offset)) {
            return -1;
        }
        return HeaderItem.getVersionUnchecked(buf, offset);
    }

    private static int getVersionUnchecked(byte[] buf, int offset) {
        int version = (buf[offset + 4] - 48) * 100;
        version += (buf[offset + 5] - 48) * 10;
        return version += buf[offset + 6] - 48;
    }

    public static boolean isSupportedDexVersion(int version) {
        return VersionMap.mapDexVersionToApi(version) != -1;
    }

    public static int getEndian(byte[] buf, int offset) {
        DexBuffer bdb = new DexBuffer(buf);
        return bdb.readInt(offset + 40);
    }
}

