/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.jf.baksmali.DexInputCommand;
import org.jf.baksmali.formatter.BaksmaliFormatter;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.util.jcommander.ExtendedParameters;

@Parameters(commandDescription="Lists the classes in a dex file.")
@ExtendedParameters(commandName="classes", commandAliases={"class", "c"})
public class ListClassesCommand
extends DexInputCommand {
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information")
    private boolean help;

    public ListClassesCommand(List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    @Override
    public void run() {
        if (this.help || this.inputList == null || this.inputList.isEmpty()) {
            this.usage();
            return;
        }
        if (this.inputList.size() > 1) {
            System.err.println("Too many files specified");
            this.usage();
            return;
        }
        String input = (String)this.inputList.get(0);
        this.loadDexFile(input);
        BaksmaliFormatter formatter = new BaksmaliFormatter();
        for (ClassDef classDef : this.dexFile.getClasses()) {
            System.out.println(formatter.getType(classDef.getType()));
        }
    }
}

