"""
Type annotations for neptune-graph service literal definitions.

[Documentation](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_neptune_graph/literals/)

Copyright 2025 Vlad Emelianov

Usage::

    ```python
    from mypy_boto3_neptune_graph.literals import BlankNodeHandlingType

    data: BlankNodeHandlingType = "convertToIri"
    ```
"""

import sys

if sys.version_info >= (3, 12):
    from typing import Literal
else:
    from typing_extensions import Literal


__all__ = (
    "BlankNodeHandlingType",
    "ExplainModeType",
    "ExportFormatType",
    "ExportTaskCancelledWaiterName",
    "ExportTaskStatusType",
    "ExportTaskSuccessfulWaiterName",
    "FormatType",
    "GraphAvailableWaiterName",
    "GraphDeletedWaiterName",
    "GraphSnapshotAvailableWaiterName",
    "GraphSnapshotDeletedWaiterName",
    "GraphStatusType",
    "GraphStoppedWaiterName",
    "GraphSummaryModeType",
    "ImportTaskCancelledWaiterName",
    "ImportTaskStatusType",
    "ImportTaskSuccessfulWaiterName",
    "ListExportTasksPaginatorName",
    "ListGraphSnapshotsPaginatorName",
    "ListGraphsPaginatorName",
    "ListImportTasksPaginatorName",
    "ListPrivateGraphEndpointsPaginatorName",
    "MultiValueHandlingTypeType",
    "NeptuneGraphServiceName",
    "PaginatorName",
    "ParquetTypeType",
    "PlanCacheTypeType",
    "PrivateGraphEndpointAvailableWaiterName",
    "PrivateGraphEndpointDeletedWaiterName",
    "PrivateGraphEndpointStatusType",
    "QueryLanguageType",
    "QueryStateInputType",
    "QueryStateType",
    "ResourceServiceName",
    "ServiceName",
    "SnapshotStatusType",
    "WaiterName",
)


BlankNodeHandlingType = Literal["convertToIri"]
ExplainModeType = Literal["DETAILS", "STATIC"]
ExportFormatType = Literal["CSV", "PARQUET"]
ExportTaskCancelledWaiterName = Literal["export_task_cancelled"]
ExportTaskStatusType = Literal[
    "CANCELLED", "CANCELLING", "DELETED", "EXPORTING", "FAILED", "INITIALIZING", "SUCCEEDED"
]
ExportTaskSuccessfulWaiterName = Literal["export_task_successful"]
FormatType = Literal["CSV", "NTRIPLES", "OPEN_CYPHER", "PARQUET"]
GraphAvailableWaiterName = Literal["graph_available"]
GraphDeletedWaiterName = Literal["graph_deleted"]
GraphSnapshotAvailableWaiterName = Literal["graph_snapshot_available"]
GraphSnapshotDeletedWaiterName = Literal["graph_snapshot_deleted"]
GraphStatusType = Literal[
    "AVAILABLE",
    "CREATING",
    "DELETING",
    "FAILED",
    "IMPORTING",
    "RESETTING",
    "SNAPSHOTTING",
    "STARTING",
    "STOPPED",
    "STOPPING",
    "UPDATING",
]
GraphStoppedWaiterName = Literal["graph_stopped"]
GraphSummaryModeType = Literal["BASIC", "DETAILED"]
ImportTaskCancelledWaiterName = Literal["import_task_cancelled"]
ImportTaskStatusType = Literal[
    "ANALYZING_DATA",
    "CANCELLED",
    "CANCELLING",
    "DELETED",
    "EXPORTING",
    "FAILED",
    "IMPORTING",
    "INITIALIZING",
    "REPROVISIONING",
    "ROLLING_BACK",
    "SUCCEEDED",
]
ImportTaskSuccessfulWaiterName = Literal["import_task_successful"]
ListExportTasksPaginatorName = Literal["list_export_tasks"]
ListGraphSnapshotsPaginatorName = Literal["list_graph_snapshots"]
ListGraphsPaginatorName = Literal["list_graphs"]
ListImportTasksPaginatorName = Literal["list_import_tasks"]
ListPrivateGraphEndpointsPaginatorName = Literal["list_private_graph_endpoints"]
MultiValueHandlingTypeType = Literal["PICK_FIRST", "TO_LIST"]
ParquetTypeType = Literal["COLUMNAR"]
PlanCacheTypeType = Literal["AUTO", "DISABLED", "ENABLED"]
PrivateGraphEndpointAvailableWaiterName = Literal["private_graph_endpoint_available"]
PrivateGraphEndpointDeletedWaiterName = Literal["private_graph_endpoint_deleted"]
PrivateGraphEndpointStatusType = Literal["AVAILABLE", "CREATING", "DELETING", "FAILED"]
QueryLanguageType = Literal["OPEN_CYPHER"]
QueryStateInputType = Literal["ALL", "CANCELLING", "RUNNING", "WAITING"]
QueryStateType = Literal["CANCELLING", "RUNNING", "WAITING"]
SnapshotStatusType = Literal["AVAILABLE", "CREATING", "DELETING", "FAILED"]
NeptuneGraphServiceName = Literal["neptune-graph"]
ServiceName = Literal[
    "accessanalyzer",
    "account",
    "acm",
    "acm-pca",
    "aiops",
    "amp",
    "amplify",
    "amplifybackend",
    "amplifyuibuilder",
    "apigateway",
    "apigatewaymanagementapi",
    "apigatewayv2",
    "appconfig",
    "appconfigdata",
    "appfabric",
    "appflow",
    "appintegrations",
    "application-autoscaling",
    "application-insights",
    "application-signals",
    "applicationcostprofiler",
    "appmesh",
    "apprunner",
    "appstream",
    "appsync",
    "arc-region-switch",
    "arc-zonal-shift",
    "artifact",
    "athena",
    "auditmanager",
    "autoscaling",
    "autoscaling-plans",
    "b2bi",
    "backup",
    "backup-gateway",
    "backupsearch",
    "batch",
    "bcm-dashboards",
    "bcm-data-exports",
    "bcm-pricing-calculator",
    "bcm-recommended-actions",
    "bedrock",
    "bedrock-agent",
    "bedrock-agent-runtime",
    "bedrock-agentcore",
    "bedrock-agentcore-control",
    "bedrock-data-automation",
    "bedrock-data-automation-runtime",
    "bedrock-runtime",
    "billing",
    "billingconductor",
    "braket",
    "budgets",
    "ce",
    "chatbot",
    "chime",
    "chime-sdk-identity",
    "chime-sdk-media-pipelines",
    "chime-sdk-meetings",
    "chime-sdk-messaging",
    "chime-sdk-voice",
    "cleanrooms",
    "cleanroomsml",
    "cloud9",
    "cloudcontrol",
    "clouddirectory",
    "cloudformation",
    "cloudfront",
    "cloudfront-keyvaluestore",
    "cloudhsm",
    "cloudhsmv2",
    "cloudsearch",
    "cloudsearchdomain",
    "cloudtrail",
    "cloudtrail-data",
    "cloudwatch",
    "codeartifact",
    "codebuild",
    "codecatalyst",
    "codecommit",
    "codeconnections",
    "codedeploy",
    "codeguru-reviewer",
    "codeguru-security",
    "codeguruprofiler",
    "codepipeline",
    "codestar-connections",
    "codestar-notifications",
    "cognito-identity",
    "cognito-idp",
    "cognito-sync",
    "comprehend",
    "comprehendmedical",
    "compute-optimizer",
    "compute-optimizer-automation",
    "config",
    "connect",
    "connect-contact-lens",
    "connectcampaigns",
    "connectcampaignsv2",
    "connectcases",
    "connectparticipant",
    "controlcatalog",
    "controltower",
    "cost-optimization-hub",
    "cur",
    "customer-profiles",
    "databrew",
    "dataexchange",
    "datapipeline",
    "datasync",
    "datazone",
    "dax",
    "deadline",
    "detective",
    "devicefarm",
    "devops-guru",
    "directconnect",
    "discovery",
    "dlm",
    "dms",
    "docdb",
    "docdb-elastic",
    "drs",
    "ds",
    "ds-data",
    "dsql",
    "dynamodb",
    "dynamodbstreams",
    "ebs",
    "ec2",
    "ec2-instance-connect",
    "ecr",
    "ecr-public",
    "ecs",
    "efs",
    "eks",
    "eks-auth",
    "elasticache",
    "elasticbeanstalk",
    "elastictranscoder",
    "elb",
    "elbv2",
    "emr",
    "emr-containers",
    "emr-serverless",
    "entityresolution",
    "es",
    "events",
    "evidently",
    "evs",
    "finspace",
    "finspace-data",
    "firehose",
    "fis",
    "fms",
    "forecast",
    "forecastquery",
    "frauddetector",
    "freetier",
    "fsx",
    "gamelift",
    "gameliftstreams",
    "geo-maps",
    "geo-places",
    "geo-routes",
    "glacier",
    "globalaccelerator",
    "glue",
    "grafana",
    "greengrass",
    "greengrassv2",
    "groundstation",
    "guardduty",
    "health",
    "healthlake",
    "iam",
    "identitystore",
    "imagebuilder",
    "importexport",
    "inspector",
    "inspector-scan",
    "inspector2",
    "internetmonitor",
    "invoicing",
    "iot",
    "iot-data",
    "iot-jobs-data",
    "iot-managed-integrations",
    "iotanalytics",
    "iotdeviceadvisor",
    "iotevents",
    "iotevents-data",
    "iotfleetwise",
    "iotsecuretunneling",
    "iotsitewise",
    "iotthingsgraph",
    "iottwinmaker",
    "iotwireless",
    "ivs",
    "ivs-realtime",
    "ivschat",
    "kafka",
    "kafkaconnect",
    "kendra",
    "kendra-ranking",
    "keyspaces",
    "keyspacesstreams",
    "kinesis",
    "kinesis-video-archived-media",
    "kinesis-video-media",
    "kinesis-video-signaling",
    "kinesis-video-webrtc-storage",
    "kinesisanalytics",
    "kinesisanalyticsv2",
    "kinesisvideo",
    "kms",
    "lakeformation",
    "lambda",
    "launch-wizard",
    "lex-models",
    "lex-runtime",
    "lexv2-models",
    "lexv2-runtime",
    "license-manager",
    "license-manager-linux-subscriptions",
    "license-manager-user-subscriptions",
    "lightsail",
    "location",
    "logs",
    "lookoutequipment",
    "m2",
    "machinelearning",
    "macie2",
    "mailmanager",
    "managedblockchain",
    "managedblockchain-query",
    "marketplace-agreement",
    "marketplace-catalog",
    "marketplace-deployment",
    "marketplace-entitlement",
    "marketplace-reporting",
    "marketplacecommerceanalytics",
    "mediaconnect",
    "mediaconvert",
    "medialive",
    "mediapackage",
    "mediapackage-vod",
    "mediapackagev2",
    "mediastore",
    "mediastore-data",
    "mediatailor",
    "medical-imaging",
    "memorydb",
    "meteringmarketplace",
    "mgh",
    "mgn",
    "migration-hub-refactor-spaces",
    "migrationhub-config",
    "migrationhuborchestrator",
    "migrationhubstrategy",
    "mpa",
    "mq",
    "mturk",
    "mwaa",
    "mwaa-serverless",
    "neptune",
    "neptune-graph",
    "neptunedata",
    "network-firewall",
    "networkflowmonitor",
    "networkmanager",
    "networkmonitor",
    "notifications",
    "notificationscontacts",
    "nova-act",
    "oam",
    "observabilityadmin",
    "odb",
    "omics",
    "opensearch",
    "opensearchserverless",
    "organizations",
    "osis",
    "outposts",
    "panorama",
    "partnercentral-account",
    "partnercentral-benefits",
    "partnercentral-channel",
    "partnercentral-selling",
    "payment-cryptography",
    "payment-cryptography-data",
    "pca-connector-ad",
    "pca-connector-scep",
    "pcs",
    "personalize",
    "personalize-events",
    "personalize-runtime",
    "pi",
    "pinpoint",
    "pinpoint-email",
    "pinpoint-sms-voice",
    "pinpoint-sms-voice-v2",
    "pipes",
    "polly",
    "pricing",
    "proton",
    "qapps",
    "qbusiness",
    "qconnect",
    "quicksight",
    "ram",
    "rbin",
    "rds",
    "rds-data",
    "redshift",
    "redshift-data",
    "redshift-serverless",
    "rekognition",
    "repostspace",
    "resiliencehub",
    "resource-explorer-2",
    "resource-groups",
    "resourcegroupstaggingapi",
    "rolesanywhere",
    "route53",
    "route53-recovery-cluster",
    "route53-recovery-control-config",
    "route53-recovery-readiness",
    "route53domains",
    "route53globalresolver",
    "route53profiles",
    "route53resolver",
    "rtbfabric",
    "rum",
    "s3",
    "s3control",
    "s3outposts",
    "s3tables",
    "s3vectors",
    "sagemaker",
    "sagemaker-a2i-runtime",
    "sagemaker-edge",
    "sagemaker-featurestore-runtime",
    "sagemaker-geospatial",
    "sagemaker-metrics",
    "sagemaker-runtime",
    "savingsplans",
    "scheduler",
    "schemas",
    "sdb",
    "secretsmanager",
    "security-ir",
    "securityhub",
    "securitylake",
    "serverlessrepo",
    "service-quotas",
    "servicecatalog",
    "servicecatalog-appregistry",
    "servicediscovery",
    "ses",
    "sesv2",
    "shield",
    "signer",
    "signin",
    "simspaceweaver",
    "snow-device-management",
    "snowball",
    "sns",
    "socialmessaging",
    "sqs",
    "ssm",
    "ssm-contacts",
    "ssm-guiconnect",
    "ssm-incidents",
    "ssm-quicksetup",
    "ssm-sap",
    "sso",
    "sso-admin",
    "sso-oidc",
    "stepfunctions",
    "storagegateway",
    "sts",
    "supplychain",
    "support",
    "support-app",
    "swf",
    "synthetics",
    "taxsettings",
    "textract",
    "timestream-influxdb",
    "timestream-query",
    "timestream-write",
    "tnb",
    "transcribe",
    "transfer",
    "translate",
    "trustedadvisor",
    "verifiedpermissions",
    "voice-id",
    "vpc-lattice",
    "waf",
    "waf-regional",
    "wafv2",
    "wellarchitected",
    "wisdom",
    "workdocs",
    "workmail",
    "workmailmessageflow",
    "workspaces",
    "workspaces-instances",
    "workspaces-thin-client",
    "workspaces-web",
    "xray",
]
ResourceServiceName = Literal[
    "cloudformation", "cloudwatch", "dynamodb", "ec2", "glacier", "iam", "s3", "sns", "sqs"
]
PaginatorName = Literal[
    "list_export_tasks",
    "list_graph_snapshots",
    "list_graphs",
    "list_import_tasks",
    "list_private_graph_endpoints",
]
WaiterName = Literal[
    "export_task_cancelled",
    "export_task_successful",
    "graph_available",
    "graph_deleted",
    "graph_snapshot_available",
    "graph_snapshot_deleted",
    "graph_stopped",
    "import_task_cancelled",
    "import_task_successful",
    "private_graph_endpoint_available",
    "private_graph_endpoint_deleted",
]
