# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_tidyfields']

package_data = \
{'': ['*']}

install_requires = \
['Django>=2.2', 'lxml==4.6.3']

extras_require = \
{'docs': ['sphinx>=4.2.0', 'sphinx-rtd-theme>=1.0.0'],
 'pylint': ['pylint==2.11.1', 'pylint-django==2.0.8']}

setup_kwargs = {
    'name': 'django-tidyfields',
    'version': '1.2.1',
    'description': 'Easily accept html input with Django models, templates and DRF serializers.',
    'long_description': '\n\n.. django_tidyfields documentation master file, created by startproject.\n   You can adapt this file completely to your liking, but it should at least\n   contain the root `toctree` directive.\n\n=================================================\nWelcome to django_tidyfields\'s documentation!\n=================================================\n\n:Version: 1.2.0\n:Source: https://gitlab.routh.io/python/django_tidyfields\n:Keywords: ``django`` ``lxml`` ``input`` ``html`` ``fields``\n:PythonVersion: 3.6+\n\n|build-status| |requirements| |coverage| |readthedocs|\n\n|python-versions| |django-versions| |pypi-version| |pypi-downloads|\n\nSanitise HTML input from API Endpoints or Views\n\n.. contents::\n\n.. section-numbering::\n\nFeatures\n========\n\n* Leverages the power of ``lxml`` to filter model fields\n* Supports input from any source as the filtering is triggered by model save\n\nInstallation\n============\n\nRequirements\n------------\n\n* Python 3.6 or above\n* setuptools 30.3.0 or above\n* Django 2.2 or above\n\n\nInstall\n-------\n\nInstall ``django_tidyfields`` via ``pip``:\n\n.. code-block:: bash\n\n   pip install django-tidyfields\n\nAdd Django TidyFields to ``INSTALLED_APPS``:\n\n.. code-block:: python\n\n   INSTALLED_APPS = [\n       # ...\n       \'django_tidyfields\',\n       # ...\n   ]\n\nConfigure\n---------\n\nThese fields pass the expected arguments for `lxml.html.clean.Cleaner` class through to the `Cleaner` instance directly. We will try to\nkeep the docs in line with the latest integrated lxml version, however these parameters are subject to change based on the\ndevelopment of lxml. More on `https://lxml.de <https://lxml.de/api/lxml.html.clean.Cleaner-class.html>`_\n\n\n\nUsage\n=====\n\nDjango TidyFields subclass the Django TextField and CharField classes, and take any parameters available to them.\n\nYou can optionally configure the field globally in your Django Settings:\n\n.. code-block:: python\n\n   """\n   Empty dict example, showing all parameters available, at their defaults.\n   """\n   TIDYFIELDS = {\n       \'processing_instructions\': True,\n       \'javascript\': True,\n       \'comments\': True,\n       \'style\': True,\n       \'allow_tags\': [],\n       \'remove_unknown_tags\': False,\n       \'kill_tags\': [\'script\', \'style\'],\n       \'safe_attrs_only\': True,\n       \'safe_attrs\': [],\n       \'add_nofollow\': True,\n       \'scripts\': True,\n       \'inline_style\': None,\n       \'links\': True,\n       \'meta\': True,\n       \'page_structure\': True,\n       \'embedded\': True,\n       \'frames\': True,\n       \'forms\': True,\n       \'annoying_tags\': True,\n       \'remove_tags\': None,\n       \'host_whitelist\': [],\n       \'whitelist_tags\': {}\n   }\n\n\nAnd you can override specific parameters for each model that uses Django TidyFields. Parameters not set here will inherit from\nthe global settings or from `lxml.html.clean.Cleaner` itself. Review the `lxml documentation <https://lxml.de/lxmlhtml.html#cleaning-up-html>`_\nfor the bleach default arguments.\n\n``models.py``:\n\n.. code-block:: python\n\n   """\n   A minimal Models.py usage example\n   """\n\n   from django.db.models import Model\n   from django_tidyfields.fields import TidyTextField, TidyCharField\n\n   class UserSubmission(Model):\n       title = TidyCharField()\n       description = TidyTextField()\n       body = TidyTextField()\n\n\nAdvanced Usage\n==============\n\nDjango TidyFields can be used however you like, but we recommend that your global defaults be a minimum\nallowed set of tags, or simply be setup to strip everything. If your project only allows HTML tags in certain\nTextFields for example, it implies that you\'ll have a number of CharFields and TextFields where you want HTML\nto be stripped out.\n\nYou can define allowed tags when defining a field directly in the model, however you may also define addition\ndefaults with unique variable names in your Django Settings, and use that var on any TextField that allows those\ntags. The fields check to see if any arguments are set in the `field_args` parameter, and only overrides the\ndefault arguments if you\'ve passed the same argument again. So you can use additive and subtractive magic to\nsimplify your code as much as possible. Just remember the Wizards Second Rule! (Especially when using subtractive\nmagic)\n\n    | “The Second Rule is that the greatest harm can result from the best intentions.  It sounds a paradox, but kindness and good intentions can be an insidious path to destruction. Sometimes doing what seems right is wrong and can cause harm.  The only counter to it is knowledge, wisdom, forethought, and understanding the First Rule.  Even then, that is not always enough.”\n    |\n    | *-- Zedd Zu\'l Zorander*\n    | *Stone of Tears, Terry Goodkind*\n\nAn Additive example\n-------------------\n\n``settings.py``:\n\n.. code-block:: python\n\n   """\n   Default dict that strips all HTML, with a permissive dict for certain fields.\n   """\n   TIDYFIELDS = {\n       \'processing_instructions\': True,\n       \'javascript\': True,\n       \'comments\': True,\n       \'style\': True,\n       \'allow_tags\': [\'\'],\n       \'remove_unknown_tags\': False,\n       \'kill_tags\': [\'script\', \'style\'],\n       \'safe_attrs_only\': True,\n       \'safe_attrs\': [\'\'],\n       \'add_nofollow\': True\n   }\n\n   PERMISSIVE_TIDYFIELDS = {\n       \'allow_tags\': [\'b\', \'em\', \'i\', \'strong\', \'span\', \'p\', \'pagebreak\'],\n       \'safe_attrs\': [\'style\'],\n       \'style\': False\n   }\n\n``models.py``:\n\n.. code-block:: python\n\n   """\n   A models.py usage example with Additive magic\n   """\n\n   from django.db.models import Model\n   from django.conf import settings\n   from django_tidyfields.fields import TidyTextField, TidyCharField\n\n   class UserSubmission(Model):\n       title = TidyCharField()\n       description = TidyTextField()\n       body = TidyTextField(field_args=settings.PERMISSIVE_TIDYFIELDS)\n\nHistory\n=======\n\nThis module was originally named Django-Bleachfields and was intended to be a spiritual successor to the now defunct django-bleachfield module. An alpha version had been uploaded to Pypi, however it has been pulled in favour of this module. During initial testing it was found that ``bleach`` only removes tags, the developers considering removal of the code within them being a concern of beutifying HTML rather than a security concern. It was found that this opened the door for some of the more creative XSS filter attacks. As a result, ``lxml`` was chosen to replace ``bleach`` in this module as it allows the complete removal of specified tags and their content.\n\nTesting\n=======\n\nThis module is tested to ensure it does not strip allowed HTML or CSS, but that it does strip XSS attacks or leaves them inert. Nearly 30 attacks from the `OWASP XSS Filter Evasion cheat sheet <https://www.owasp.org/index.php/XSS_Filter_Evasion_Cheat_Sheet>`_ are tested. More will be added in the next version.\n\nDisclaimer: Allowing javascript will compromise the XSS filtering. Do so with utmost caution and only give such priveledges to trusted persons.\n\n\n.. |build-status| image:: https://gitlab.routh.io/python/django_tidyfields/badges/master/pipeline.svg\n    :target: https://gitlab.routh.io/python/django_tidyfields/commits/master\n\n.. |requirements| image:: https://requires.io/enterprise/Routhinator/django_tidyfields/requirements.svg?branch=master\n    :target: https://requires.io/enterprise/Routhinator/django_tidyfields/requirements/?branch=master\n    :alt: Requirements status\n\n.. |coverage| image:: https://gitlab.routh.io/python/django_tidyfields/badges/master/coverage.svg\n    :target: http://python.pages.routh.io/django_tidyfields/\n    :alt: Coverage status\n\n.. |python-versions| image:: https://img.shields.io/pypi/pyversions/django_tidyfields.svg\n\n.. |django-versions| image:: https://img.shields.io/pypi/djversions/django_tidyfields.svg\n\n.. |pypi-version| image:: https://img.shields.io/pypi/v/django_tidyfields.svg\n    :target: https://pypi.org/project/django-tidyfields/\n\n.. |pypi-downloads| image:: https://pepy.tech/badge/django-tidyfields\n    :target: https://pepy.tech/project/django-tidyfields\n\n.. |readthedocs| image:: https://readthedocs.org/projects/django-tidyfields/badge/?version=latest\n    :target: https://django-tidyfields.readthedocs.io/en/latest/?badge=latest\n    :alt: Documentation Status\n',
    'author': 'Chris Routh',
    'author_email': 'chris@routh.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/routh.io/python/django_tidyfields',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6.1,<4.0',
}


setup(**setup_kwargs)
