# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApiKeyStageKey',
    'ApiKeyTag',
    'ClientCertificateTag',
    'DeploymentAccessLogSetting',
    'DeploymentCanarySetting',
    'DeploymentCanarySettings',
    'DeploymentMethodSetting',
    'DeploymentStageDescription',
    'DeploymentTag',
    'DocumentationPartLocation',
    'DomainNameEndpointConfiguration',
    'DomainNameMutualTlsAuthentication',
    'DomainNameTag',
    'MethodIntegration',
    'MethodIntegrationResponse',
    'MethodResponse',
    'RestApiEndpointConfiguration',
    'RestApiS3Location',
    'RestApiTag',
    'StageAccessLogSetting',
    'StageCanarySetting',
    'StageMethodSetting',
    'StageTag',
    'UsagePlanApiStage',
    'UsagePlanQuotaSettings',
    'UsagePlanTag',
    'UsagePlanThrottleSettings',
    'VpcLinkTag',
]

@pulumi.output_type
class ApiKeyStageKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restApiId":
            suggest = "rest_api_id"
        elif key == "stageName":
            suggest = "stage_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiKeyStageKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiKeyStageKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiKeyStageKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rest_api_id: Optional[str] = None,
                 stage_name: Optional[str] = None):
        """
        :param str rest_api_id: The ID of a RestApi resource that includes the stage with which you want to associate the API key.
        :param str stage_name: The name of the stage with which to associate the API key. The stage must be included in the RestApi resource that you specified in the RestApiId property. 
        """
        if rest_api_id is not None:
            pulumi.set(__self__, "rest_api_id", rest_api_id)
        if stage_name is not None:
            pulumi.set(__self__, "stage_name", stage_name)

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> Optional[str]:
        """
        The ID of a RestApi resource that includes the stage with which you want to associate the API key.
        """
        return pulumi.get(self, "rest_api_id")

    @property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> Optional[str]:
        """
        The name of the stage with which to associate the API key. The stage must be included in the RestApi resource that you specified in the RestApiId property. 
        """
        return pulumi.get(self, "stage_name")


@pulumi.output_type
class ApiKeyTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClientCertificateTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class DeploymentAccessLogSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationArn":
            suggest = "destination_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentAccessLogSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentAccessLogSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentAccessLogSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_arn: Optional[str] = None,
                 format: Optional[str] = None):
        if destination_arn is not None:
            pulumi.set(__self__, "destination_arn", destination_arn)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> Optional[str]:
        return pulumi.get(self, "destination_arn")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        return pulumi.get(self, "format")


@pulumi.output_type
class DeploymentCanarySetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "percentTraffic":
            suggest = "percent_traffic"
        elif key == "stageVariableOverrides":
            suggest = "stage_variable_overrides"
        elif key == "useStageCache":
            suggest = "use_stage_cache"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentCanarySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentCanarySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentCanarySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 percent_traffic: Optional[float] = None,
                 stage_variable_overrides: Optional[Any] = None,
                 use_stage_cache: Optional[bool] = None):
        if percent_traffic is not None:
            pulumi.set(__self__, "percent_traffic", percent_traffic)
        if stage_variable_overrides is not None:
            pulumi.set(__self__, "stage_variable_overrides", stage_variable_overrides)
        if use_stage_cache is not None:
            pulumi.set(__self__, "use_stage_cache", use_stage_cache)

    @property
    @pulumi.getter(name="percentTraffic")
    def percent_traffic(self) -> Optional[float]:
        return pulumi.get(self, "percent_traffic")

    @property
    @pulumi.getter(name="stageVariableOverrides")
    def stage_variable_overrides(self) -> Optional[Any]:
        return pulumi.get(self, "stage_variable_overrides")

    @property
    @pulumi.getter(name="useStageCache")
    def use_stage_cache(self) -> Optional[bool]:
        return pulumi.get(self, "use_stage_cache")


@pulumi.output_type
class DeploymentCanarySettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "percentTraffic":
            suggest = "percent_traffic"
        elif key == "stageVariableOverrides":
            suggest = "stage_variable_overrides"
        elif key == "useStageCache":
            suggest = "use_stage_cache"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentCanarySettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentCanarySettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentCanarySettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 percent_traffic: Optional[float] = None,
                 stage_variable_overrides: Optional[Any] = None,
                 use_stage_cache: Optional[bool] = None):
        if percent_traffic is not None:
            pulumi.set(__self__, "percent_traffic", percent_traffic)
        if stage_variable_overrides is not None:
            pulumi.set(__self__, "stage_variable_overrides", stage_variable_overrides)
        if use_stage_cache is not None:
            pulumi.set(__self__, "use_stage_cache", use_stage_cache)

    @property
    @pulumi.getter(name="percentTraffic")
    def percent_traffic(self) -> Optional[float]:
        return pulumi.get(self, "percent_traffic")

    @property
    @pulumi.getter(name="stageVariableOverrides")
    def stage_variable_overrides(self) -> Optional[Any]:
        return pulumi.get(self, "stage_variable_overrides")

    @property
    @pulumi.getter(name="useStageCache")
    def use_stage_cache(self) -> Optional[bool]:
        return pulumi.get(self, "use_stage_cache")


@pulumi.output_type
class DeploymentMethodSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheDataEncrypted":
            suggest = "cache_data_encrypted"
        elif key == "cacheTtlInSeconds":
            suggest = "cache_ttl_in_seconds"
        elif key == "cachingEnabled":
            suggest = "caching_enabled"
        elif key == "dataTraceEnabled":
            suggest = "data_trace_enabled"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "loggingLevel":
            suggest = "logging_level"
        elif key == "metricsEnabled":
            suggest = "metrics_enabled"
        elif key == "resourcePath":
            suggest = "resource_path"
        elif key == "throttlingBurstLimit":
            suggest = "throttling_burst_limit"
        elif key == "throttlingRateLimit":
            suggest = "throttling_rate_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentMethodSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentMethodSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentMethodSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_data_encrypted: Optional[bool] = None,
                 cache_ttl_in_seconds: Optional[int] = None,
                 caching_enabled: Optional[bool] = None,
                 data_trace_enabled: Optional[bool] = None,
                 http_method: Optional[str] = None,
                 logging_level: Optional[str] = None,
                 metrics_enabled: Optional[bool] = None,
                 resource_path: Optional[str] = None,
                 throttling_burst_limit: Optional[int] = None,
                 throttling_rate_limit: Optional[float] = None):
        if cache_data_encrypted is not None:
            pulumi.set(__self__, "cache_data_encrypted", cache_data_encrypted)
        if cache_ttl_in_seconds is not None:
            pulumi.set(__self__, "cache_ttl_in_seconds", cache_ttl_in_seconds)
        if caching_enabled is not None:
            pulumi.set(__self__, "caching_enabled", caching_enabled)
        if data_trace_enabled is not None:
            pulumi.set(__self__, "data_trace_enabled", data_trace_enabled)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if metrics_enabled is not None:
            pulumi.set(__self__, "metrics_enabled", metrics_enabled)
        if resource_path is not None:
            pulumi.set(__self__, "resource_path", resource_path)
        if throttling_burst_limit is not None:
            pulumi.set(__self__, "throttling_burst_limit", throttling_burst_limit)
        if throttling_rate_limit is not None:
            pulumi.set(__self__, "throttling_rate_limit", throttling_rate_limit)

    @property
    @pulumi.getter(name="cacheDataEncrypted")
    def cache_data_encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "cache_data_encrypted")

    @property
    @pulumi.getter(name="cacheTtlInSeconds")
    def cache_ttl_in_seconds(self) -> Optional[int]:
        return pulumi.get(self, "cache_ttl_in_seconds")

    @property
    @pulumi.getter(name="cachingEnabled")
    def caching_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "caching_enabled")

    @property
    @pulumi.getter(name="dataTraceEnabled")
    def data_trace_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "data_trace_enabled")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[str]:
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[str]:
        return pulumi.get(self, "logging_level")

    @property
    @pulumi.getter(name="metricsEnabled")
    def metrics_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "metrics_enabled")

    @property
    @pulumi.getter(name="resourcePath")
    def resource_path(self) -> Optional[str]:
        return pulumi.get(self, "resource_path")

    @property
    @pulumi.getter(name="throttlingBurstLimit")
    def throttling_burst_limit(self) -> Optional[int]:
        return pulumi.get(self, "throttling_burst_limit")

    @property
    @pulumi.getter(name="throttlingRateLimit")
    def throttling_rate_limit(self) -> Optional[float]:
        return pulumi.get(self, "throttling_rate_limit")


@pulumi.output_type
class DeploymentStageDescription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLogSetting":
            suggest = "access_log_setting"
        elif key == "cacheClusterEnabled":
            suggest = "cache_cluster_enabled"
        elif key == "cacheClusterSize":
            suggest = "cache_cluster_size"
        elif key == "cacheDataEncrypted":
            suggest = "cache_data_encrypted"
        elif key == "cacheTtlInSeconds":
            suggest = "cache_ttl_in_seconds"
        elif key == "cachingEnabled":
            suggest = "caching_enabled"
        elif key == "canarySetting":
            suggest = "canary_setting"
        elif key == "clientCertificateId":
            suggest = "client_certificate_id"
        elif key == "dataTraceEnabled":
            suggest = "data_trace_enabled"
        elif key == "documentationVersion":
            suggest = "documentation_version"
        elif key == "loggingLevel":
            suggest = "logging_level"
        elif key == "methodSettings":
            suggest = "method_settings"
        elif key == "metricsEnabled":
            suggest = "metrics_enabled"
        elif key == "throttlingBurstLimit":
            suggest = "throttling_burst_limit"
        elif key == "throttlingRateLimit":
            suggest = "throttling_rate_limit"
        elif key == "tracingEnabled":
            suggest = "tracing_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentStageDescription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentStageDescription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentStageDescription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_log_setting: Optional['outputs.DeploymentAccessLogSetting'] = None,
                 cache_cluster_enabled: Optional[bool] = None,
                 cache_cluster_size: Optional[str] = None,
                 cache_data_encrypted: Optional[bool] = None,
                 cache_ttl_in_seconds: Optional[int] = None,
                 caching_enabled: Optional[bool] = None,
                 canary_setting: Optional['outputs.DeploymentCanarySetting'] = None,
                 client_certificate_id: Optional[str] = None,
                 data_trace_enabled: Optional[bool] = None,
                 description: Optional[str] = None,
                 documentation_version: Optional[str] = None,
                 logging_level: Optional[str] = None,
                 method_settings: Optional[Sequence['outputs.DeploymentMethodSetting']] = None,
                 metrics_enabled: Optional[bool] = None,
                 tags: Optional[Sequence['outputs.DeploymentTag']] = None,
                 throttling_burst_limit: Optional[int] = None,
                 throttling_rate_limit: Optional[float] = None,
                 tracing_enabled: Optional[bool] = None,
                 variables: Optional[Any] = None):
        if access_log_setting is not None:
            pulumi.set(__self__, "access_log_setting", access_log_setting)
        if cache_cluster_enabled is not None:
            pulumi.set(__self__, "cache_cluster_enabled", cache_cluster_enabled)
        if cache_cluster_size is not None:
            pulumi.set(__self__, "cache_cluster_size", cache_cluster_size)
        if cache_data_encrypted is not None:
            pulumi.set(__self__, "cache_data_encrypted", cache_data_encrypted)
        if cache_ttl_in_seconds is not None:
            pulumi.set(__self__, "cache_ttl_in_seconds", cache_ttl_in_seconds)
        if caching_enabled is not None:
            pulumi.set(__self__, "caching_enabled", caching_enabled)
        if canary_setting is not None:
            pulumi.set(__self__, "canary_setting", canary_setting)
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if data_trace_enabled is not None:
            pulumi.set(__self__, "data_trace_enabled", data_trace_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if documentation_version is not None:
            pulumi.set(__self__, "documentation_version", documentation_version)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if method_settings is not None:
            pulumi.set(__self__, "method_settings", method_settings)
        if metrics_enabled is not None:
            pulumi.set(__self__, "metrics_enabled", metrics_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throttling_burst_limit is not None:
            pulumi.set(__self__, "throttling_burst_limit", throttling_burst_limit)
        if throttling_rate_limit is not None:
            pulumi.set(__self__, "throttling_rate_limit", throttling_rate_limit)
        if tracing_enabled is not None:
            pulumi.set(__self__, "tracing_enabled", tracing_enabled)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="accessLogSetting")
    def access_log_setting(self) -> Optional['outputs.DeploymentAccessLogSetting']:
        return pulumi.get(self, "access_log_setting")

    @property
    @pulumi.getter(name="cacheClusterEnabled")
    def cache_cluster_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "cache_cluster_enabled")

    @property
    @pulumi.getter(name="cacheClusterSize")
    def cache_cluster_size(self) -> Optional[str]:
        return pulumi.get(self, "cache_cluster_size")

    @property
    @pulumi.getter(name="cacheDataEncrypted")
    def cache_data_encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "cache_data_encrypted")

    @property
    @pulumi.getter(name="cacheTtlInSeconds")
    def cache_ttl_in_seconds(self) -> Optional[int]:
        return pulumi.get(self, "cache_ttl_in_seconds")

    @property
    @pulumi.getter(name="cachingEnabled")
    def caching_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "caching_enabled")

    @property
    @pulumi.getter(name="canarySetting")
    def canary_setting(self) -> Optional['outputs.DeploymentCanarySetting']:
        return pulumi.get(self, "canary_setting")

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[str]:
        return pulumi.get(self, "client_certificate_id")

    @property
    @pulumi.getter(name="dataTraceEnabled")
    def data_trace_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "data_trace_enabled")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="documentationVersion")
    def documentation_version(self) -> Optional[str]:
        return pulumi.get(self, "documentation_version")

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[str]:
        return pulumi.get(self, "logging_level")

    @property
    @pulumi.getter(name="methodSettings")
    def method_settings(self) -> Optional[Sequence['outputs.DeploymentMethodSetting']]:
        return pulumi.get(self, "method_settings")

    @property
    @pulumi.getter(name="metricsEnabled")
    def metrics_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "metrics_enabled")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.DeploymentTag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="throttlingBurstLimit")
    def throttling_burst_limit(self) -> Optional[int]:
        return pulumi.get(self, "throttling_burst_limit")

    @property
    @pulumi.getter(name="throttlingRateLimit")
    def throttling_rate_limit(self) -> Optional[float]:
        return pulumi.get(self, "throttling_rate_limit")

    @property
    @pulumi.getter(name="tracingEnabled")
    def tracing_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "tracing_enabled")

    @property
    @pulumi.getter
    def variables(self) -> Optional[Any]:
        return pulumi.get(self, "variables")


@pulumi.output_type
class DeploymentTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class DocumentationPartLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentationPartLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentationPartLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentationPartLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: Optional[str] = None,
                 name: Optional[str] = None,
                 path: Optional[str] = None,
                 status_code: Optional[str] = None,
                 type: Optional[str] = None):
        if method is not None:
            pulumi.set(__self__, "method", method)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[str]:
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class DomainNameEndpointConfiguration(dict):
    def __init__(__self__, *,
                 types: Optional[Sequence[str]] = None):
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "types")


@pulumi.output_type
class DomainNameMutualTlsAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "truststoreUri":
            suggest = "truststore_uri"
        elif key == "truststoreVersion":
            suggest = "truststore_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainNameMutualTlsAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainNameMutualTlsAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainNameMutualTlsAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 truststore_uri: Optional[str] = None,
                 truststore_version: Optional[str] = None):
        if truststore_uri is not None:
            pulumi.set(__self__, "truststore_uri", truststore_uri)
        if truststore_version is not None:
            pulumi.set(__self__, "truststore_version", truststore_version)

    @property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> Optional[str]:
        return pulumi.get(self, "truststore_uri")

    @property
    @pulumi.getter(name="truststoreVersion")
    def truststore_version(self) -> Optional[str]:
        return pulumi.get(self, "truststore_version")


@pulumi.output_type
class DomainNameTag(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class MethodIntegration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheKeyParameters":
            suggest = "cache_key_parameters"
        elif key == "cacheNamespace":
            suggest = "cache_namespace"
        elif key == "connectionId":
            suggest = "connection_id"
        elif key == "connectionType":
            suggest = "connection_type"
        elif key == "contentHandling":
            suggest = "content_handling"
        elif key == "integrationHttpMethod":
            suggest = "integration_http_method"
        elif key == "integrationResponses":
            suggest = "integration_responses"
        elif key == "passthroughBehavior":
            suggest = "passthrough_behavior"
        elif key == "requestParameters":
            suggest = "request_parameters"
        elif key == "requestTemplates":
            suggest = "request_templates"
        elif key == "timeoutInMillis":
            suggest = "timeout_in_millis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MethodIntegration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MethodIntegration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MethodIntegration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'MethodIntegrationType',
                 cache_key_parameters: Optional[Sequence[str]] = None,
                 cache_namespace: Optional[str] = None,
                 connection_id: Optional[str] = None,
                 connection_type: Optional['MethodIntegrationConnectionType'] = None,
                 content_handling: Optional['MethodIntegrationContentHandling'] = None,
                 credentials: Optional[str] = None,
                 integration_http_method: Optional[str] = None,
                 integration_responses: Optional[Sequence['outputs.MethodIntegrationResponse']] = None,
                 passthrough_behavior: Optional['MethodIntegrationPassthroughBehavior'] = None,
                 request_parameters: Optional[Any] = None,
                 request_templates: Optional[Any] = None,
                 timeout_in_millis: Optional[int] = None,
                 uri: Optional[str] = None):
        """
        :param 'MethodIntegrationType' type: The type of backend that your method is running.
        :param Sequence[str] cache_key_parameters: A list of request parameters whose values API Gateway caches.
        :param str cache_namespace: An API-specific tag group of related cached parameters.
        :param str connection_id: The ID of the VpcLink used for the integration when connectionType=VPC_LINK, otherwise undefined.
        :param 'MethodIntegrationConnectionType' connection_type: The type of the network connection to the integration endpoint.
        :param 'MethodIntegrationContentHandling' content_handling: Specifies how to handle request payload content type conversions.
        :param str credentials: The credentials that are required for the integration.
        :param str integration_http_method: The integration's HTTP method type.
        :param Sequence['MethodIntegrationResponse'] integration_responses: The response that API Gateway provides after a method's backend completes processing a request.
        :param 'MethodIntegrationPassthroughBehavior' passthrough_behavior: Indicates when API Gateway passes requests to the targeted backend.
        :param Any request_parameters: The request parameters that API Gateway sends with the backend request.
        :param Any request_templates: A map of Apache Velocity templates that are applied on the request payload.
        :param int timeout_in_millis: Custom timeout between 50 and 29,000 milliseconds.
        :param str uri: The Uniform Resource Identifier (URI) for the integration.
        """
        pulumi.set(__self__, "type", type)
        if cache_key_parameters is not None:
            pulumi.set(__self__, "cache_key_parameters", cache_key_parameters)
        if cache_namespace is not None:
            pulumi.set(__self__, "cache_namespace", cache_namespace)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if content_handling is not None:
            pulumi.set(__self__, "content_handling", content_handling)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if integration_http_method is not None:
            pulumi.set(__self__, "integration_http_method", integration_http_method)
        if integration_responses is not None:
            pulumi.set(__self__, "integration_responses", integration_responses)
        if passthrough_behavior is not None:
            pulumi.set(__self__, "passthrough_behavior", passthrough_behavior)
        if request_parameters is not None:
            pulumi.set(__self__, "request_parameters", request_parameters)
        if request_templates is not None:
            pulumi.set(__self__, "request_templates", request_templates)
        if timeout_in_millis is not None:
            pulumi.set(__self__, "timeout_in_millis", timeout_in_millis)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def type(self) -> 'MethodIntegrationType':
        """
        The type of backend that your method is running.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="cacheKeyParameters")
    def cache_key_parameters(self) -> Optional[Sequence[str]]:
        """
        A list of request parameters whose values API Gateway caches.
        """
        return pulumi.get(self, "cache_key_parameters")

    @property
    @pulumi.getter(name="cacheNamespace")
    def cache_namespace(self) -> Optional[str]:
        """
        An API-specific tag group of related cached parameters.
        """
        return pulumi.get(self, "cache_namespace")

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[str]:
        """
        The ID of the VpcLink used for the integration when connectionType=VPC_LINK, otherwise undefined.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional['MethodIntegrationConnectionType']:
        """
        The type of the network connection to the integration endpoint.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="contentHandling")
    def content_handling(self) -> Optional['MethodIntegrationContentHandling']:
        """
        Specifies how to handle request payload content type conversions.
        """
        return pulumi.get(self, "content_handling")

    @property
    @pulumi.getter
    def credentials(self) -> Optional[str]:
        """
        The credentials that are required for the integration.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="integrationHttpMethod")
    def integration_http_method(self) -> Optional[str]:
        """
        The integration's HTTP method type.
        """
        return pulumi.get(self, "integration_http_method")

    @property
    @pulumi.getter(name="integrationResponses")
    def integration_responses(self) -> Optional[Sequence['outputs.MethodIntegrationResponse']]:
        """
        The response that API Gateway provides after a method's backend completes processing a request.
        """
        return pulumi.get(self, "integration_responses")

    @property
    @pulumi.getter(name="passthroughBehavior")
    def passthrough_behavior(self) -> Optional['MethodIntegrationPassthroughBehavior']:
        """
        Indicates when API Gateway passes requests to the targeted backend.
        """
        return pulumi.get(self, "passthrough_behavior")

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[Any]:
        """
        The request parameters that API Gateway sends with the backend request.
        """
        return pulumi.get(self, "request_parameters")

    @property
    @pulumi.getter(name="requestTemplates")
    def request_templates(self) -> Optional[Any]:
        """
        A map of Apache Velocity templates that are applied on the request payload.
        """
        return pulumi.get(self, "request_templates")

    @property
    @pulumi.getter(name="timeoutInMillis")
    def timeout_in_millis(self) -> Optional[int]:
        """
        Custom timeout between 50 and 29,000 milliseconds.
        """
        return pulumi.get(self, "timeout_in_millis")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        The Uniform Resource Identifier (URI) for the integration.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class MethodIntegrationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"
        elif key == "contentHandling":
            suggest = "content_handling"
        elif key == "responseParameters":
            suggest = "response_parameters"
        elif key == "responseTemplates":
            suggest = "response_templates"
        elif key == "selectionPattern":
            suggest = "selection_pattern"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MethodIntegrationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MethodIntegrationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MethodIntegrationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_code: str,
                 content_handling: Optional['MethodIntegrationResponseContentHandling'] = None,
                 response_parameters: Optional[Any] = None,
                 response_templates: Optional[Any] = None,
                 selection_pattern: Optional[str] = None):
        """
        :param str status_code: The status code that API Gateway uses to map the integration response to a MethodResponse status code.
        :param 'MethodIntegrationResponseContentHandling' content_handling: Specifies how to handle request payload content type conversions.
        :param Any response_parameters: The response parameters from the backend response that API Gateway sends to the method response.
        :param Any response_templates: The templates that are used to transform the integration response body. Specify templates as key-value pairs (string-to-string mappings), with a content type as the key and a template as the value.
        :param str selection_pattern: A regular expression that specifies which error strings or status codes from the backend map to the integration response.
        """
        pulumi.set(__self__, "status_code", status_code)
        if content_handling is not None:
            pulumi.set(__self__, "content_handling", content_handling)
        if response_parameters is not None:
            pulumi.set(__self__, "response_parameters", response_parameters)
        if response_templates is not None:
            pulumi.set(__self__, "response_templates", response_templates)
        if selection_pattern is not None:
            pulumi.set(__self__, "selection_pattern", selection_pattern)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> str:
        """
        The status code that API Gateway uses to map the integration response to a MethodResponse status code.
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter(name="contentHandling")
    def content_handling(self) -> Optional['MethodIntegrationResponseContentHandling']:
        """
        Specifies how to handle request payload content type conversions.
        """
        return pulumi.get(self, "content_handling")

    @property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> Optional[Any]:
        """
        The response parameters from the backend response that API Gateway sends to the method response.
        """
        return pulumi.get(self, "response_parameters")

    @property
    @pulumi.getter(name="responseTemplates")
    def response_templates(self) -> Optional[Any]:
        """
        The templates that are used to transform the integration response body. Specify templates as key-value pairs (string-to-string mappings), with a content type as the key and a template as the value.
        """
        return pulumi.get(self, "response_templates")

    @property
    @pulumi.getter(name="selectionPattern")
    def selection_pattern(self) -> Optional[str]:
        """
        A regular expression that specifies which error strings or status codes from the backend map to the integration response.
        """
        return pulumi.get(self, "selection_pattern")


@pulumi.output_type
class MethodResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"
        elif key == "responseModels":
            suggest = "response_models"
        elif key == "responseParameters":
            suggest = "response_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MethodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MethodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MethodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_code: str,
                 response_models: Optional[Any] = None,
                 response_parameters: Optional[Any] = None):
        """
        :param str status_code: The method response's status code, which you map to an IntegrationResponse.
        :param Any response_models: The resources used for the response's content type. Specify response models as key-value pairs (string-to-string maps), with a content type as the key and a Model resource name as the value.
        :param Any response_parameters: Response parameters that API Gateway sends to the client that called a method. Specify response parameters as key-value pairs (string-to-Boolean maps), with a destination as the key and a Boolean as the value.
        """
        pulumi.set(__self__, "status_code", status_code)
        if response_models is not None:
            pulumi.set(__self__, "response_models", response_models)
        if response_parameters is not None:
            pulumi.set(__self__, "response_parameters", response_parameters)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> str:
        """
        The method response's status code, which you map to an IntegrationResponse.
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter(name="responseModels")
    def response_models(self) -> Optional[Any]:
        """
        The resources used for the response's content type. Specify response models as key-value pairs (string-to-string maps), with a content type as the key and a Model resource name as the value.
        """
        return pulumi.get(self, "response_models")

    @property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> Optional[Any]:
        """
        Response parameters that API Gateway sends to the client that called a method. Specify response parameters as key-value pairs (string-to-Boolean maps), with a destination as the key and a Boolean as the value.
        """
        return pulumi.get(self, "response_parameters")


@pulumi.output_type
class RestApiEndpointConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcEndpointIds":
            suggest = "vpc_endpoint_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestApiEndpointConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestApiEndpointConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestApiEndpointConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 types: Optional[Sequence[str]] = None,
                 vpc_endpoint_ids: Optional[Sequence[str]] = None):
        if types is not None:
            pulumi.set(__self__, "types", types)
        if vpc_endpoint_ids is not None:
            pulumi.set(__self__, "vpc_endpoint_ids", vpc_endpoint_ids)

    @property
    @pulumi.getter
    def types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "types")

    @property
    @pulumi.getter(name="vpcEndpointIds")
    def vpc_endpoint_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "vpc_endpoint_ids")


@pulumi.output_type
class RestApiS3Location(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eTag":
            suggest = "e_tag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestApiS3Location. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestApiS3Location.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestApiS3Location.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 e_tag: Optional[str] = None,
                 key: Optional[str] = None,
                 version: Optional[str] = None):
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if e_tag is not None:
            pulumi.set(__self__, "e_tag", e_tag)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[str]:
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class RestApiTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class StageAccessLogSetting(dict):
    """
    Specifies settings for logging access in this stage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationArn":
            suggest = "destination_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StageAccessLogSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StageAccessLogSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StageAccessLogSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_arn: Optional[str] = None,
                 format: Optional[str] = None):
        """
        Specifies settings for logging access in this stage.
        :param str destination_arn: The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with amazon-apigateway-. This parameter is required to enable access logging.
        :param str format: A single line format of the access logs of data, as specified by selected $context variables (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference). The format must include at least $context.requestId. This parameter is required to enable access logging.
        """
        if destination_arn is not None:
            pulumi.set(__self__, "destination_arn", destination_arn)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with amazon-apigateway-. This parameter is required to enable access logging.
        """
        return pulumi.get(self, "destination_arn")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        A single line format of the access logs of data, as specified by selected $context variables (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference). The format must include at least $context.requestId. This parameter is required to enable access logging.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class StageCanarySetting(dict):
    """
    Specifies settings for the canary deployment in this stage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentId":
            suggest = "deployment_id"
        elif key == "percentTraffic":
            suggest = "percent_traffic"
        elif key == "stageVariableOverrides":
            suggest = "stage_variable_overrides"
        elif key == "useStageCache":
            suggest = "use_stage_cache"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StageCanarySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StageCanarySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StageCanarySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_id: Optional[str] = None,
                 percent_traffic: Optional[float] = None,
                 stage_variable_overrides: Optional[Any] = None,
                 use_stage_cache: Optional[bool] = None):
        """
        Specifies settings for the canary deployment in this stage.
        :param str deployment_id: The identifier of the deployment that the stage points to.
        :param float percent_traffic: The percentage (0-100) of traffic diverted to a canary deployment.
        :param Any stage_variable_overrides: Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.
        :param bool use_stage_cache: Whether the canary deployment uses the stage cache or not.
        """
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if percent_traffic is not None:
            pulumi.set(__self__, "percent_traffic", percent_traffic)
        if stage_variable_overrides is not None:
            pulumi.set(__self__, "stage_variable_overrides", stage_variable_overrides)
        if use_stage_cache is not None:
            pulumi.set(__self__, "use_stage_cache", use_stage_cache)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[str]:
        """
        The identifier of the deployment that the stage points to.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="percentTraffic")
    def percent_traffic(self) -> Optional[float]:
        """
        The percentage (0-100) of traffic diverted to a canary deployment.
        """
        return pulumi.get(self, "percent_traffic")

    @property
    @pulumi.getter(name="stageVariableOverrides")
    def stage_variable_overrides(self) -> Optional[Any]:
        """
        Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.
        """
        return pulumi.get(self, "stage_variable_overrides")

    @property
    @pulumi.getter(name="useStageCache")
    def use_stage_cache(self) -> Optional[bool]:
        """
        Whether the canary deployment uses the stage cache or not.
        """
        return pulumi.get(self, "use_stage_cache")


@pulumi.output_type
class StageMethodSetting(dict):
    """
    Configures settings for all methods in a stage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheDataEncrypted":
            suggest = "cache_data_encrypted"
        elif key == "cacheTtlInSeconds":
            suggest = "cache_ttl_in_seconds"
        elif key == "cachingEnabled":
            suggest = "caching_enabled"
        elif key == "dataTraceEnabled":
            suggest = "data_trace_enabled"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "loggingLevel":
            suggest = "logging_level"
        elif key == "metricsEnabled":
            suggest = "metrics_enabled"
        elif key == "resourcePath":
            suggest = "resource_path"
        elif key == "throttlingBurstLimit":
            suggest = "throttling_burst_limit"
        elif key == "throttlingRateLimit":
            suggest = "throttling_rate_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StageMethodSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StageMethodSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StageMethodSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_data_encrypted: Optional[bool] = None,
                 cache_ttl_in_seconds: Optional[int] = None,
                 caching_enabled: Optional[bool] = None,
                 data_trace_enabled: Optional[bool] = None,
                 http_method: Optional[str] = None,
                 logging_level: Optional[str] = None,
                 metrics_enabled: Optional[bool] = None,
                 resource_path: Optional[str] = None,
                 throttling_burst_limit: Optional[int] = None,
                 throttling_rate_limit: Optional[float] = None):
        """
        Configures settings for all methods in a stage.
        :param bool cache_data_encrypted: Indicates whether the cached responses are encrypted.
        :param int cache_ttl_in_seconds: The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches responses.
        :param bool caching_enabled: Indicates whether responses are cached and returned for requests. You must enable a cache cluster on the stage to cache responses.
        :param bool data_trace_enabled: Indicates whether data trace logging is enabled for methods in the stage. API Gateway pushes these logs to Amazon CloudWatch Logs.
        :param str http_method: The HTTP method. You can use an asterisk (*) as a wildcard to apply method settings to multiple methods.
        :param str logging_level: The logging level for this method. For valid values, see the loggingLevel property of the Stage (https://docs.aws.amazon.com/apigateway/api-reference/resource/stage/#loggingLevel) resource in the Amazon API Gateway API Reference.
        :param bool metrics_enabled: Indicates whether Amazon CloudWatch metrics are enabled for methods in the stage.
        :param str resource_path: The resource path for this method. Forward slashes (/) are encoded as ~1 and the initial slash must include a forward slash. For example, the path value /resource/subresource must be encoded as /~1resource~1subresource. To specify the root path, use only a slash (/). You can use an asterisk (*) as a wildcard to apply method settings to multiple methods.
        :param int throttling_burst_limit: The number of burst requests per second that API Gateway permits across all APIs, stages, and methods in your AWS account.
        :param float throttling_rate_limit: The number of steady-state requests per second that API Gateway permits across all APIs, stages, and methods in your AWS account.
        """
        if cache_data_encrypted is not None:
            pulumi.set(__self__, "cache_data_encrypted", cache_data_encrypted)
        if cache_ttl_in_seconds is not None:
            pulumi.set(__self__, "cache_ttl_in_seconds", cache_ttl_in_seconds)
        if caching_enabled is not None:
            pulumi.set(__self__, "caching_enabled", caching_enabled)
        if data_trace_enabled is not None:
            pulumi.set(__self__, "data_trace_enabled", data_trace_enabled)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if metrics_enabled is not None:
            pulumi.set(__self__, "metrics_enabled", metrics_enabled)
        if resource_path is not None:
            pulumi.set(__self__, "resource_path", resource_path)
        if throttling_burst_limit is not None:
            pulumi.set(__self__, "throttling_burst_limit", throttling_burst_limit)
        if throttling_rate_limit is not None:
            pulumi.set(__self__, "throttling_rate_limit", throttling_rate_limit)

    @property
    @pulumi.getter(name="cacheDataEncrypted")
    def cache_data_encrypted(self) -> Optional[bool]:
        """
        Indicates whether the cached responses are encrypted.
        """
        return pulumi.get(self, "cache_data_encrypted")

    @property
    @pulumi.getter(name="cacheTtlInSeconds")
    def cache_ttl_in_seconds(self) -> Optional[int]:
        """
        The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches responses.
        """
        return pulumi.get(self, "cache_ttl_in_seconds")

    @property
    @pulumi.getter(name="cachingEnabled")
    def caching_enabled(self) -> Optional[bool]:
        """
        Indicates whether responses are cached and returned for requests. You must enable a cache cluster on the stage to cache responses.
        """
        return pulumi.get(self, "caching_enabled")

    @property
    @pulumi.getter(name="dataTraceEnabled")
    def data_trace_enabled(self) -> Optional[bool]:
        """
        Indicates whether data trace logging is enabled for methods in the stage. API Gateway pushes these logs to Amazon CloudWatch Logs.
        """
        return pulumi.get(self, "data_trace_enabled")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[str]:
        """
        The HTTP method. You can use an asterisk (*) as a wildcard to apply method settings to multiple methods.
        """
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[str]:
        """
        The logging level for this method. For valid values, see the loggingLevel property of the Stage (https://docs.aws.amazon.com/apigateway/api-reference/resource/stage/#loggingLevel) resource in the Amazon API Gateway API Reference.
        """
        return pulumi.get(self, "logging_level")

    @property
    @pulumi.getter(name="metricsEnabled")
    def metrics_enabled(self) -> Optional[bool]:
        """
        Indicates whether Amazon CloudWatch metrics are enabled for methods in the stage.
        """
        return pulumi.get(self, "metrics_enabled")

    @property
    @pulumi.getter(name="resourcePath")
    def resource_path(self) -> Optional[str]:
        """
        The resource path for this method. Forward slashes (/) are encoded as ~1 and the initial slash must include a forward slash. For example, the path value /resource/subresource must be encoded as /~1resource~1subresource. To specify the root path, use only a slash (/). You can use an asterisk (*) as a wildcard to apply method settings to multiple methods.
        """
        return pulumi.get(self, "resource_path")

    @property
    @pulumi.getter(name="throttlingBurstLimit")
    def throttling_burst_limit(self) -> Optional[int]:
        """
        The number of burst requests per second that API Gateway permits across all APIs, stages, and methods in your AWS account.
        """
        return pulumi.get(self, "throttling_burst_limit")

    @property
    @pulumi.getter(name="throttlingRateLimit")
    def throttling_rate_limit(self) -> Optional[float]:
        """
        The number of steady-state requests per second that API Gateway permits across all APIs, stages, and methods in your AWS account.
        """
        return pulumi.get(self, "throttling_rate_limit")


@pulumi.output_type
class StageTag(dict):
    """
    Identify and categorize resources.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        Identify and categorize resources.
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:.
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class UsagePlanApiStage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiId":
            suggest = "api_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UsagePlanApiStage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UsagePlanApiStage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UsagePlanApiStage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_id: Optional[str] = None,
                 stage: Optional[str] = None,
                 throttle: Optional[Any] = None):
        """
        :param str api_id: The ID of an API that is in the specified Stage property that you want to associate with the usage plan.
        :param str stage: The name of the stage to associate with the usage plan.
        :param Any throttle: Map containing method-level throttling information for an API stage in a usage plan. The key for the map is the path and method for which to configure custom throttling, for example, '/pets/GET'. Duplicates are not allowed.
        """
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if stage is not None:
            pulumi.set(__self__, "stage", stage)
        if throttle is not None:
            pulumi.set(__self__, "throttle", throttle)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[str]:
        """
        The ID of an API that is in the specified Stage property that you want to associate with the usage plan.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter
    def stage(self) -> Optional[str]:
        """
        The name of the stage to associate with the usage plan.
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter
    def throttle(self) -> Optional[Any]:
        """
        Map containing method-level throttling information for an API stage in a usage plan. The key for the map is the path and method for which to configure custom throttling, for example, '/pets/GET'. Duplicates are not allowed.
        """
        return pulumi.get(self, "throttle")


@pulumi.output_type
class UsagePlanQuotaSettings(dict):
    def __init__(__self__, *,
                 limit: Optional[int] = None,
                 offset: Optional[int] = None,
                 period: Optional[str] = None):
        """
        :param int limit: The maximum number of requests that users can make within the specified time period.
        :param int offset: For the initial time period, the number of requests to subtract from the specified limit. When you first implement a usage plan, the plan might start in the middle of the week or month. With this property, you can decrease the limit for this initial time period.
        :param str period: The time period for which the maximum limit of requests applies, such as DAY or WEEK. For valid values, see the period property for the UsagePlan resource in the Amazon API Gateway REST API Reference.
        """
        if limit is not None:
            pulumi.set(__self__, "limit", limit)
        if offset is not None:
            pulumi.set(__self__, "offset", offset)
        if period is not None:
            pulumi.set(__self__, "period", period)

    @property
    @pulumi.getter
    def limit(self) -> Optional[int]:
        """
        The maximum number of requests that users can make within the specified time period.
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def offset(self) -> Optional[int]:
        """
        For the initial time period, the number of requests to subtract from the specified limit. When you first implement a usage plan, the plan might start in the middle of the week or month. With this property, you can decrease the limit for this initial time period.
        """
        return pulumi.get(self, "offset")

    @property
    @pulumi.getter
    def period(self) -> Optional[str]:
        """
        The time period for which the maximum limit of requests applies, such as DAY or WEEK. For valid values, see the period property for the UsagePlan resource in the Amazon API Gateway REST API Reference.
        """
        return pulumi.get(self, "period")


@pulumi.output_type
class UsagePlanTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class UsagePlanThrottleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "burstLimit":
            suggest = "burst_limit"
        elif key == "rateLimit":
            suggest = "rate_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UsagePlanThrottleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UsagePlanThrottleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UsagePlanThrottleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 burst_limit: Optional[int] = None,
                 rate_limit: Optional[float] = None):
        """
        :param int burst_limit: The maximum API request rate limit over a time ranging from one to a few seconds. The maximum API request rate limit depends on whether the underlying token bucket is at its full capacity.
        :param float rate_limit: The API request steady-state rate limit (average requests per second over an extended period of time).
        """
        if burst_limit is not None:
            pulumi.set(__self__, "burst_limit", burst_limit)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)

    @property
    @pulumi.getter(name="burstLimit")
    def burst_limit(self) -> Optional[int]:
        """
        The maximum API request rate limit over a time ranging from one to a few seconds. The maximum API request rate limit depends on whether the underlying token bucket is at its full capacity.
        """
        return pulumi.get(self, "burst_limit")

    @property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[float]:
        """
        The API request steady-state rate limit (average requests per second over an extended period of time).
        """
        return pulumi.get(self, "rate_limit")


@pulumi.output_type
class VpcLinkTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


